/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.sign;

import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.WorldW;

public class SignSystem
extends DetachedSystem<SignSystem, SignInstance> {
    public SignSystem(WorldW world) {
        super(world);
    }

    @Override
    public SystemManager.Systems getType() {
        return SystemManager.Systems.SIGN;
    }

    @Override
    public void onServerTick() {
        for (SystemRegion systemRegion : this.regions.values()) {
        }
    }

    @Override
    public void unload() {
        if (!this.world.isClient()) {
            this.regions.values().forEach(reg -> reg.save());
        }
        this.regions.clear();
    }

    @Override
    public void onChunkLoad(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.put(new RegionKey(chunk.x(), chunk.z()), chunk);
    }

    @Override
    public void onChunkUnload(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.values().removeIf(pre -> pre.x() == chunk.x() && pre.z() == chunk.z());
    }

    @Override
    public boolean hasTimer() {
        return true;
    }

    @Override
    public long getTimerInterval() {
        return Config.SIGN_SAVE_INTERVAL;
    }

    @Override
    public void addTimerTask(long time) {
        this.timer.schedule((TimerTask)new TimedTask(this), new Date(time), (long)Config.SIGN_SAVE_INTERVAL);
    }

    @Override
    public String getRegFolderName() {
        return "signregions";
    }

    @Override
    public void onClientTick() {
    }

    @Override
    public SignInstance create(SystemRegion<SignSystem, SignInstance> region, V3I pos) {
        return new SignInstance(region, pos);
    }

    @Override
    public void writeRegion(SystemRegion<SignSystem, SignInstance> region, TagCW com) {
        if (region.getObjects().isEmpty()) {
            return;
        }
        TagLW list = TagLW.create();
        for (SignInstance sign : region.getObjects().values()) {
            try {
                list.add(sign.write());
            }
            catch (Exception e) {
                FvtmLogger.log(e, "saving sign " + sign.vec + "  in region " + region.key.toString());
            }
        }
        com.set("Signs", list);
    }

    @Override
    public void readRegion(SystemRegion<SignSystem, SignInstance> region, TagCW com) {
        if (!com.has("Signs")) {
            return;
        }
        region.getObjects().clear();
        TagLW list = com.getList("Signs");
        for (TagCW tag : list) {
            try {
                SignInstance sign = new SignInstance(region);
                sign.read(tag);
                region.getObjects().put(sign.vec.pos, sign);
            }
            catch (Exception e) {
                FvtmLogger.log(e, "loading sign " + tag.direct() + "in region " + region.key.toString());
            }
        }
    }

    public static class TimedTask
    extends TimerTask {
        private SignSystem signsys;

        public TimedTask(SignSystem ssys) {
            this.signsys = ssys;
        }

        @Override
        public void run() {
            ArrayList<SystemRegion> regs = new ArrayList<SystemRegion>();
            for (SystemRegion region : this.signsys.regions.values()) {
                region.save();
                if (!region.chucks.isEmpty() || region.lastaccess >= Time.getDate() - 60000L) continue;
                regs.add(region);
            }
            for (SystemRegion region : regs) {
                this.signsys.regions.remove(region.key);
            }
        }
    }
}

