/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.nio.ByteBuffer;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.util.QV3D;

public class RegionKey
implements Comparable<RegionKey> {
    public final int x;
    public final int z;

    public RegionKey(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public RegionKey(int[] arr) {
        this.x = arr[0];
        this.z = arr[1];
    }

    public RegionKey(QV3D vec) {
        this(RegionKey.getRegionXZ(vec));
    }

    public RegionKey(V3I vec) {
        this(RegionKey.getRegionXZ(vec));
    }

    public RegionKey(long leng) {
        ByteBuffer buffer = ByteBuffer.allocate(8).putLong(leng);
        this.x = buffer.getInt(0);
        this.z = buffer.getInt(4);
    }

    public long toLong() {
        return ByteBuffer.allocate(8).putInt(this.x).putInt(this.z).getLong(0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RegionKey)) {
            return false;
        }
        return ((RegionKey)obj).x == this.x && ((RegionKey)obj).z == this.z;
    }

    @Override
    public int compareTo(RegionKey key) {
        if (key.x > this.x) {
            return 1;
        }
        if (key.x < this.x) {
            return -1;
        }
        if (key.z > this.z) {
            return 1;
        }
        if (key.z < this.z) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return this.x + ", " + this.z;
    }

    public int[] toArray() {
        return new int[]{this.x, this.z};
    }

    public static int[] getRegionXZ(int cx, int cz) {
        return new int[]{(int)Math.floor((double)cx / 32.0), (int)Math.floor((double)cz / 32.0)};
    }

    public static int[] getRegionXZ(QV3D vec) {
        return RegionKey.getRegionXZ(vec.pos.x >> 4, vec.pos.z >> 4);
    }

    public static int[] getRegionXZ(Vec3f pos) {
        return RegionKey.getRegionXZ((int)pos.x >> 4, (int)pos.z >> 4);
    }

    public static int[] getRegionXZ(V3D vec) {
        return RegionKey.getRegionXZ((int)vec.x >> 4, (int)vec.z >> 4);
    }

    public static int[] getRegionXZ(V3I vec) {
        return RegionKey.getRegionXZ(vec.x >> 4, vec.z >> 4);
    }

    public static int[] getRegionXZ(PathKey key) {
        return RegionKey.getRegionXZ(key.pos[0] >> 4, key.pos[2] >> 4);
    }

    public boolean isInRegion(QV3D vec) {
        int[] id = RegionKey.getRegionXZ(vec);
        return id[0] == this.x && id[1] == this.z;
    }

    public boolean isInRegion(V3I pos) {
        int[] id = RegionKey.getRegionXZ(pos);
        return id[0] == this.x && id[1] == this.z;
    }

    public boolean equalsKeyArray(int[] key) {
        return key.length > 1 && key[0] == this.x && key[1] == this.z;
    }
}

