/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.tag.TagCW;

public class WireRelay {
    protected String key;
    public V3D pos = new V3D();
    public ArrayList<Wire> wires;
    protected RelayHolder holder;
    protected AABB frustumbb;

    public WireRelay(RelayHolder holder, String key, V3D pos) {
        this.key = key;
        this.wires = new ArrayList();
        this.holder = holder;
        this.pos = pos;
    }

    protected WireRelay(RelayHolder holder) {
        this.holder = holder;
        this.wires = new ArrayList();
    }

    public WireRelay read(TagCW compound) {
        this.key = compound.getString("Key");
        int wiream = compound.getInteger("Wires");
        this.wires.clear();
        if (wiream > 0) {
            for (int i = 0; i < wiream; ++i) {
                try {
                    this.wires.add(new Wire(this).read(compound.getCompound("Wire" + i)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.pos = compound.getV3D("Pos");
        this.frustumbb = null;
        return this;
    }

    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        for (int i = 0; i < this.wires.size(); ++i) {
            compound.set("Wire" + i, this.wires.get(i).write(null));
        }
        compound.set("Wires", this.wires.size());
        compound.set("Key", this.key);
        compound.set("Pos", this.pos);
        return compound;
    }

    public String getKey() {
        return this.key;
    }

    public void addnew(Wire wire) {
        this.wires.add(wire);
        this.updateClient();
    }

    public void checkWireSectionConsistency() {
        if (this.wires.size() < 2) {
            return;
        }
    }

    public void updateClient() {
        ((WireSystem)this.holder.getRegion().system).updateClient("relay", null, this.holder.pos, this);
    }

    public void remove(int index, boolean firstcall) {
        Wire wire = this.wires.remove(index);
        if (wire == null) {
            return;
        }
        if (!firstcall) {
            // empty if block
        }
        this.updateClient();
        if (firstcall) {
            WireRelay relay = ((WireSystem)this.holder.getRegion().system).getRelay(wire.key.start_relay.equals(this.key) ? wire.okey : wire.key);
            if (relay != null) {
                relay.remove(wire.okey, false);
            }
        } else {
            this.checkWireSectionConsistency();
        }
    }

    private void remove(WireKey key, boolean firstcall) {
        for (int i = 0; i < this.wires.size(); ++i) {
            if (!this.wires.get((int)i).key.equals(key)) continue;
            this.remove(i, firstcall);
            return;
        }
    }

    public void clear() {
        ArrayList<Wire> wirrs = new ArrayList<Wire>();
        for (Wire wire : this.wires) {
            wirrs.add(wire);
        }
        for (Wire wire : wirrs) {
            this.remove(wire.key, true);
        }
        this.wires.clear();
        this.updateClient();
    }

    public final boolean eqWire(WireKey wire, int i) {
        return this.wires.get((int)i).key.equals(wire);
    }

    public Wire getWire(WireKey key) {
        for (Wire wire : this.wires) {
            if (!wire.key.equals(key)) continue;
            return wire;
        }
        return null;
    }

    public int size() {
        return this.wires.size();
    }

    public void onUpdate() {
    }

    public int getIndex(WireKey key) {
        for (int i = 0; i < this.wires.size(); ++i) {
            if (!this.eqWire(key, i)) continue;
            return i;
        }
        return -1;
    }

    public AABB getAABB() {
        if (this.frustumbb != null) {
            return this.frustumbb;
        }
        V3D min = new V3D();
        V3D max = new V3D();
        for (Wire wire : this.wires) {
            V3D other = wire.start;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (other.z > max.z) {
                max.z = other.z;
            }
            other = wire.end;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (!(other.z > max.z)) continue;
            max.z = other.z;
        }
        if (this.size() == 0) {
            min = new V3D(this.pos.x - (double)0.1f, this.pos.y - (double)0.1f, this.pos.z - (double)0.1f);
            max = new V3D(this.pos.x + (double)0.1f, this.pos.y + (double)0.1f, this.pos.z + (double)0.1f);
        }
        this.frustumbb = AABB.create(min.x, min.y, min.z, max.x, max.y, max.z);
        return this.frustumbb;
    }

    public String toString() {
        return "WireRelay{ " + this.key + ", " + this.wires.size() + " }";
    }

    public boolean isDuplicate(Wire other) {
        for (Wire wire : this.wires) {
            if (!wire.key.equals(other.key) && !wire.okey.equals(other.key)) continue;
            return true;
        }
        return false;
    }

    public RelayHolder getHolder() {
        return this.holder;
    }

    public <TE> TE getTile() {
        return this.holder.getTile();
    }
}

