/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.rail;

import java.util.Collections;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.rail.JuncType;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.SignalType;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.ui.rail.RailJunction;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class RailJunctionContainer
extends ContainerInterface {
    protected RailSystem sys;
    protected Junction junc;

    public RailJunctionContainer(JsonMap map, UniEntity player, V3I vec) {
        super(map, player, vec);
        this.sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.entity.getWorld());
        if (this.sys == null) {
            player.entity.closeUI();
        }
        this.junc = this.sys.getJunction(vec);
        if (this.junc == null) {
            player.entity.send("junction.not.found");
            player.entity.closeUI();
        }
    }

    public Object get(String key, Object ... objs) {
        switch (key) {
            case "": {
                return null;
            }
        }
        return null;
    }

    public void packet(TagCW com, boolean client) {
        String task;
        if (client) {
            ((RailJunction)this.ui).updateGrid();
            return;
        }
        switch (task = com.getString("task")) {
            case "switch0": {
                if (this.junc.type.isFork3()) {
                    if (this.junc.switch0) {
                        this.junc.switch0 = false;
                        this.junc.switch1 = true;
                    } else if (this.junc.switch1) {
                        this.junc.switch0 = false;
                        this.junc.switch1 = false;
                    } else {
                        this.junc.switch0 = true;
                        this.junc.switch1 = false;
                    }
                } else {
                    this.junc.switch0 = !this.junc.switch0;
                }
                this.junc.updateClient();
                break;
            }
            case "switch1": {
                this.junc.switch1 = !this.junc.switch1;
                this.junc.updateClient();
                break;
            }
            case "type_2": {
                if (this.junc.size() < 4) break;
                this.junc.type = JuncType.FORK_3;
                this.junc.updateClient();
                break;
            }
            case "type_3": {
                if (this.junc.size() < 4) break;
                this.junc.type = JuncType.DOUBLE;
                this.junc.updateClient();
                break;
            }
            case "type_4": {
                if (this.junc.size() < 4) break;
                this.junc.type = JuncType.CROSSING;
                this.junc.updateClient();
                break;
            }
            case "down0": {
                this.move(0, 1);
                break;
            }
            case "down1": {
                this.move(1, 1);
                break;
            }
            case "down2": {
                this.move(2, 1);
                break;
            }
            case "up1": {
                this.move(1, -1);
                break;
            }
            case "up2": {
                this.move(2, -1);
                break;
            }
            case "up3": {
                this.move(3, -1);
                break;
            }
            case "rem0": {
                this.remove(0);
                break;
            }
            case "rem1": {
                this.remove(1);
                break;
            }
            case "rem2": {
                this.remove(2);
                break;
            }
            case "rem3": {
                this.remove(3);
                break;
            }
            case "events": {
                this.player.entity.openUI(UIKeys.RAIL_JUNC_EVENTS, this.pos);
                return;
            }
            case "signal_edit": {
                this.player.entity.openUI(UIKeys.RAIL_SIGNAL, this.pos);
                return;
            }
            case "signal_remove": {
                this.junc.setSignal(SignalType.NONE, null);
            }
        }
        SEND_TO_CLIENT.accept(com, this.player);
    }

    private void move(int idx, int dir) {
        if (idx < 0 || idx >= this.junc.size()) {
            return;
        }
        Collections.swap(this.junc.tracks, idx, idx + dir);
        this.junc.updateClient();
    }

    private void remove(int idx) {
        if (idx >= this.junc.size()) {
            return;
        }
        this.junc.remove(idx, true);
    }
}

