/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class ContentConfigUtil {
    public static final IDL ITL_GENERAL = IDLManager.getIDLCached((String)"fvtm:textures/item/ph_general.png");
    public static final IDL ITL_VEHICLE = IDLManager.getIDLCached((String)"fvtm:textures/item/ph_vehicle.png");
    public static final IDL ITL_MBLOCK = IDLManager.getIDLCached((String)"fvtm:textures/item/ph_multiblock.png");
    public static final IDL ITL_PART = IDLManager.getIDLCached((String)"fvtm:textures/item/ph_part.png");

    public static IDL getID(JsonMap map) {
        if (map.has("ID")) {
            return IDLManager.getIDLCached((String)map.get("ID").string_value());
        }
        if (map.has("RegistryName")) {
            return IDLManager.getIDLCached((String)map.get("RegistryName").string_value());
        }
        return null;
    }

    public static IDL getID(Addon pack, JsonMap map) {
        String id = map.getString("ID", null);
        if (id == null) {
            id = (String)map.get("RegistryName", null);
        }
        if (id == null) {
            return null;
        }
        if (id.contains(":")) {
            return IDLManager.getIDLCached((String)id);
        }
        return IDLManager.getIDLCached((String)((pack == null ? "fvtm" : pack.getID().id()) + ":" + id));
    }

    public static Addon getAddon(JsonMap map) {
        if (map.has("Addon")) {
            String id = map.get("Addon").string_value();
            if (id.contains(":")) {
                id = id.split(":")[1];
            }
            for (Addon addon : FvtmRegistry.ADDONS) {
                if (!addon.getID().id().equals(id)) continue;
                return addon;
            }
        }
        return FvtmRegistry.ADDONS.get(FvtmRegistry.INTERNAL_ADDON_ID);
    }

    public static List<String> getStringList(JsonMap map, String key) {
        if (!map.has(key)) {
            return new ArrayList<String>();
        }
        if (map.get(key).isArray()) {
            return map.getArray(key).toStringList();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(map.get(key).string_value());
        return list;
    }

    public static IDL getItemTexture(IDL id, ContentType contype, JsonMap map) {
        if (map.has("ItemTexture")) {
            return IDLManager.getIDLCached((String)map.get("ItemTexture").string_value());
        }
        IDL idl = IDLManager.getIDLCached((String)(id.space() + ":textures/item/" + id.path() + ".png"));
        try {
            if (EnvInfo.CLIENT && FvtmResources.INSTANCE.getAssetInputStream(idl, EnvInfo.DEV) == null) {
                switch (contype) {
                    case VEHICLE: {
                        return ITL_VEHICLE;
                    }
                    case PART: {
                        return ITL_PART;
                    }
                    case MULTIBLOCK: {
                        return ITL_MBLOCK;
                    }
                }
                return ITL_GENERAL;
            }
        }
        catch (Throwable e) {
            FvtmLogger.log(e, "checking icon presence of " + (Object)((Object)contype) + "/" + id);
        }
        return idl;
    }

    public static List<IDL> getTextures(JsonMap map) {
        ArrayList<IDL> list = new ArrayList<IDL>();
        if (map.has("Texture")) {
            list.add(IDLManager.getIDLNamed((String)((String)map.get("Texture", (Object)"No Texture;fvtm:textures/entity/null.png"))));
        }
        if (map.has("Textures") && map.get("Textures").isArray()) {
            for (JsonValue tex : (List)map.get((String)"Textures").asArray().value) {
                list.add(IDLManager.getIDLNamed((String)tex.string_value()));
            }
        }
        if (list.isEmpty()) {
            list.add(IDLManager.getIDLNamed((String)"No Texture;fvtm:textures/entity/null.png"));
        }
        return list;
    }

    public static V3D getVector(JsonArray array) {
        V3D vec = new V3D();
        if (array.size() > 0) {
            vec.x = array.get(0).float_value();
        }
        if (array.size() > 1) {
            vec.y = array.get(1).float_value();
        }
        if (array.size() > 2) {
            vec.z = array.get(2).float_value();
        }
        return vec;
    }

    public static V3D getVector(JsonArray array, int offset) {
        V3D vec = new V3D();
        if (array.size() > offset + 0) {
            vec.x = array.get(offset + 0).float_value();
        }
        if (array.size() > offset + 1) {
            vec.y = array.get(offset + 1).float_value();
        }
        if (array.size() > offset + 2) {
            vec.z = array.get(offset + 2).float_value();
        }
        return vec;
    }

    public static V3D getVector(JsonMap map) {
        V3D vec = new V3D();
        vec.x = map.getFloat("x", 0.0f);
        vec.y = map.getFloat("y", 0.0f);
        vec.z = map.getFloat("z", 0.0f);
        return vec;
    }

    public static V3D getVector(JsonMap map, float x, float y, float z) {
        V3D vec = new V3D();
        vec.x = map.getFloat("x", x);
        vec.y = map.getFloat("y", y);
        vec.z = map.getFloat("z", z);
        return vec;
    }

    public static V3D getVector(JsonMap map, String prefix) {
        V3D vec = new V3D();
        vec.x = map.getFloat(prefix + "x", 0.0f);
        vec.y = map.getFloat(prefix + "y", 0.0f);
        vec.z = map.getFloat(prefix + "z", 0.0f);
        return vec;
    }
}

