/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExternalTextureLoader {
    private static final Map<String, IDL> map = new HashMap<String, IDL>();
    public static final String PREFIX = "fvtm:external/";

    public static IDL get(String s) {
        if (map.containsKey(s)) {
            return map.get(s);
        }
        IDL texture = IDLManager.getIDLNamed((String)("fvtm:external/:" + s));
        Object object = Minecraft.func_71410_x().field_71446_o.func_110581_b((ResourceLocation)texture.local());
        if (object == null) {
            SimplerThreadImageDownloader thid = new SimplerThreadImageDownloader(s, (ResourceLocation)texture.local());
            object = thid;
            Minecraft.func_71410_x().field_71446_o.func_110579_a((ResourceLocation)texture.local(), object);
        }
        map.put(s, texture);
        return texture;
    }

    @SideOnly(value=Side.CLIENT)
    public static class SimplerThreadImageDownloader
    extends SimpleTexture {
        private static final AtomicInteger THRID = new AtomicInteger(0);
        private final String url;
        private BufferedImage image;
        private Thread thread;
        private boolean uploaded;

        public SimplerThreadImageDownloader(String imgurl, ResourceLocation resloc) {
            super(resloc);
            this.url = imgurl;
        }

        private void checkIfUploaded() {
            if (this.uploaded || this.image == null) {
                return;
            }
            if (this.field_110568_b != null) {
                this.func_147631_c();
            }
            TextureUtil.func_110987_a((int)super.func_110552_b(), (BufferedImage)this.image);
            this.uploaded = true;
        }

        public int func_110552_b() {
            this.checkIfUploaded();
            return super.func_110552_b();
        }

        public void func_110551_a(IResourceManager resman) throws IOException {
            if (this.thread != null) {
                return;
            }
            this.thread = new Thread(() -> {
                HttpURLConnection conn = null;
                Print.log((Object)("Trying to download texture '" + this.url + "'."));
                try {
                    conn = (HttpURLConnection)new URL(this.url).openConnection(Minecraft.func_71410_x().func_110437_J());
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
                    conn.setDoInput(true);
                    conn.setDoOutput(false);
                    conn.connect();
                    if (conn.getResponseCode() == 200) {
                        this.image = TextureUtil.func_177053_a((InputStream)conn.getInputStream());
                        return;
                    }
                    Print.log((Object)("Received response code '" + conn.getResponseCode() + "'."));
                }
                catch (Exception e) {
                    Print.log((Object)"Errors during texture download");
                    e.printStackTrace();
                    return;
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            });
            this.thread.setName("FVTM External Texture # " + this.field_110568_b.toString());
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }
}

