/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.util.Matrix;
import net.fexcraft.mod.fvtm.util.VecUtil;
import net.fexcraft.mod.uni.tag.TagCW;

public class Pivot {
    private float ryaw;
    private float rpitch;
    private float rroll;
    private float dyaw;
    private float dpitch;
    private float droll;
    private Matrix matrix = new Matrix();

    public String toString() {
        return "Pivot[ " + this.ryaw + "y, " + this.rpitch + "p, " + this.rroll + "r ]";
    }

    public V3D get_vector(V3D relpos) {
        return VecUtil.rotate(relpos, (double)this.rroll, (double)this.rpitch, (double)this.ryaw);
    }

    public V3D get_vector(double x, double y, double z) {
        double[] d3 = VecUtil.rotate(new double[]{x, y, z}, (double)this.rroll, (double)this.rpitch, (double)this.ryaw);
        return new V3D(d3[0], d3[1], d3[2]);
    }

    public double[] get_vector(double[] arr) {
        return VecUtil.rotate(arr, (double)this.rroll, (double)this.rpitch, (double)this.ryaw);
    }

    public void save(TagCW tag) {
        tag.set("yaw", this.ryaw);
        tag.set("pitch", this.rpitch);
        tag.set("roll", this.rroll);
    }

    public static Pivot load(TagCW tag) {
        Pivot piv = new Pivot();
        piv.ryaw = tag.getFloat("yaw");
        piv.rpitch = tag.getFloat("pitch");
        piv.rroll = tag.getFloat("roll");
        piv.dyaw = Static.toDegrees((float)piv.ryaw);
        piv.dpitch = Static.toDegrees((float)piv.rpitch);
        piv.droll = Static.toDegrees((float)piv.rroll);
        return piv;
    }

    public float yaw() {
        return this.ryaw;
    }

    public float deg_yaw() {
        return this.dyaw;
    }

    public float pitch() {
        return this.rpitch;
    }

    public float deg_pitch() {
        return this.dpitch;
    }

    public float roll() {
        return this.rroll;
    }

    public float deg_roll() {
        return this.droll;
    }

    public void copy(Pivot axe) {
        this.ryaw = axe.ryaw;
        this.rroll = axe.rroll;
        this.rpitch = axe.rpitch;
        this.dyaw = axe.dyaw;
        this.dpitch = axe.dpitch;
        this.droll = axe.droll;
    }

    public Pivot copy() {
        Pivot piv = new Pivot();
        piv.ryaw = this.ryaw;
        piv.rpitch = this.rpitch;
        piv.rroll = this.rroll;
        piv.dyaw = this.dyaw;
        piv.dpitch = this.dpitch;
        piv.droll = this.droll;
        return piv;
    }

    public void set_yaw(float value, boolean degree) {
        this.set_rotation(degree ? Static.toRadians((float)value) : value, this.rpitch, this.rroll, false);
    }

    public void set_pitch(float value, boolean degree) {
        this.set_rotation(this.ryaw, degree ? Static.toRadians((float)value) : value, this.rroll, false);
    }

    public void set_roll(float value, boolean degree) {
        this.set_rotation(this.ryaw, this.rpitch, degree ? Static.toRadians((float)value) : value, false);
    }

    public void set_rotation(float y, float p, float r, boolean degrees) {
        if (degrees) {
            this.dyaw = y;
            this.dpitch = p;
            this.droll = r;
        } else {
            this.ryaw = y;
            this.rpitch = p;
            this.rroll = r;
        }
        this.convert(degrees);
    }

    public void set_rot(float y, float p, float r, boolean degrees) {
        this.set_rotation(y, p, r, degrees);
    }

    public void set_rotation(double y, double p, double r, boolean degrees) {
        this.set_rotation((float)y, (float)p, (float)r, degrees);
    }

    public void set_rot(double y, double p, double r, boolean degrees) {
        this.set_rotation((float)y, (float)p, (float)r, degrees);
    }

    private void convert(boolean deg) {
        this.matrix.reset();
        this.matrix.rotateX(deg ? Static.toRadians((float)this.droll) : this.rroll, 1.0f);
        this.matrix.rotateZ(deg ? Static.toRadians((float)this.dpitch) : this.rpitch, 1.0f);
        this.matrix.rotateY(deg ? Static.toRadians((float)this.dyaw) : this.ryaw, 1.0f);
        this.ryaw = (float)Math.atan2(this.matrix.m2[0], this.matrix.m0[0]);
        this.dyaw = this.ryaw * 180.0f / (float)Math.PI;
        this.rpitch = (float)Math.atan2(-this.matrix.m1[0], Math.sqrt(this.matrix.m1[2] * this.matrix.m1[2] + this.matrix.m1[1] * this.matrix.m1[1]));
        this.dpitch = this.rpitch * 180.0f / (float)Math.PI;
        this.rroll = (float)Math.atan2(this.matrix.m1[2], this.matrix.m1[1]);
        this.droll = this.rroll * 180.0f / (float)Math.PI;
    }

    public double[] toArray() {
        return new double[]{this.dyaw, this.dpitch, this.droll};
    }
}

