/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.StackWrapper;

public class Material
extends Content<Material>
implements WithItem,
ItemTextureable {
    protected byte max_stack;
    protected short max_health;
    protected String ore_dict;
    protected String container;
    protected String fuelgroup;
    protected String ctab;
    protected boolean vehicle_key;
    protected boolean fuel_container;
    protected int fuel_capacity;
    protected int burntime;
    protected int impact;
    protected IDL itemtexloc;
    protected Fuel fuel;

    @Override
    public Material parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Material");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.max_stack = (byte)map.getInteger("MaxItemStackSize", 64);
        this.max_health = (short)map.getInteger("MaxItemDamage", 0);
        this.ore_dict = map.getString("OreDictionary", null);
        this.container = map.getString("ContainerItem", null);
        this.burntime = map.getInteger("ItemBurnTime", 0);
        this.vehicle_key = map.getBoolean("VehicleKey", false);
        this.fuel_container = map.getBoolean("FuelContainer", false);
        this.fuel_capacity = map.getInteger("FuelCapacity", this.fuel_container ? 5000 : 0);
        this.fuel = map.has("FuelType") ? FvtmRegistry.getFuel(map.getString("FuelType", null)) : null;
        this.fuelgroup = map.getString("FuelGroup", null);
        this.impact = map.getInteger("ImpactWrench", -1);
        if (this.impact > 8) {
            this.impact = 8;
        }
        if (this.impact > -1) {
            this.max_stack = 1;
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.MATERIAL;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public int getMaxHealth() {
        return this.max_health;
    }

    public String getOreDictId() {
        return this.ore_dict;
    }

    public int getItemBurnTime() {
        return this.burntime;
    }

    public boolean isVehicleKey() {
        return this.vehicle_key;
    }

    public boolean isFuelContainer() {
        return this.fuel_container;
    }

    public int getFuelCapacity() {
        return this.fuel_capacity;
    }

    public Fuel getFuelType() {
        return this.fuel;
    }

    public String getFuelGroup() {
        return this.fuelgroup;
    }

    public boolean isUniversalFuelContainer() {
        return this.fuel == null && this.fuelgroup == null;
    }

    public boolean isValidFuel(Fuel fuel) {
        if (this.isUniversalFuelContainer()) {
            return true;
        }
        if (this.fuelgroup.contains(":")) {
            String[] split = this.fuelgroup.split(":");
            return split[0].equals(fuel.getPrimaryGroup()) && split[1].equals(fuel.getSecondaryGroup());
        }
        return this.fuelgroup.equals(fuel.getPrimaryGroup());
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public String getItemContainer() {
        return this.container;
    }

    public int getImpactLevel() {
        return this.impact;
    }

    public static boolean isFuelContainer(StackWrapper stack) {
        if (!stack.isItemOf(ContentType.MATERIAL.item_type)) {
            return false;
        }
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        return mat != null && mat.isFuelContainer();
    }
}

