/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.block;

import java.util.List;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class SeatBlockFunction
extends BlockFunction.StaticBlockFunction {
    private V3D offset;

    @Override
    public BlockFunction parse(JsonValue val) {
        this.offset = ContentConfigUtil.getVector(val.asArray());
        return this;
    }

    @Override
    public String id() {
        return "fvtm:seat";
    }

    public V3D getOffset() {
        return this.offset;
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, BlockData data, List<String> list, boolean adv) {
        list.add(Formatter.format((String)"&eSittable Block."));
    }

    @Override
    public boolean onClick(WorldW world, V3I pos, V3D hit, StateWrapper state, CubeSide side, EntityW player, boolean main) {
        if (!main) {
            return false;
        }
        if (!player.isRiding()) {
            world.spawnBlockSeat(this.offset.add((double)pos.x + 0.5, (double)pos.y, (double)pos.z + 0.5), player);
            return true;
        }
        return false;
    }
}

