/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.util.ClientPacketPlayer;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.generated.G_ROAD;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.block.JackEntity;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.RailVehicle;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.entity.WheelEntity;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.Resources21;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.impl.LevelW;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class WorldWIE
extends LevelW
implements FvtmWorld {
    public static class_238 aabb = new class_238(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0);
    public static class_238 aabb2 = new class_238(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);

    public WorldWIE(class_1937 world) {
        super(world);
    }

    @Override
    public SeatInstance getSeat(int entid, int seatid) {
        class_1297 ent = this.level.method_8469(entid);
        if (ent == null || !(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.seats.get(seatid);
    }

    @Override
    public SwivelPoint getSwivelPoint(int entid, String pointid) {
        class_1297 ent = this.level.method_8469(entid);
        if (ent == null || !(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.data.getRotationPoint(pointid);
    }

    @Override
    public Passenger getPassenger(int source) {
        return (Passenger)UniEntity.getApp((Object)this.level.method_8469(source), Passenger.class);
    }

    @Override
    public VehicleInstance getVehicle(int entid) {
        class_1297 ent = this.level.method_8469(entid);
        if (!(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle;
    }

    @Override
    public Map.Entry<VehicleData, InteractionHandler.InteractRef> getInteractRef(TagCW packet) {
        if (packet.has("entity")) {
            VehicleInstance inst = this.getVehicle(packet.getInteger("entity"));
            return inst == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(inst.data, inst.iref());
        }
        V3I pos = new V3I(packet.getIntArray("lift"), 0);
        JackEntity tile = (JackEntity)this.level.method_8321(new class_2338(pos.x, pos.y, pos.z));
        return tile == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(tile.getVehicle(), tile.iref());
    }

    @Override
    public boolean noViewEntity() {
        return ClientPacketPlayer.get() == null;
    }

    @Override
    public ArrayList<VehicleInstance> getVehicles(V3D pos) {
        ArrayList<VehicleInstance> list = new ArrayList<VehicleInstance>();
        VehicleInstance inst = null;
        List entities = this.level.method_8335(null, aabb.method_989(pos.x, pos.y, pos.z));
        block0: for (class_1297 entity : entities) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (list.contains(inst)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                list.add(inst);
            }
        }
        return list;
    }

    @Override
    public Map<VehicleData, InteractionHandler.InteractRef> getVehicleDatas(V3D pos) {
        LinkedHashMap<VehicleData, InteractionHandler.InteractRef> map = new LinkedHashMap<VehicleData, InteractionHandler.InteractRef>();
        VehicleInstance inst = null;
        List entities = this.level.method_8335(null, aabb.method_989(pos.x, pos.y, pos.z));
        block0: for (class_1297 entity : entities) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (map.containsKey(inst.data)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                map.put(inst.data, new InteractionHandler.InteractRef(inst));
            }
        }
        int xx = (int)pos.x >> 4;
        int zz = (int)pos.z >> 4;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                class_2818 chunk = this.level.method_8497(xx + x, zz + z);
                block4: for (class_2586 tile : chunk.method_12214().values()) {
                    JackEntity lift;
                    if (!(tile instanceof JackEntity) || (lift = (JackEntity)tile).getVehicle() == null) continue;
                    for (InteractZone zone : lift.getVehicle().getInteractZones().values()) {
                        if (map.containsKey(lift.getVehicle())) continue block4;
                        if (!zone.inRange(lift.getVehicle(), lift.getVehiclePos(), pos)) continue;
                        map.put(lift.getVehicle(), lift.iref());
                    }
                }
            }
        }
        return map;
    }

    @Override
    public Passenger getClientPassenger() {
        return (Passenger)UniEntity.getApp((Object)ClientPacketPlayer.get(), Passenger.class);
    }

    @Override
    public boolean isFvtmRoad(StateWrapper state) {
        return state.getBlock() instanceof Asphalt;
    }

    @Override
    public int getRoadHeight(StateWrapper state) {
        if (state.getBlock() instanceof Asphalt) {
            return ((Asphalt)((Object)state.getBlock())).height;
        }
        return 0;
    }

    @Override
    public StateWrapper getRoadWithHeight(StateWrapper block, int height) {
        if (!(block.getBlock() instanceof Asphalt)) {
            if (block.getBlock() instanceof G_ROAD) {
                return StateWrapper.of((Object)Resources21.ROAD_BLOCKS.get(((G_ROAD)((Object)block.getBlock())).type.getID())[height].method_9564());
            }
            class_2960 rl = class_7923.field_41175.method_10221((Object)((class_2248)block.getBlock()));
            String str = rl.toString();
            Optional hol = class_7923.field_41175.method_10223(class_2960.method_60654((String)((str = str.substring(0, str.lastIndexOf("_") + 1)) + height)));
            return hol.isPresent() ? StateWrapper.of((Object)((class_2248)((class_6880.class_6883)hol.get()).comp_349()).method_9564()) : StateWrapper.DEFAULT;
        }
        return StateWrapper.of((Object)Resources21.ASPHALT[height].method_9564());
    }

    @Override
    public void handleBlockEntityPacket(TagCW com, EntityW player) {
        class_2338 pos = class_2338.method_10092((long)com.getLong("pos"));
        class_2586 tile = this.level.method_8321(pos);
        if (tile instanceof PacketTagListener) {
            ((PacketTagListener)tile).handle(com, player);
        } else {
            FvtmLogger.debug((Object)("No receiver for packet '" + String.valueOf(com) + "' found. Dest: " + String.valueOf(pos)));
        }
    }

    @Override
    public void spawnRailEntity(RailEntity ent) {
        this.level.method_8649((class_1297)((RailVehicle)Resources21.RAIL_ENTITY.method_5883(this.level, class_3730.field_16465)).assign(ent));
    }

    @Override
    public void spawnLandEntity(VehicleData data, V3D pos, EntityW placer) {
        RootVehicle veh = (RootVehicle)Resources21.VEHICLE_ENTITY.method_5883(this.level, class_3730.field_16465);
        veh.method_5814(pos.x, pos.y, pos.z);
        veh.initVD(data);
        this.level.method_8649((class_1297)veh);
    }

    @Override
    public void spawnLandEntity(VehicleData data, VehicleInstance truck, EntityW placer) {
        RootVehicle veh = (RootVehicle)Resources21.VEHICLE_ENTITY.method_5883(this.level, class_3730.field_16465);
        veh.vehicle.front = truck;
        truck.rear = veh.vehicle;
        veh.initVD(data);
        veh.vehicle.point.updatePrevAxe();
        veh.vehicle.point.getPivot().copy(truck.point.getPivot());
        veh.method_33574(((class_1297)truck.entity.local()).method_19538());
        this.level.method_8649((class_1297)veh);
    }

    @Override
    public UniWheel spawnWheel(VehicleInstance vehicle, String id) {
        WheelEntity wheel = (WheelEntity)Resources21.WHEEL_ENTITY.method_5883(this.level, class_3730.field_16465);
        wheel.assign((RootVehicle)vehicle.entity.local(), id);
        this.level.method_8649((class_1297)wheel);
        return wheel;
    }
}

