/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.AxisRotator;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.Transforms;

public class BlockModel
extends DefaultModel {
    public static final BlockModel EMPTY = new BlockModel();
    public HashMap<String, ArrayList<BlockModel>> state_models = new HashMap();
    public float gui_translate_x = 0.0f;
    public float gui_translate_y = -0.25f;
    public float gui_translate_z = 0.0f;
    public float gui_scale_x = 0.75f;
    public float gui_scale_y = 0.75f;
    public float gui_scale_z = 0.75f;
    public boolean bindtex = true;
    public boolean defrot;
    public boolean rootrender;
    public BakedTransformData bk;
    public HashMap<String, String> tg;
    public boolean grouptexname;

    @Override
    public BlockModel parse(ModelData data) {
        super.parse(data);
        if (data.has("ItemScale")) {
            float scale;
            this.gui_scale_x = scale = data.getFloat("ItemScale", this.gui_scale_x);
            this.gui_scale_y = scale;
            this.gui_scale_z = scale;
        }
        if (data.has("ItemTranslate")) {
            JsonValue trs = data.get("ItemTranslate");
            if (trs.isValue()) {
                float translate;
                this.gui_translate_x = translate = data.getFloat("ItemTranslate", 0.0f);
                this.gui_translate_y = translate;
                this.gui_translate_z = translate;
            } else if (trs.isArray()) {
                this.gui_translate_x = trs.asArray().get(0).float_value();
                this.gui_translate_y = trs.asArray().get(1).float_value();
                this.gui_translate_z = trs.asArray().get(2).float_value();
            }
        }
        this.bindtex = data.getBoolean("DefaultTextureBinding", true);
        if (data.has("States")) {
            JsonMap states = data.getMap("States");
            for (Map.Entry entry2 : states.entries()) {
                Model model;
                if (((JsonValue)entry2.getValue()).isMap()) {
                    ArrayList list = new ArrayList();
                    for (Map.Entry e : ((JsonValue)entry2.getValue()).asMap().entries()) {
                        model = FvtmResources.getModel((String)e.getKey(), this.mergeModelData(data, ((JsonValue)e.getValue()).asMap()), BlockModel.class);
                        if (model == null) continue;
                        list.add((BlockModel)model);
                    }
                    if (list.size() <= 0) continue;
                    this.state_models.put((String)entry2.getKey(), list);
                    continue;
                }
                if (((JsonValue)entry2.getValue()).isArray()) {
                    for (JsonValue val : (List)((JsonValue)entry2.getValue()).asArray().value) {
                        ModelData md = this.mergeModelData(data, val.asMap());
                        model = null;
                        if (val.asMap().has("Model")) {
                            model = (BlockModel)FvtmResources.getModel(val.asMap().get("Model").string_value(), md, BlockModel.class);
                        } else {
                            model = this.copy();
                            ((BlockModel)model).parse(md).lock();
                        }
                        if (!this.state_models.containsKey(entry2.getKey())) {
                            this.state_models.put((String)entry2.getKey(), new ArrayList());
                        }
                        this.state_models.get(entry2.getKey()).add((BlockModel)model);
                    }
                    continue;
                }
                Model model2 = FvtmResources.getModel(((JsonValue)entry2.getValue()).string_value(), this.mergeModelData(data, new JsonMap()), BlockModel.class);
                if (model2 == null) continue;
                if (!this.state_models.containsKey(entry2.getKey())) {
                    this.state_models.put((String)entry2.getKey(), new ArrayList());
                }
                this.state_models.get(entry2.getKey()).add((BlockModel)model2);
            }
        }
        if (data.has("RotateY")) {
            this.transforms.add(new Transforms.TF_Rotate(0.0f, 1.0f, 0.0f, data.getFloat("RotateY", 0.0f)));
        }
        if (data.has("RotateZ")) {
            this.transforms.add(new Transforms.TF_Rotate(0.0f, 0.0f, 1.0f, data.getFloat("RotateZ", 0.0f)));
        }
        if (data.has("RotateX")) {
            this.transforms.add(new Transforms.TF_Rotate(1.0f, 0.0f, 0.0f, data.getFloat("RotateX", 0.0f)));
        }
        if (data.has("Translate")) {
            JsonArray array = data.getArray("Translate");
            this.transforms.add(new Transforms.TF_Translate(array.get(0).float_value(), array.get(1).float_value(), array.get(2).float_value()));
        }
        this.defrot = data.getBoolean("DefaultRotation", true);
        this.rootrender = data.getBoolean("RootRender", true);
        if (data.has("GroupTextures")) {
            this.tg = new HashMap();
            JsonMap grtex = data.getMap("GroupTextures");
            grtex.entries().forEach(entry -> {
                String tex;
                String[] stringArray;
                if (((String)entry.getKey()).contains(",")) {
                    stringArray = ((String)entry.getKey()).split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)entry.getKey();
                }
                String[] k = stringArray;
                String key = k.length > 1 ? k[0] + "," : "";
                String string = tex = k.length > 1 ? k[1] : k[0];
                if (((JsonValue)entry.getValue()).isArray()) {
                    for (JsonValue val : (List)((JsonValue)entry.getValue()).asArray().value) {
                        this.tg.put(key + val.string_value(), tex);
                    }
                } else {
                    this.tg.put(key + ((JsonValue)entry.getValue()).string_value(), tex);
                }
            });
        }
        this.grouptexname = data.getBoolean("GroupEqualsTexture", false);
        return this;
    }

    private ModelData mergeModelData(ModelData data, JsonMap map) {
        if (!map.getBoolean("Merge", true)) {
            return new ModelData(new JsonMap(new Object[]{"ModelData", map}));
        }
        ModelData md = new ModelData(new JsonMap(new Object[]{"ModelData", data.copy()}));
        md.rem("States");
        this.merge(md, map);
        return md;
    }

    private void merge(JsonMap root, JsonMap map) {
        for (Map.Entry entry : map.entries()) {
            if (root.has((String)entry.getKey())) {
                if (((JsonValue)entry.getValue()).isMap()) {
                    this.merge(root.getMap((String)entry.getKey()), ((JsonValue)entry.getValue()).asMap());
                    continue;
                }
                if (((JsonValue)entry.getValue()).isArray() && !((String)entry.getKey()).equals("Translate")) {
                    for (JsonValue val : (List)((JsonValue)entry.getValue()).asArray().value) {
                        root.getArray((String)entry.getKey()).add(val);
                    }
                    continue;
                }
            }
            root.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
    }

    protected BlockModel copy() {
        BlockModel model = new BlockModel();
        for (ModelGroup group : this.groups) {
            model.groups.add(group.copyWithoutPrograms());
        }
        return model;
    }

    public static class BakedTransformData {
        public AxisRotator rot_poly;
        public AxisRotator rot_meta;
        public AxisRotator[] rot_tf;
        public Vec3f translate;
        public Vec3f scale;
    }
}

