/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.FvtmBlockEntity;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.handler.AttrReqHandler;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailRegion;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.SignalType;
import net.fexcraft.mod.fvtm.sys.rail.TrackUnit;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.sys.wire.WireUnit;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.packet.PacketBase;
import net.fexcraft.mod.uni.packet.PacketTagListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.fexcraft.mod.uni.world.WorldW;

public abstract class Packets {
    public static HashMap<String, PacketTagListener> LIS_CLIENT = new HashMap();
    public static HashMap<String, PacketTagListener> LIS_SERVER = new HashMap();
    public static Packets INSTANCE = null;
    public static Class<? extends PacketBase> PKT_TAG = Packet_TagListener.class;

    public void init() {
        LIS_SERVER.put("attr_toggle", (com, player) -> AttrReqHandler.processToggleRequest(player, com));
        LIS_SERVER.put("attr_update", (com, player) -> AttrReqHandler.processUpdateRequest(player, com));
        LIS_SERVER.put("open_ui", (com, player) -> player.openUI(UIKey.byId((int)com.getInteger("ui")), new V3I(com.getIntArray("pos"), 0)));
        LIS_SERVER.put("vehicle", (com, player) -> {
            VehicleInstance inst = ((FvtmWorld)player.getWorld()).getVehicle(com.getInteger("entity"));
            if (inst != null) {
                inst.packet(com, player);
            }
        });
        LIS_SERVER.put("vehicle_packet", (com, player) -> {
            VehicleInstance inst = ((FvtmWorld)player.getWorld()).getVehicle(com.getInteger("entity"));
            if (inst != null) {
                inst.packet(com, player);
            }
        });
        LIS_SERVER.put("blockentity", (com, player) -> ((FvtmWorld)player.getWorld()).handleBlockEntityPacket(com, player));
        LIS_SERVER.put("mount_seat", (com, player) -> {
            VehicleInstance vehicle = ((FvtmWorld)player.getWorld()).getVehicle(com.getInteger("entity"));
            int index = com.getInteger("seat");
            if (index < 0 || index > vehicle.seats.size()) {
                return;
            }
            vehicle.onSeatInteract(vehicle.seats.get(index), player);
        });
        LIS_SERVER.put("install_part", (com, player) -> {
            StackWrapper wrapper = player.getHeldItem(true);
            PartData data = (PartData)wrapper.getContent(ContentType.PART.item_type);
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            String category = com.getString("category");
            if (ref.getKey().getPart(category) != null) {
                boolean valid;
                PartData oldpart = ref.getKey().getPart(category);
                boolean bl = valid = ((Part)oldpart.getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData && ((DefaultPartInstallHandler.DPIHData)((Part)oldpart.getType()).getInstallHandlerData()).swappable;
                if (valid && ref.getKey().deinstallPart((MessageSender)player, category, true)) {
                    player.drop(oldpart.getNewStack(), 0.0f);
                } else {
                    return;
                }
            }
            if ((data = ref.getKey().installPart((MessageSender)player, data, com.getString("source") + ":" + category, true)) == null) {
                wrapper.count(wrapper.count() - 1);
                if (ref.getValue().isVehicle()) {
                    ref.getValue().vehicle().sendUpdate("vehicledata");
                } else {
                    ref.getValue().holder().markChanged();
                    TagCW pkt = TagCW.create();
                    pkt.set("task", "update");
                    pkt.set("data", ref.getKey().write(null));
                    pkt.set("pos", ref.getValue().longpos());
                    Packets.sendToAll(Packet_TagListener.class, "blockentity", pkt);
                }
            }
        });
        LIS_SERVER.put("install_wheel", (com, player) -> {
            boolean tire;
            StackWrapper wrapper = player.getHeldItem(true);
            PartData data = (PartData)wrapper.getContent(ContentType.PART.item_type);
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            if (ref.getValue().isVehicle()) {
                player.send("interact.fvtm.vehicle.wheel_install");
                return;
            }
            String category = com.getString("category");
            data = ref.getKey().installPart((MessageSender)player, data, (String)((tire = ((Part)data.getType()).getInstallHandlerData() instanceof TireInstallationHandler.TireData) ? category + ":tire" : category), true);
            if (data == null) {
                wrapper.count(wrapper.count() - 1);
            }
            if (ref.getValue().isVehicle()) {
                ref.getValue().vehicle().sendUpdate("vehicledata");
            } else {
                ref.getValue().holder().markChanged();
                TagCW pkt = TagCW.create();
                pkt.set("task", "update");
                pkt.set("data", ref.getKey().write(null));
                pkt.set("pos", ref.getValue().longpos());
                Packets.sendToAll(Packet_TagListener.class, "blockentity", pkt);
            }
        });
        LIS_SERVER.put("remove_wheel", (com, player) -> {
            PartData wheel;
            StackWrapper wrapper = player.getHeldItem(true);
            Material mat = (Material)wrapper.getContent(ContentType.MATERIAL.item_type);
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            if (ref.getValue().isVehicle()) {
                player.send("interact.fvtm.vehicle.wheel_remove");
                return;
            }
            if (ref == null || mat.getImpactLevel() < ((Vehicle)ref.getKey().getType()).getImpactWrenchLevel()) {
                return;
            }
            String category = com.getString("category");
            PartData tire = ref.getKey().getPart(category + ":tire");
            if (tire != null) {
                if (ref.getKey().deinstallPart((MessageSender)player, category + ":tire", false)) {
                    player.drop(tire.getNewStack(), 0.0f);
                } else {
                    return;
                }
            }
            if ((wheel = ref.getKey().getPart(category)) != null && ref.getKey().deinstallPart((MessageSender)player, category, false)) {
                player.drop(wheel.getNewStack(), 0.0f);
            }
            if (ref.getValue().isVehicle()) {
                ref.getValue().vehicle().sendUpdate("vehicledata");
            } else {
                ref.getValue().holder().markChanged();
                TagCW pkt = TagCW.create();
                pkt.set("task", "update");
                pkt.set("data", ref.getKey().write(null));
                pkt.set("pos", ref.getValue().longpos());
                Packets.sendToAll(Packet_TagListener.class, "blockentity", pkt);
            }
        });
        LIS_SERVER.put("remove_part", (com, player) -> {
            StackWrapper wrapper = player.getHeldItem(true);
            if (!wrapper.isItemOf(ContentType.TOOLBOX.item_type)) {
                return;
            }
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            if (ref == null) {
                return;
            }
            String category = com.getString("category");
            PartData part = ref.getKey().getPart(category);
            if (part != null && ref.getKey().deinstallPart((MessageSender)player, category, false)) {
                player.drop(part.getNewStack(), 0.0f);
            }
            if (ref.getValue().isVehicle()) {
                ref.getValue().vehicle().sendUpdate("vehicledata");
            } else {
                ref.getValue().holder().markChanged();
                TagCW pkt = TagCW.create();
                pkt.set("task", "update");
                pkt.set("data", ref.getKey().write(null));
                pkt.set("pos", ref.getValue().longpos());
                Packets.sendToAll(Packet_TagListener.class, "blockentity", pkt);
            }
        });
        LIS_SERVER.put("texture_part", (com, player) -> {
            StackWrapper wrapper = player.getHeldItem(true);
            if (!wrapper.isItemOf(ContentType.TOOLBOX.item_type)) {
                return;
            }
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            if (ref == null || !ref.getValue().isVehicle()) {
                return;
            }
            String category = com.getString("category");
            PartData part = ref.getKey().getPart(category);
            if (part != null) {
                player.openUI(UIKeys.TOOLBOX_TEXTURE, new V3I(ref.getValue().vehicle().entity.getId(), ref.getKey().getPartIndex(part), 1));
            }
        });
        LIS_SERVER.put("relay_interact", (com, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            system.onRelayInteract(com, player);
        });
        LIS_SERVER.put("relay_remove", (com, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            system.onRelayRemove(com, player);
        });
        LIS_SERVER.put("relay_wire_slack", (com, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            system.onRelayWireSlack(com, player);
        });
        LIS_SERVER.put("relay_wire_deco", (com, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            system.onRelayWireDeco(com, player);
        });
        LIS_SERVER.put("open_inv", (com, player) -> {
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            FvtmInv inv = ref.getKey().getInvByIdx(com.getInteger("inventory"));
            player.openUI(inv.getUIKey(ContentType.valueOf(com.getString("type"))), ref.getValue().vehicle().entity.getId(), com.getInteger("inventory"), 0);
        });
        LIS_SERVER.put("sign_interact", (com, player) -> {
            SignSystem system = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, player.getWorld());
            QV3D pos = new QV3D(com, "pos");
            if (com.getBoolean("remove")) {
                system.del(pos.pos);
            } else if (com.getBoolean("item")) {
                Sign sign = (Sign)player.getHeldItem(true).getContent(ContentType.SIGN.item_type);
                SignData data = new SignData(sign).read(player.getHeldItem(true).directTag());
                SignInstance inst = (SignInstance)system.get(pos.pos);
                inst.components.add(data);
                inst.updateClient();
                if (!player.isCreative()) {
                    player.getHeldItem(true).decr(1);
                }
            } else {
                player.openUI(UIKeys.SIGN_EDITOR, pos.pos);
            }
        });
        LIS_SERVER.put("sync_reg", (com, player) -> {
            SystemManager.Systems sys = SystemManager.Systems.values()[com.getInteger("sys")];
            Object system = SystemManager.get(sys, player.getWorld());
            if (system == null) {
                return;
            }
            SystemRegion reg = ((DetachedSystem)system).getRegions().get(com.getIntArray("xz"));
            if (reg != null) {
                reg.sendSync(player);
            }
        });
        LIS_SERVER.put("upd_pass", (com, player) -> {
            UniEntity ent = player.getWorld().getUniEntity(com.getInteger("ent"));
            ent.runIfPresent(Passenger.class, pass -> pass.sendPassUpdate(ent.entity.getId(), pass.vehicle, pass.seat));
        });
        LIS_SERVER.put("attach_trailer", (com, player) -> {
            UniEntity ent = player.getWorld().getUniEntity(com.getInteger("ent"));
            Map.Entry<VehicleData, InteractionHandler.InteractRef> ref = ((FvtmWorld)player.getWorld()).getInteractRef(com);
            if (!ref.getValue().isVehicle()) {
                player.send("interact.fvtm.vehicle.wheel_remove");
                return;
            }
            VehicleData data = (VehicleData)player.getHeldItem(true).getContent(ContentType.VEHICLE.item_type);
            if (data == null || !((Vehicle)data.getType()).isTrailer()) {
                player.send("invalid item");
                return;
            }
            ((FvtmWorld)player.getWorld()).spawnLandEntity(data, ref.getValue().vehicle(), player);
            if (!player.isCreative()) {
                player.getHeldItem(true).decr(1);
            }
        });
        if (EnvInfo.CLIENT) {
            this.initClient();
        }
    }

    public void initClient() {
        LIS_CLIENT.put("attr_toggle", (tag, player) -> AttrReqHandler.processToggleResponse(player, tag));
        LIS_CLIENT.put("attr_update", (tag, player) -> AttrReqHandler.processUpdateResponse(player, tag));
        LIS_CLIENT.put("vehicle", (tag, player) -> {
            VehicleInstance inst = ((FvtmWorld)player.getWorld()).getVehicle(tag.getInteger("entity"));
            if (inst != null) {
                inst.packet(tag, player);
            }
        });
        LIS_CLIENT.put("vehicle_packet", (tag, player) -> {
            VehicleInstance inst = ((FvtmWorld)player.getWorld()).getVehicle(tag.getInteger("entity"));
            if (inst != null) {
                inst.packet(tag, player);
            }
        });
        LIS_CLIENT.put("vehicle_color", (tag, player) -> {
            VehicleInstance inst = ((FvtmWorld)player.getWorld()).getVehicle(tag.getInteger("vehicle"));
            if (inst != null) {
                inst.data.getColorChannel((String)tag.getString((String)"channel")).packed = tag.getInteger("color");
            }
        });
        LIS_CLIENT.put("road_tool_new", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            RoadPlacingUtil.CL_CURRENT = new RoadPlacingUtil.NewRoad(uuid, new QV3D(tag, "vector"), tag.getInteger("width"));
            RoadPlacingUtil.QUEUE.put(uuid, RoadPlacingUtil.CL_CURRENT);
        });
        LIS_CLIENT.put("road_tool_add", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(uuid);
            if (road == null) {
                return;
            }
            road.add(new QV3D(tag, "vector"), tag.getInteger("width"));
        });
        LIS_CLIENT.put("road_tool_selected", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(uuid);
            if (road == null) {
                return;
            }
            road.selected = tag.getInteger("selected");
        });
        LIS_CLIENT.put("road_tool_remove", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(uuid);
            if (road == null) {
                return;
            }
            road.remove(player, new QV3D(tag, "vector"));
        });
        LIS_CLIENT.put("road_tool_reset", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            if (RoadPlacingUtil.CL_CURRENT.id.equals(uuid)) {
                RoadPlacingUtil.CL_CURRENT = null;
            }
            RoadPlacingUtil.QUEUE.remove(uuid);
        });
        LIS_CLIENT.put("blockentity", (tag, player) -> ((FvtmWorld)player.getWorld()).handleBlockEntityPacket(tag, player));
        LIS_CLIENT.put("rail_upd_unit_section", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            TrackUnit unit = (TrackUnit)system.getTrackUnits().get(tag.getString("unit"));
            if (unit != null) {
                unit.setSection(system.getSection(tag.getLong("section")), false);
            }
        });
        LIS_CLIENT.put("rail_upd_sections", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            TagLW list = tag.getList("units");
            for (TagCW com : list) {
                TrackUnit unit = (TrackUnit)system.getTrackUnits().get(com.getString("unit"));
                if (unit == null) continue;
                unit.setSection(system.getSection(com.getLong("section")), false);
            }
            FvtmLogger.debug((Object)tag);
        });
        LIS_CLIENT.put("rail_spawn_ent", (tag, player) -> {
            FvtmLogger.debug((Object)"Receiving entity spawn request.");
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            SystemRegion region = system.getRegions().get(tag.getIntArray("region"), true);
            if (region != null && region.loaded) {
                RailRegion railreg = (RailRegion)region;
                railreg.spawnEntity(new RailEntity(railreg, tag.getLong("uid")).read(tag));
            } else {
                system.fillqueue.put(tag.getLong("uid"), tag.copy());
            }
        });
        LIS_CLIENT.put("rail_rem_ent", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            RailEntity ent = system.getEntity(tag.getLong("uid"), false);
            if (ent != null) {
                ent.remove();
            }
        });
        LIS_CLIENT.put("rail_upd_junc", (tag, player) -> {
            V3I vec;
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junction = system.getJunction(vec = tag.getV3I("pos"));
            if (junction != null) {
                junction.read(tag);
            } else {
                SystemRegion<RailSystem, Junction> region = system.getRegions().get(vec, false);
                if (region != null) {
                    Junction junc = new Junction(region);
                    junc.read(tag);
                    region.getObjects().put(vec, junc);
                }
            }
        });
        LIS_CLIENT.put("rail_rem_junc", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            system.delJunction(tag.getV3I("pos"));
        });
        LIS_CLIENT.put("rail_upd_junc_state", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junction = system.getJunction(tag.getV3I("pos"));
            if (junction != null) {
                junction.switch0 = tag.getBoolean("switch0");
                junction.switch1 = tag.getBoolean("switch1");
            }
        });
        LIS_CLIENT.put("rail_upd_junc_signal", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junction = system.getJunction(tag.getV3I("pos"));
            if (junction != null) {
                if (tag.getBoolean("nosignal")) {
                    junction.setSignal(SignalType.NONE, null);
                } else {
                    junction.sigtype0 = SignalType.values()[tag.getInteger("sig0")];
                    junction.sigtype1 = SignalType.values()[tag.getInteger("sig1")];
                }
                junction.signalpos1 = null;
                junction.signalpos0 = null;
            }
        });
        LIS_CLIENT.put("rail_upd_junc_signal_state", (tag, player) -> {
            RailSystem system = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.getWorld());
            Junction junction = system.getJunction(tag.getV3I("pos"));
            if (junction != null) {
                junction.sigstate0 = tag.getBoolean("signal0");
                junction.sigstate1 = tag.getBoolean("signal1");
            }
        });
        LIS_CLIENT.put("rail_place_util", (tag, player) -> {
            UUID uuid = new UUID(tag.getLong("uuid_m"), tag.getLong("uuid_l"));
            switch (tag.getString("subtask")) {
                case "new": {
                    RailPlacingUtil.CL_CURRENT = new RailPlacingUtil.NewTrack(uuid, new QV3D(tag, "vector"), FvtmRegistry.RAILGAUGES.get(tag.getString("gauge")));
                    RailPlacingUtil.QUEUE.put(uuid, RailPlacingUtil.CL_CURRENT);
                    break;
                }
                case "reset": {
                    if (RailPlacingUtil.CL_CURRENT.id.equals(uuid)) {
                        RailPlacingUtil.CL_CURRENT = null;
                    }
                    RailPlacingUtil.QUEUE.remove(uuid);
                    break;
                }
                case "add": {
                    RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(uuid);
                    if (track == null) {
                        return;
                    }
                    track.add(new QV3D(tag, "vector"));
                    break;
                }
                case "remove": {
                    RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(uuid);
                    if (track == null) {
                        return;
                    }
                    track.remove(player, new QV3D(tag, "vector"));
                    break;
                }
                case "selected": {
                    RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(uuid);
                    if (track == null) {
                        return;
                    }
                    track.selected = tag.getInteger("selected");
                }
            }
        });
        LIS_CLIENT.put("wire_upd_relay", (tag, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            RelayHolder holder = system.getHolder(tag.getV3I("pos"));
            String key = tag.getString("Key");
            if (holder != null && holder.contains(key)) {
                holder.get(key).read(tag);
            }
        });
        LIS_CLIENT.put("wire_rem_relay", (tag, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            RelayHolder holder = system.getHolder(tag.getV3I("pos"));
            holder.remove(tag.getString("key"));
        });
        LIS_CLIENT.put("wire_upd_holder", (tag, player) -> {
            Object tile;
            V3I pos;
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            RelayHolder holder = system.getHolder(pos = tag.getV3I("pos"));
            if (holder != null) {
                holder.read(tag);
            } else {
                SystemRegion region = system.getRegions().get(pos, false);
                if (region != null) {
                    holder = (RelayHolder)region.add(pos);
                    holder.read(tag);
                }
            }
            if (holder.getTile() == null && (tile = system.getWorld().getBlockEntity(pos)) instanceof FvtmBlockEntity) {
                holder.setTile(tile);
            }
        });
        LIS_CLIENT.put("wire_rem_holder", (tag, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            system.delHolder(tag.getV3I("pos"));
        });
        LIS_CLIENT.put("wire_udp_sections", (tag, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            TagLW list = tag.getList("units");
            for (TagCW com : list) {
                WireUnit unit = (WireUnit)system.getWireUnits().get(com.getString("unit"));
                if (unit == null) continue;
                unit.setSection(system.getSection(com.getLong("section")));
            }
        });
        LIS_CLIENT.put("wire_udp_unit", (tag, player) -> {
            WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, player.getWorld());
            WireUnit unit = (WireUnit)system.getWireUnits().get(tag.getString("unit"));
            if (unit != null) {
                unit.setSection(system.getSection(tag.getLong("section")));
            }
        });
        LIS_CLIENT.put("sign_upd", (tag, player) -> {
            SignSystem system = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, player.getWorld());
            V3I pos = new V3I(tag.getList("pos"));
            SystemRegion region = system.getRegions().get(pos, false);
            if (region != null) {
                region.add(pos).read(tag.getCompound("sign"));
            }
        });
        LIS_CLIENT.put("sign_rem", (tag, player) -> {
            SignSystem system = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, player.getWorld());
            system.del(new V3I(tag.getList("pos")));
        });
        LIS_CLIENT.put("sync_reg", (tag, player) -> {
            SystemManager.Systems sys = SystemManager.Systems.values()[tag.getInteger("sys")];
            Object system = SystemManager.get(sys, player.getWorld());
            if (system != null) {
                ((DetachedSystem)system).updateRegion(tag, player);
            }
        });
        LIS_CLIENT.put("sync_conf", (tag, player) -> {
            Config.VEHICLE_SYNC_RATE = tag.getByte("sync_rate");
        });
        LIS_CLIENT.put("upd_pass", (tag, player) -> {
            UniEntity ent = player.getWorld().getUniEntity(tag.getInteger("ent"));
            ent.runIfPresent(Passenger.class, pass -> pass.set(tag.getInteger("veh"), tag.getInteger("seat")));
        });
    }

    public abstract void writeTag(ByteBuf var1, TagCW var2);

    public abstract TagCW readTag(ByteBuf var1);

    @Deprecated
    public abstract void send(BlockData var1, WorldW var2, V3I var3);

    @Deprecated
    public abstract void send(WorldW var1, V3I var2);

    public abstract void send(VehicleInstance var1, TagCW var2);

    public abstract void send0(Class<? extends PacketBase> var1, Object ... var2);

    public static void send(Class<? extends PacketBase> packet, Object ... data) {
        INSTANCE.send0(packet, data);
    }

    public abstract void sendInRange0(Class<? extends PacketBase> var1, WorldW var2, V3D var3, int var4, Object ... var5);

    public static void sendInRange(Class<? extends PacketBase> packet, WorldW world, V3D pos, Object ... data) {
        INSTANCE.sendInRange0(packet, world, pos, Config.PACKET_RANGE, data);
    }

    public static void sendInRange(Class<? extends PacketBase> packet, WorldW world, V3I pos, Object ... data) {
        INSTANCE.sendInRange0(packet, world, new V3D(pos), Config.PACKET_RANGE, data);
    }

    public static void sendInRange(Class<? extends PacketBase> packet, EntityW pass, Object ... data) {
        Packets.sendInRange(packet, pass.getWorld(), pass.getPos(), data);
    }

    public abstract void sendToAllTrackingPos0(Class<? extends PacketBase> var1, WorldW var2, V3D var3, Object ... var4);

    public static void sendToAllTrackingPos(Class<? extends PacketBase> packet, WorldW world, V3I pos, Object ... data) {
        INSTANCE.sendToAllTrackingPos0(packet, world, new V3D(pos), data);
    }

    public static void sendToAllTrackingPos(Class<? extends PacketBase> packet, WorldW world, V3D pos, Object ... data) {
        INSTANCE.sendToAllTrackingPos0(packet, world, pos, data);
    }

    public abstract void sendToAllTrackingEnt0(Class<? extends PacketBase> var1, EntityW var2, Object ... var3);

    public static void sendToAllTrackingEnt(Class<? extends PacketBase> packet, EntityW ent, Object ... data) {
        INSTANCE.sendToAllTrackingEnt0(packet, ent, data);
    }

    public abstract void sendToAll0(Class<? extends PacketBase> var1, Object ... var2);

    public static void sendToAll(Class<? extends PacketBase> packet, Object ... data) {
        INSTANCE.sendToAll0(packet, data);
    }

    public abstract void sendTo0(Class<? extends PacketBase> var1, EntityW var2, Object ... var3);

    public static void sendTo(Class<? extends PacketBase> packet, EntityW to, Object ... data) {
        INSTANCE.sendTo0(packet, to, data);
    }
}

