/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import java.util.HashSet;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.model.content.RailGaugeModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.Renderer21;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.ui.rail.RailJunction;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class RailRenderer {
    private static RailSystem sys;
    private static boolean holding;
    private static HashSet<Junction> juncset;

    public static void renderRails(WorldRenderContext event) {
        if (Config.DISABLE_RAILS) {
            return;
        }
        sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)event.camera().method_19331().method_37908()));
        if (sys == null) {
            return;
        }
        class_4184 camera = event.camera();
        double cx = camera.method_19326().field_1352;
        double cy = camera.method_19326().field_1351;
        double cz = camera.method_19326().field_1350;
        class_4587 pose = event.matrixStack();
        Renderer21.set(pose, (class_4597)class_310.method_1551().method_22940().method_23000(), 0);
        holding = class_310.method_1551().field_1724.method_6047().method_7909() instanceof JunctionGridItem;
        pose.method_22903();
        pose.method_22904(-cx, -cy, -cz);
        Renderer21.resetColor();
        FvtmRenderTypes.setCutout(FvtmResources.WHITE_TEXTURE);
        for (SystemRegion reg : sys.getRegions().values()) {
            juncset.clear();
            juncset.addAll(reg.getObjects().values());
            for (Junction junc : juncset) {
                pose.method_22903();
                pose.method_22904(junc.getV3D().x, junc.getV3D().y, junc.getV3D().z);
                Renderer21.RENDERER.light(junc.getV3D());
                if (junc.tracks.size() == 0 || holding) {
                    DebugUtils.renderBB(0.25f, DebugUtils.COL_ORG);
                }
                if (junc.tracks.size() > 0 && holding) {
                    pose.method_46416(0.0f, junc.tracks.get((int)0).gauge.getHeight(), 0.0f);
                    FvtmRenderTypes.setCutout(FvtmResources.WHITE_TEXTURE);
                    Renderer21.setColor(DebugUtils.COL_GRY);
                    DebugUtils.JUNC_CORE.render();
                    for (int i = 0; i < junc.tracks.size(); ++i) {
                        RailRenderer.renderJuncModel(junc, i, DebugUtils.JUNC_LINE);
                    }
                    switch (junc.type) {
                        case STRAIGHT: {
                            if (junc.tracks.size() > 1 && !junc.sigtype0.none()) {
                                RailRenderer.renderJuncSignal(junc, 0, junc.sigstate0 ? RGB.GREEN : RGB.RED);
                            }
                            if (junc.tracks.size() <= 1 || junc.sigtype1.none()) break;
                            RailRenderer.renderJuncSignal(junc, 1, junc.sigstate1 ? RGB.GREEN : RGB.RED);
                            break;
                        }
                        case FORK_2: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : 2, DebugUtils.JUNC_DIR);
                            break;
                        }
                        case FORK_3: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : (junc.switch1 ? 3 : 2), DebugUtils.JUNC_DIR);
                            break;
                        }
                        case DOUBLE: {
                            RailRenderer.renderJuncModel(junc, junc.switch0 ? 1 : 2, DebugUtils.JUNC_DIR);
                            RailRenderer.renderJuncModel(junc, junc.switch1 ? 0 : 3, DebugUtils.JUNC_DIR);
                            break;
                        }
                    }
                }
                pose.method_22909();
                RailRenderer.renderRails(pose, junc);
            }
        }
        pose.method_22909();
    }

    private static void renderJuncModel(Junction junc, int idx, Polyhedron hed) {
        V3D pos = junc.tracks.get(idx).getVectorPosition0(junc.tracks.get((int)idx).length * 0.5, false);
        double ang = -Math.atan2(junc.tracks.get((int)idx).vecpath[0].z - pos.z, junc.tracks.get((int)idx).vecpath[0].x - pos.x) - (double)1.5708f;
        Renderer21.pushPose();
        Renderer21.rotateRad((float)ang, Renderer21.AY);
        Renderer21.setColor(RailJunction.TRACK_RGB[idx]);
        hed.render();
        Renderer21.popPose();
    }

    private static void renderJuncSignal(Junction junc, int idx, RGB col) {
        V3D pos = junc.tracks.get(idx).getVectorPosition0(junc.tracks.get((int)idx).length * 0.5, false);
        double ang = -Math.atan2(junc.tracks.get((int)idx).vecpath[0].z - pos.z, junc.tracks.get((int)idx).vecpath[0].x - pos.x) - (double)1.5708f;
        Renderer21.pushPose();
        Renderer21.rotateRad((float)ang, Renderer21.AY);
        Renderer21.setColor(RailJunction.TRACK_RGB[idx]);
        DebugUtils.JUNC_SIG_DIR.render();
        Renderer21.setColor(col);
        DebugUtils.JUNC_SIG_STATE.render();
        Renderer21.popPose();
    }

    private static void renderRails(class_4587 pose, Junction junc) {
        pose.method_22903();
        Renderer21.resetColor();
        for (int i = 0; i < junc.size(); ++i) {
            if (i > 2) {
                pose.method_22904(0.0, -0.02, 0.0);
            }
            if (junc.tracks.get(i).isOppositeCopy()) continue;
            pose.method_22903();
            Track track = junc.tracks.get(i);
            pose.method_22904(track.vecpath[0].x, track.vecpath[0].y, track.vecpath[0].z);
            RailGaugeModel model = track.gauge.getModel();
            if (track.railmodel == null) {
                PathModelGenerator.generateTrackModel(track, model);
            }
            FvtmRenderTypes.setCutout(track.gauge.getRailTexture());
            track.railmodel.render();
            FvtmRenderTypes.setCutout(track.gauge.getTiesTexture());
            track.restmodel.render();
            pose.method_22909();
        }
        pose.method_22909();
    }

    public static boolean renderGrid(WorldRenderContext event, class_239 res) {
        if (!(class_310.method_1551().field_1724.method_6047().method_7909() instanceof JunctionGridItem)) {
            return true;
        }
        if (!((JunctionGridItem)class_310.method_1551().field_1724.method_6047().method_7909()).showJunctionGrid()) {
            return true;
        }
        class_4587 pose = event.matrixStack();
        Renderer21.set(pose, (class_4597)class_310.method_1551().method_22940().method_23000(), 255);
        QV3D vec = new QV3D(res.method_17784().field_1352, res.method_17784().field_1351, res.method_17784().field_1350);
        class_2338 pos = class_2338.method_49638((class_2374)res.method_17784());
        double cx = event.camera().method_19326().field_1352;
        double cy = event.camera().method_19326().field_1351;
        double cz = event.camera().method_19326().field_1350;
        double yy = (float)vec.y * 0.0625f;
        Renderer21.resetColor();
        FvtmRenderTypes.setCutout(FvtmRegistry.WHITE_TEXTURE);
        pose.method_22903();
        pose.method_22904(-cx, -cy, -cz);
        for (int i = 0; i < 4; ++i) {
            pose.method_22903();
            pose.method_22904((double)pos.method_10263() + ((double)i * 0.25 + 0.125), (double)pos.method_10264() + yy + 0.01, (double)pos.method_10260() + 0.5);
            DebugUtils.LLBB2.render();
            pose.method_22909();
            pose.method_22903();
            pose.method_22904((double)pos.method_10263() + 0.5, (double)pos.method_10264() + yy + 0.01, (double)pos.method_10260() + ((double)i * 0.25 + 0.125));
            DebugUtils.LLBB0.render();
            pose.method_22909();
        }
        double v = vec.x < 0 ? (double)(-vec.x - 16) * -0.0625 : (double)vec.x * 0.0625;
        Renderer21.setColor(DebugUtils.COL_CYN);
        pose.method_22903();
        pose.method_22904((double)pos.method_10263() + v, (double)pos.method_10264() + yy + 0.01, (double)pos.method_10260() + 0.5);
        DebugUtils.LLBB2.render();
        pose.method_22909();
        v = vec.z < 0 ? (double)(-vec.z - 16) * -0.0625 : (double)vec.z * 0.0625;
        pose.method_22903();
        pose.method_22904((double)pos.method_10263() + 0.5, (double)pos.method_10264() + yy + 0.01, (double)pos.method_10260() + v);
        DebugUtils.LLBB0.render();
        pose.method_22909();
        Renderer21.setColor(DebugUtils.COL_ORG);
        pose.method_22904(vec.vec.x, vec.vec.y, vec.vec.z);
        pose.method_22905(0.03125f, 0.03125f, 0.03125f);
        DebugUtils.SPHERE.render();
        pose.method_22909();
        return true;
    }

    public static boolean renderRailPreview(WorldRenderContext event, class_239 res) {
        V3D vec1;
        V3D vec0;
        if (RailPlacingUtil.CL_CURRENT == null || RailPlacingUtil.CL_CURRENT.points.size() < 2) {
            return true;
        }
        double cx = event.camera().method_19326().field_1352;
        double cy = event.camera().method_19326().field_1351;
        double cz = event.camera().method_19326().field_1350;
        class_4587 pose = event.matrixStack();
        Renderer21.set(pose, (class_4597)class_310.method_1551().method_22940().method_23000(), 255);
        FvtmRenderTypes.setLines();
        pose.method_22903();
        pose.method_22904(-cx, -cy, -cz);
        RailPlacingUtil.NewTrack conn = RailPlacingUtil.CL_CURRENT;
        if (conn.preview == null) {
            conn.genpreview();
        }
        Renderer21.setColor(DebugUtils.COL_BLU);
        for (int j = 0; j < conn.track.vecpath.length - 1; ++j) {
            vec0 = conn.track.vecpath[j];
            vec1 = conn.track.vecpath[j + 1];
            DebugUtils.LINE_POLY.vertices[0].pos(vec0.x, vec0.y + (double)0.1f, vec0.z);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + (double)0.1f, vec1.z);
            DebugUtils.LINE.render();
        }
        int size = RailPlacingUtil.CL_CURRENT.points.size();
        Renderer21.setColor(DebugUtils.COL_CYN);
        for (int i = 1; i < size - 1; ++i) {
            double[] arr = conn.track.getPosition(conn.track.length / (double)(size - 1) * (double)i);
            vec1 = RailPlacingUtil.CL_CURRENT.points.get((int)i).vec;
            DebugUtils.LINE_POLY.vertices[0].pos(arr[0], arr[1] - (double)0.05f, arr[2]);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y - (double)0.05f, vec1.z);
            DebugUtils.LINE.render();
        }
        Renderer21.setColor(DebugUtils.COL_ORG);
        for (ArrayList<V3D> l : conn.preview) {
            for (int j = 0; j < l.size() - 1; ++j) {
                vec0 = l.get(j);
                DebugUtils.LINE_POLY.vertices[0].pos(vec0.x, vec0.y + (double)conn.gauge.getHeight() - 0.01, vec0.z);
                vec1 = l.get(j + 1);
                DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + (double)conn.gauge.getHeight() - 0.01, vec1.z);
                DebugUtils.LINE.render();
            }
        }
        Renderer21.resetColor();
        pose.method_22909();
        return true;
    }

    static {
        juncset = new HashSet();
    }
}

