/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.sign;

import java.util.concurrent.ConcurrentLinkedQueue;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.model.RenderCacheI;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class SignInstance
implements SysObj {
    public ConcurrentLinkedQueue<SignData> components = new ConcurrentLinkedQueue();
    private RenderCache cache;
    public SystemRegion<SignSystem, SignInstance> region;
    public float yaw;
    public QV3D vec;

    public SignInstance(SystemRegion<SignSystem, SignInstance> reg) {
        this.region = reg;
    }

    public SignInstance(SystemRegion<SignSystem, SignInstance> reg, V3I pos) {
        this(reg);
        this.vec = new QV3D(pos);
    }

    public SignInstance(SystemRegion<SignSystem, SignInstance> reg, QV3D pos) {
        this(reg);
        this.vec = pos;
    }

    @Override
    public void read(TagCW com) {
        this.components.clear();
        this.vec = new QV3D(com, "pos");
        this.yaw = com.getFloat("yaw");
        TagLW list = com.getList("comp");
        for (TagCW c : list) {
            try {
                this.components.add(FvtmResources.getSignData(c));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public TagCW write() {
        TagCW com = TagCW.create();
        this.vec.write(com, "pos");
        com.set("yaw", this.yaw);
        TagLW list = TagLW.create();
        for (SignData sd : this.components) {
            list.add(sd.write(TagCW.create()));
        }
        com.set("comp", list);
        return com;
    }

    @Override
    public void update() {
    }

    @Override
    public void delete() {
        TagCW com = TagCW.create();
        com.set("pos", this.vec.pos.toLW());
        Packets.sendToAllTrackingPos(Packet_TagListener.class, ((SignSystem)this.region.system).getWorld(), this.vec.pos, "sign_rem", com);
    }

    public void updateClient() {
        TagCW com = TagCW.create();
        com.set("pos", this.vec.pos.toLW());
        com.set("sign", this.write());
        Packets.sendToAllTrackingPos(Packet_TagListener.class, ((SignSystem)this.region.system).getWorld(), this.vec.pos, "sign_upd", com);
    }

    public RenderCache getRenderCache() {
        if (this.cache == null) {
            this.cache = new RenderCacheI();
        }
        return this.cache;
    }
}

