/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.ArrayList;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;

public class Axle {
    public final ArrayList<WheelTireData> wheels = new ArrayList();
    public final int id;
    public boolean powered;
    public boolean steering;
    public double weight_ratio;
    public double weight_on;
    public double yaw_speed;
    public double radius;
    public V3D pos;

    public Axle(int id, V3D pos) {
        this.id = id;
        this.pos = pos;
    }

    public void initCenter() {
        this.wheels.forEach(wtd -> {
            this.pos = this.pos.add(wtd.pos.x, 0.0, 0.0);
            this.radius += (double)wtd.radius;
            if (wtd.slot.steering) {
                this.steering = true;
            }
        });
        this.pos = new V3D(this.pos.x / (double)this.wheels.size(), this.pos.y, this.pos.z);
        this.radius /= (double)this.wheels.size();
    }

    public void calc(double mass, double acc, double height, double base, double yaw) {
        double ahb = 0.2 * acc * height / base;
        this.weight_on = mass * (this.weight_ratio * (double)9.81f + (this.pos.z < 0.0 ? -ahb : ahb));
        this.yaw_speed = -this.pos.z * yaw * 0.05;
    }

    public double getGrip(VehicleInstance vi) {
        double grip = 0.0;
        for (WheelTireData wheel : this.wheels) {
            double gr = wheel.function.getGripFor(null, vi.entity.getWorld().isRainingAt(((UniWheel)vi.wheels.get(wheel.id)).pos()));
            if (wheel.slot.braking && vi.pbrake) {
                gr *= (double)wheel.function.brake_grip;
            }
            grip += gr;
        }
        return grip / (double)this.wheels.size();
    }

    public double getFric(double slip, double grip) {
        double stif = 0.0;
        for (WheelTireData wheel : this.wheels) {
            stif += (double)wheel.function.getCornerStiffnessFor(null, wheel.slot.steering);
        }
        return Static.clamp((double)(-(stif / (double)this.wheels.size()) * slip), (double)(-grip), (double)grip) * this.weight_on;
    }
}

