/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.io.File;
import java.util.Timer;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegMap;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public abstract class DetachedSystem<S extends DetachedSystem<S, V>, V extends SysObj> {
    protected SystemRegMap<S, V> regions;
    protected WorldW world;
    protected Timer timer;
    protected File root;

    public DetachedSystem(WorldW world) {
        this.world = world;
        this.root = WrapperHolder.getWorldFolder((WorldW)world, (String)"fvtm");
        this.regions = new SystemRegMap(this, this::newRegion);
    }

    public SystemRegion<S, V> newRegion(RegionKey key) {
        return new SystemRegion(this, key);
    }

    public WorldW getWorld() {
        return this.world;
    }

    public abstract SystemManager.Systems getType();

    public void setupTimer(long time) {
        if (!this.hasTimer()) {
            return;
        }
        this.stopTimer();
        this.timer = new Timer();
        this.addTimerTask(time);
    }

    public void stopTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public abstract boolean hasTimer();

    public abstract long getTimerInterval();

    public void addTimerTask(long time) {
    }

    public File getSaveRoot() {
        return this.root;
    }

    public abstract String getRegFolderName();

    public abstract void unload();

    public abstract void onChunkLoad(ChunkW var1);

    public abstract void onChunkUnload(ChunkW var1);

    public abstract void onServerTick();

    public abstract void onClientTick();

    public void onTimerTick() {
    }

    public void syncPlayer(EntityW entity) {
        for (SystemRegion region : this.regions.values()) {
            region.sendSync(entity);
        }
    }

    public SystemRegMap<S, V> getRegions() {
        return this.regions;
    }

    public void updateRegion(TagCW compound, EntityW player) {
        RegionKey key = new RegionKey(compound.getIntArray("xz"));
        if (this.world.isClient()) {
            this.regions.get(key, true).read(compound);
        } else {
            this.regions.get(key, true).sendSync(player);
        }
    }

    public abstract V create(SystemRegion<S, V> var1, V3I var2);

    public V get(V3I pos) {
        SystemRegion<S, V> region = this.regions.get(pos, false);
        return region == null ? null : (V)region.get(pos);
    }

    public V get(V3I pos, boolean load) {
        SystemRegion<S, V> region = this.regions.get(pos, load);
        return region.get(pos);
    }

    public V add(V3I pos) {
        SystemRegion<S, V> region = this.regions.get(pos, true);
        return region.add(pos);
    }

    public void del(V3I pos) {
        SystemRegion<S, V> region = this.regions.get(pos, true);
        if (region != null) {
            region.del(pos);
        }
    }

    public void writeRegion(SystemRegion<S, V> region, TagCW com, boolean syncpkt) {
        this.writeRegion(region, com);
    }

    public void writeRegion(SystemRegion<S, V> region, TagCW com) {
    }

    public void readRegion(SystemRegion<S, V> region, TagCW com) {
    }
}

