/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;

public class PathKey
implements Comparable<PathKey> {
    private static final int[] order = new int[]{1, 0, 2, 4, 3, 5};
    protected int[] pos = new int[6];
    protected byte[] xyz = new byte[6];

    public PathKey(QV3D start, QV3D end) {
        this.pos[0] = start.pos.x;
        this.pos[1] = start.pos.y;
        this.pos[2] = start.pos.z;
        this.pos[3] = end.pos.x;
        this.pos[4] = end.pos.y;
        this.pos[5] = end.pos.z;
        this.xyz[0] = start.x;
        this.xyz[1] = start.y;
        this.xyz[2] = start.z;
        this.xyz[3] = end.x;
        this.xyz[4] = end.y;
        this.xyz[5] = end.z;
    }

    public String toUnitId(boolean opposite) {
        if (opposite) {
            return this.pos[3] + "," + this.pos[4] + "," + this.pos[5] + ";" + this.xyz[3] + "," + this.xyz[4] + "," + this.xyz[5] + ":" + this.pos[0] + "," + this.pos[1] + "," + this.pos[2] + ";" + this.xyz[0] + "," + this.xyz[1] + "," + this.xyz[2];
        }
        return this.pos[0] + "," + this.pos[1] + "," + this.pos[2] + ";" + this.xyz[0] + "," + this.xyz[1] + "," + this.xyz[2] + ":" + this.pos[3] + "," + this.pos[4] + "," + this.pos[5] + ";" + this.xyz[3] + "," + this.xyz[4] + "," + this.xyz[5];
    }

    public PathKey(TagCW compound) {
        if (compound.has("key_pos")) {
            this.pos = compound.getIntArray("key_pos");
        }
        if (compound.has("key_xyz")) {
            this.xyz = compound.getByteArray("key_xyz");
        }
    }

    public TagCW write(TagCW compound) {
        compound.set("key_pos", this.pos);
        compound.set("key_xyz", this.xyz);
        return compound;
    }

    public PathKey(PathKey key, boolean opposite) {
        if (opposite) {
            this.pos[0] = key.pos[3];
            this.pos[1] = key.pos[4];
            this.pos[2] = key.pos[5];
            this.pos[3] = key.pos[0];
            this.pos[4] = key.pos[1];
            this.pos[5] = key.pos[2];
            this.xyz[0] = key.xyz[3];
            this.xyz[1] = key.xyz[4];
            this.xyz[2] = key.xyz[5];
            this.xyz[3] = key.xyz[0];
            this.xyz[4] = key.xyz[1];
            this.xyz[5] = key.xyz[2];
        } else {
            this.pos = key.pos;
            this.xyz = key.xyz;
        }
    }

    @Override
    public int compareTo(PathKey o) {
        int i;
        for (i = 0; i < 6; ++i) {
            if (o.pos[order[i]] > this.pos[order[i]]) {
                return 1;
            }
            if (o.pos[order[i]] >= this.pos[order[i]]) continue;
            return -1;
        }
        for (i = 0; i < 6; ++i) {
            if (o.xyz[order[i]] > this.xyz[order[i]]) {
                return 1;
            }
            if (o.xyz[order[i]] >= this.xyz[order[i]]) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathKey)) {
            return false;
        }
        PathKey key = (PathKey)obj;
        for (int i = 0; i < 6; ++i) {
            if (key.pos[i] == this.pos[i] && key.xyz[i] == this.xyz[i]) continue;
            return false;
        }
        return true;
    }

    public QV3D toQV3D(int i) {
        return QV3D.exact(this.pos[0 + i], this.pos[1 + i], this.pos[2 + i], this.xyz[0 + i], this.xyz[1 + i], this.xyz[2 + i]);
    }

    public V3I toPos(int i) {
        return new V3I(this.pos[0 + i], this.pos[1 + i], this.pos[2 + i]);
    }

    public String toString() {
        return String.format("[ %s,%s - %s,%s - %s,%s / %s,%s - %s,%s - %s,%s ]", this.pos[0], this.xyz[0], this.pos[1], this.xyz[1], this.pos[2], this.xyz[2], this.pos[3], this.xyz[3], this.pos[4], this.xyz[4], this.pos[5], this.xyz[5]);
    }

    public String toPosString() {
        return String.format("[ %s, %s, %s / %s, %s, %s ]", this.pos[0], this.pos[1], this.pos[2], this.pos[3], this.pos[4], this.pos[5]);
    }
}

