/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import java.awt.Color;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JColorChooser;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class DecoEditor
extends UserInterface {
    private static final int rows = 12;
    private static ArrayList<String> colors = new ArrayList();
    private int scroll;
    public int selected = -1;
    public int selcol;

    public DecoEditor(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
    }

    public void init() {
        this.updateEntries();
        this.select(-1, -1);
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        boolean found = true;
        switch (id) {
            case "list_up": {
                --this.scroll;
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                this.updateEntries();
                break;
            }
            case "list_down": {
                ++this.scroll;
                this.updateEntries();
                break;
            }
            case "tex_prev": {
                if (this.selected < 0 || this.selected >= (Integer)this.container.get("decos.size", new Object[0])) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "tex");
                com.set("idx", this.selected);
                DecorationData data = (DecorationData)this.container.get("decos.at", new Object[]{this.selected});
                com.set("sel", data.getTexture().getSelected() - 1 < 0 ? ((Decoration)data.getType()).getDefaultTextures().size() - 1 : data.getTexture().getSelected() - 1);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "tex_next": {
                if (this.selected < 0 || this.selected >= (Integer)this.container.get("decos.size", new Object[0])) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "tex");
                com.set("idx", this.selected);
                DecorationData data = (DecorationData)this.container.get("decos.at", new Object[]{this.selected});
                com.set("sel", data.getTexture().getSelected() + 1 < ((Decoration)data.getType()).getDefaultTextures().size() ? data.getTexture().getSelected() + 1 : 0);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "ch_prev": {
                if (colors.isEmpty()) {
                    return true;
                }
                --this.selcol;
                if (this.selcol < 0) {
                    this.selcol = colors.size() - 1;
                }
                this.select(this.selected, this.selcol);
                break;
            }
            case "ch_next": {
                if (colors.isEmpty()) {
                    return true;
                }
                ++this.selcol;
                if (this.selcol >= colors.size()) {
                    this.selcol = 0;
                }
                this.select(this.selected, this.selcol);
                break;
            }
            case "rgb": {
                if (this.selected < 0 || this.selected >= (Integer)this.container.get("decos.size", new Object[0]) || colors.isEmpty()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "color");
                com.set("idx", this.selected);
                com.set("channel", colors.get(this.selcol));
                RGB rgb = RGB.WHITE;
                try {
                    String[] arr = ((UIField)this.fields.get("rgb")).text().split("\\,");
                    int r = Integer.parseInt(arr[0].trim());
                    int g = Integer.parseInt(arr[1].trim());
                    int b = Integer.parseInt(arr[2].trim());
                    rgb = new RGB(r, g, b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                com.set("rgb", rgb.packed);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "hex": {
                if (this.selected < 0 || this.selected >= (Integer)this.container.get("decos.size", new Object[0]) || colors.isEmpty()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "color");
                com.set("idx", this.selected);
                com.set("channel", colors.get(this.selcol));
                RGB rgb = RGB.WHITE;
                try {
                    rgb = new RGB(((UIField)this.fields.get("hex")).text());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                com.set("rgb", rgb.packed);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "colorpicker": {
                if (this.selected < 0 || this.selected >= (Integer)this.container.get("decos.size", new Object[0]) || colors.isEmpty()) {
                    return true;
                }
                try {
                    new Thread(){

                        @Override
                        public void run() {
                            Color color = JColorChooser.showDialog(null, "select color", new Color(((DecorationData)DecoEditor.this.container.get((String)"decos.at", (Object[])new Object[]{Integer.valueOf((int)DecoEditor.this.selected)})).getColorChannel((String)DecoEditor.colors.get((int)DecoEditor.this.selcol)).packed));
                            RGB rgb = new RGB(color.getRGB());
                            byte[] ar = rgb.toByteArray();
                            ((UIField)DecoEditor.this.fields.get("rgb")).text(ar[0] + 128 + ", " + (ar[1] + 128) + ", " + (ar[2] + 128));
                            ((UIField)DecoEditor.this.fields.get("hex")).text("#" + Integer.toHexString(rgb.packed).substring(2));
                        }
                    }.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                found = false;
            }
        }
        if (!found) {
            if (id.startsWith("entry_")) {
                int idx = Integer.parseInt(id.substring(6));
                this.selected = this.scroll + idx;
                this.select(this.selected, this.selcol);
                this.updateEntries();
                return true;
            }
            if (id.startsWith("rem_")) {
                int idx = Integer.parseInt(id.substring(4));
                TagCW com = TagCW.create();
                com.set("task", "rem");
                com.set("idx", this.scroll + idx);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            if (id.startsWith("pos")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "pos");
                com.set("axis", ax);
                com.set("idx", this.selected);
                com.set("value", ((UIField)this.fields.get(id)).number());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            if (id.startsWith("rot")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "rot");
                com.set("axis", ax);
                com.set("idx", this.selected);
                com.set("value", ((UIField)this.fields.get(id)).number());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            if (id.startsWith("scl")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "scale");
                com.set("axis", ax);
                com.set("idx", this.selected);
                com.set("value", ((UIField)this.fields.get(id)).number());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
        }
        return found;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        if (id.startsWith("pos")) {
            int ax = Integer.parseInt(id.substring(3));
            float val = ((UIField)this.fields.get(id)).number();
            ((UIField)this.fields.get("pos" + ax)).text("" + (val += am > 0 ? -1.0f : 1.0f));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        if (id.startsWith("rot")) {
            int ax = Integer.parseInt(id.substring(3));
            float val = ((UIField)this.fields.get(id)).number();
            ((UIField)this.fields.get("rot" + ax)).text("" + (val += am > 0 ? -1.0f : 1.0f));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        if (id.startsWith("scl")) {
            int ax = Integer.parseInt(id.substring(3));
            float val = ((UIField)this.fields.get(id)).number();
            ((UIField)this.fields.get("scl" + ax)).text("" + (val += am > 0 ? -1.0f : 1.0f));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        return false;
    }

    public void select(int idx, int colidx) {
        this.selected = idx;
        colors.clear();
        int decos = (Integer)this.container.get("decos.size", new Object[0]);
        DecorationData data = idx < 0 || idx >= decos ? null : (DecorationData)this.container.get("decos.at", new Object[]{idx});
        boolean miss = data == null;
        for (int i = 0; i < 3; ++i) {
            ((UIField)this.fields.get("pos" + i)).text((String)(miss ? "0" : "" + (i == 0 ? data.offset.x : (i == 1 ? data.offset.y : data.offset.z))));
            ((UIField)this.fields.get("rot" + i)).text((String)(miss ? "0" : "" + (i == 0 ? data.rotx : (i == 1 ? data.roty : data.rotz))));
            ((UIField)this.fields.get("scl" + i)).text((String)(miss ? "0" : "" + (i == 0 ? data.sclx : (i == 1 ? data.scly : data.sclz))));
        }
        ((UIText)this.texts.get("texc")).value(miss ? "" : data.getCurrentTexture().name());
        this.selcol = colidx;
        if (!miss) {
            colors.addAll(((TreeMap)data.getColorChannels()).keySet());
        }
        if (this.selcol >= colors.size() || this.selcol < 0) {
            this.selcol = 0;
        }
        ((UIText)this.texts.get("channel")).value(miss ? "" : (colors.isEmpty() ? "gui.fvtm.decoration_editor.no_color_channels" : colors.get(this.selcol)));
        ((UIText)this.texts.get("channel")).translate();
        RGB color = miss || colors.isEmpty() ? RGB.WHITE : data.getColorChannel(colors.get(this.selcol));
        byte[] ar = color.toByteArray();
        ((UIField)this.fields.get("rgb")).text(ar[0] + 128 + ", " + (ar[1] + 128) + ", " + (ar[2] + 128));
        ((UIField)this.fields.get("hex")).text("#" + Integer.toHexString(color.packed));
    }

    public void updateEntries() {
        int j = 0;
        for (int i = 0; i < 12; ++i) {
            j = this.scroll + i;
            boolean over = j >= (Integer)this.container.get("decos.size", new Object[0]);
            ((UIButton)this.buttons.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"entry_\u0001"}, (int)i))).text.value(over ? "" : this.container.get("decos.key", new Object[]{j}).toString());
            ((UIButton)this.buttons.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"entry_\u0001"}, (int)i))).text.translate();
            ((UIButton)this.buttons.get("rem_" + i)).visible(true);
            ((UIButton)this.buttons.get("entry_" + i)).enabled(this.selected != j);
        }
    }

    public void predraw(float ticks, int mx, int my) {
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public void scrollwheel(int a, int x, int y) {
        if (x > 1 && x < 139 && y > 20 && y < 188) {
            this.scroll += a > 0 ? 1 : -1;
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            this.updateEntries();
        }
    }
}

