/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.rail;

import java.util.ArrayList;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;
import net.fexcraft.mod.fvtm.sys.event.EventAction;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.rail.RailJuncEvents;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class RailJuncEventsCon
extends ContainerInterface {
    protected RailSystem sys;
    protected Junction junc;

    public RailJuncEventsCon(JsonMap map, UniEntity player, V3I vec) {
        super(map, player, vec);
        this.sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, player.entity.getWorld());
        if (this.sys == null) {
            player.entity.closeUI();
        }
        this.junc = this.sys.getJunction(vec);
        if (this.junc == null) {
            player.entity.send("junction.not.found");
            player.entity.closeUI();
        }
    }

    public Object get(String key, Object ... objs) {
        return null;
    }

    public void packet(TagCW com, boolean client) {
        String task;
        if (client) {
            ((RailJuncEvents)this.ui).updateListener();
            return;
        }
        switch (task = com.getString("task")) {
            case "add": {
                EventType type = EventType.parse(com.getString("type"));
                if (!EventType.JUNCTION_EVENTS.contains(type)) {
                    return;
                }
                if (!this.junc.holder.listeners.containsKey(type)) {
                    this.junc.holder.listeners.put(type, new ArrayList());
                }
                this.junc.holder.listeners.get(type).add(new EventListener(type.key, "true", "logger", "empty {event} listener in {junction}"));
                this.junc.updateClient();
                break;
            }
            case "rem": {
                int idx;
                EventType type = EventType.parse(com.getString("type"));
                if (!EventType.JUNCTION_EVENTS.contains(type)) {
                    return;
                }
                if (this.junc.holder.listeners.containsKey(type) && (idx = com.getInteger("sel")) >= 0 && idx < this.junc.holder.listeners.get(type).size()) {
                    this.junc.holder.listeners.get(type).remove(idx);
                }
                this.junc.updateClient();
                break;
            }
            case "save": {
                int idx;
                EventType type = EventType.parse(com.getString("type"));
                if (!EventType.JUNCTION_EVENTS.contains(type)) {
                    return;
                }
                if (!this.junc.holder.listeners.containsKey(type) || (idx = com.getInteger("sel")) < 0 || idx >= this.junc.holder.listeners.get(type).size()) break;
                EventListener lis = this.junc.holder.listeners.get(type).get(idx);
                lis.cond = ConditionRegistry.parse(com.getString("cond"));
                lis.action = EventAction.parse(com.getString("act"));
                lis.args = EventListener.parseArg(com.getString("arg"));
                lis.cond.link();
                this.junc.updateClient();
                break;
            }
        }
        SEND_TO_CLIENT.accept(com, this.player);
    }
}

