/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.util.OBB;

public class CollisionUtil {
    public static V3D check(OBB a, OBB b) {
        return CollisionUtil.overlaps(a.getCollisionAxes(b), b.verts, a.verts);
    }

    private static V3D overlaps(V3D[] axes, V3D[] b_verts, V3D[] a_verts) {
        double min_ov = Double.POSITIVE_INFINITY;
        V3D min_ax = null;
        for (int i = 0; i < axes.length; ++i) {
            double overlap;
            double val;
            int j;
            V3D axis = axes[i];
            double b_min = axis.dot(b_verts[0]);
            double a_min = axis.dot(a_verts[0]);
            double b_max = b_min;
            double a_max = a_min;
            if (axis.equals((Object)V3D.NULL)) continue;
            for (j = 1; j < b_verts.length; ++j) {
                val = b_verts[j].dot(axis);
                if (val < b_min) {
                    b_min = val;
                }
                if (!(val > b_max)) continue;
                b_max = val;
            }
            for (j = 1; j < a_verts.length; ++j) {
                val = a_verts[j].dot(axis);
                if (val < a_min) {
                    a_min = val;
                }
                if (!(val > a_max)) continue;
                a_max = val;
            }
            double d = a_min < b_min ? (a_max < b_min ? 0.0 : a_max - b_min) : (overlap = b_max < a_min ? 0.0 : b_max - a_min);
            if (overlap <= 0.0) {
                return null;
            }
            if (Math.abs(a_min - b_min) > Math.abs(a_max - b_max)) {
                axis = axis.scale(-1.0);
            }
            if (!(overlap < min_ov)) continue;
            min_ov = overlap;
            min_ax = axis;
        }
        return min_ax == null ? V3D.NULL : min_ax.scale(min_ov);
    }
}

