/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.uni.ConfigBase;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniReg;

public class Config
extends ConfigBase {
    public static ArrayList<File> PACK_FOLDERS = new ArrayList();
    public static boolean VEHICLES_NEED_FUEL;
    public static boolean VEHICLES_DROP_CONTENTS;
    public static boolean UNBREAKABLE_CONTAINERS;
    public static boolean ROADTOOL_FOR_ALL;
    public static boolean DISMOUNT_ON_LOGOUT;
    public static String[] DEFAULT_TRAFFIC_SIGN_LIBRARIES;
    public static int PACKET_RANGE;
    public static boolean RENDER_OUT_OF_VIEW;
    public static boolean DISABLE_LIGHT_BEAMS;
    public static boolean RENDER_VEHICLES_SEPARATELY;
    public static boolean RENDER_BLOCKS_SEPARATELY;
    public static boolean DISABLE_PARTICLES;
    public static int SIGNAL_INTERVAL;
    public static float MOTION_SCALE;
    public static byte VEHICLE_SYNC_RATE;
    public static float STEER_RESET_RATE;
    public static boolean DISABLE_RAILS;
    public static int UNLOAD_INTERVAL;
    public static int RAIL_SEGMENTATOR;
    public static int MAX_RAIL_TRACK_LENGTH;
    public static boolean DISABLE_ROADS;
    public static int MAX_ROAD_LENGTH;
    public static int ROAD_UNDO_CACHE_SIZE;
    public static int ROAD_UNDO_CACHE_CLEARTIME;
    public static boolean DISABLE_WIRES;
    public static int MAX_WIRE_LENGTH;
    public static float WIRE_SLACK_ADJUSTMENT;
    public static boolean DISABLE_SIGNS;
    public static int SIGN_VIEW_DISTANCE;
    public static boolean OVERLAY_ON_BOTTOM;

    public Config(File file) {
        super(file, "FVTM");
    }

    protected void fillInfo(JsonMap map) {
        map.add("info", "FVTM Main Configuration File");
        map.add("wiki", "https://fexcraft.net/wiki/mod/fvtm");
        map.addArray("pack_folders");
    }

    protected void fillEntries() {
        String catg = "general";
        String catc = "client";
        String catu = "u12/basic";
        String catv = "vehicle";
        String catr = "rail";
        String cato = "road";
        String catw = "wire";
        String cats = "sign";
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "dev_mode", new JsonValue((Object)EnvInfo.DEV)).info("If the FVTM Dev Mode (generally more logging) should be enabled.").cons((con, map) -> {
            EnvInfo.DEV = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "vehicles_need_fuel", new JsonValue((Object)true)).info("If vehicles need Fuel (in survival mode) to function.").cons((con, map) -> {
            VEHICLES_NEED_FUEL = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "vehicle_drop_contents", new JsonValue((Object)false)).info("If vehicles should drop their inventory contents upon being removed.").cons((con, map) -> {
            VEHICLES_DROP_CONTENTS = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "vehicle_drop_contents", new JsonValue((Object)false)).info("If containers should be unbreakable (via tools/hand).").cons((con, map) -> {
            UNBREAKABLE_CONTAINERS = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "road_tool_for_all", new JsonValue((Object)false)).info("When not using a Forge PermissionsAPI compatible permission manager, to allow any player to use the Road Placing Tool.").cons((con, map) -> {
            ROADTOOL_FOR_ALL = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "dismount_on_logout", new JsonValue((Object)true)).info("If players should automatically dismount vehicles on log out (leaving server).").cons((con, map) -> {
            DISMOUNT_ON_LOGOUT = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "traffic_sign_libraries", (JsonValue)new JsonArray(new Object[]{"default_fexcraft;http://fexcraft.net/files/mod_data/fvtm/default_traffic_sign_library.json"})).info("List of External Traffic Sign Libraries. Separate the ID from the URL using a semicolon.").cons((con, map) -> {
            DEFAULT_TRAFFIC_SIGN_LIBRARIES = con.getJson(map).asArray().toStringArray();
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "update_packet_range", new JsonValue((Object)256)).rang(64.0f, 4096.0f).info("Range in which ranged update packets are sent.").cons((con, map) -> {
            PACKET_RANGE = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "render_out_of_view", new JsonValue((Object)false)).info("If vehicles should be rendered out of default view.").cons((con, map) -> {
            RENDER_OUT_OF_VIEW = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "disable_light_beams", new JsonValue((Object)false)).info("If light beam rendering should be disabled.").cons((con, map) -> {
            DISABLE_LIGHT_BEAMS = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "render_vehicles_separately", new JsonValue((Object)true)).info("If vehicles should be rendered separately in a new render pass. Allows for higher view distance.").cons((con, map) -> {
            RENDER_VEHICLES_SEPARATELY = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "render_blocks_separately", new JsonValue((Object)false)).info("If blocks (with entity) should be rendered separately in a new render pass. Allows for higher view distance.").cons((con, map) -> {
            RENDER_BLOCKS_SEPARATELY = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "disable_particles", new JsonValue((Object)false)).info("If FVTM particles (particle system) should be disabled.").cons((con, map) -> {
            DISABLE_PARTICLES = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "signal_interval", new JsonValue((Object)750)).info("Blinker/Turn/Emergency Signal toggle interval, in milliseconds.").rang(100.0f, 2000.0f).cons((con, map) -> {
            SIGNAL_INTERVAL = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catc, "sign_view_distance", new JsonValue((Object)300)).info("View distance for road/traffic signs.").rang(1.0f, 40960.0f).cons((con, map) -> {
            SIGN_VIEW_DISTANCE = con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catu, "motion_scale", new JsonValue((Object)Float.valueOf(0.2f))).info("Physics Motion Scale Multiplier.").rang(0.001f, 2.0f).cons((con, map) -> {
            MOTION_SCALE = con.getFloat(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catv, "sync_rate", new JsonValue((Object)5)).info("Entity sync rate in ticks. Lesser value means higher sync AND higher bandwidth. Higher value means slower sync and less bandwidth.").rang(1.0f, 10.0f).cons((con, map) -> {
            VEHICLE_SYNC_RATE = (byte)con.getInteger(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catv, "steer_reset_rate", new JsonValue((Object)0.9)).info("Steer multiplier per tick. 1 = no reset, 0 = full reset each tick.").rang(0.0f, 1.0f).cons((con, map) -> {
            STEER_RESET_RATE = con.getFloat(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catr, "disable", new JsonValue((Object)false)).info("If FVTM rail system should be disabled.").cons((con, map) -> {
            DISABLE_RAILS = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catr, "unload_interval", new JsonValue((Object)300000)).info("Interval (milliseconds) in which it is checked for trains/rails to be unloaded.").cons((con, map) -> {
            UNLOAD_INTERVAL = con.getInteger(map);
        }).rang(60000.0f, 8.64E7f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catr, "generation_segmentator", new JsonValue((Object)4)).info("Segmentator divider for rail generator, valid are 16, 8, 4, 2 or 1.").cons((con, map) -> {
            RAIL_SEGMENTATOR = con.getInteger(map);
            if (RAIL_SEGMENTATOR > 16) {
                RAIL_SEGMENTATOR = 16;
            }
            if (RAIL_SEGMENTATOR > 8 && RAIL_SEGMENTATOR < 16) {
                RAIL_SEGMENTATOR = 8;
            }
            if (RAIL_SEGMENTATOR > 4 && RAIL_SEGMENTATOR < 8) {
                RAIL_SEGMENTATOR = 4;
            }
            if (RAIL_SEGMENTATOR > 2 && RAIL_SEGMENTATOR < 4) {
                RAIL_SEGMENTATOR = 2;
            }
            if (RAIL_SEGMENTATOR < 1) {
                RAIL_SEGMENTATOR = 1;
            }
        }).rang(1.0f, 16.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catr, "max_length", new JsonValue((Object)32)).info("Max total vector length of new placed rail tracks.").cons((con, map) -> {
            MAX_RAIL_TRACK_LENGTH = con.getInteger(map);
        }).rang(1.0f, 256.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, cato, "disable", new JsonValue((Object)false)).info("If FVTM road system should be disabled.").cons((con, map) -> {
            DISABLE_ROADS = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, cato, "max_length", new JsonValue((Object)256)).info("Max total vector length of new placed roads.").cons((con, map) -> {
            MAX_ROAD_LENGTH = con.getInteger(map);
        }).rang(4.0f, 4096.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, cato, "undo_cache_size", new JsonValue((Object)8)).info("How many roads should be remembered in the undo cache. Set '0' to disable the undo cache.").cons((con, map) -> {
            ROAD_UNDO_CACHE_SIZE = con.getInteger(map);
        }).rang(0.0f, 32.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, cato, "undo_cache_cleartime", new JsonValue((Object)5)).info("After how many minutes the undo cache of a player should reset. Useful if your players have unstable connection. Set to '0' for instant deletion.").cons((con, map) -> {
            ROAD_UNDO_CACHE_CLEARTIME = con.getInteger(map);
        }).rang(0.0f, 60.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catw, "disable", new JsonValue((Object)false)).info("If FVTM wire system should be disabled.").cons((con, map) -> {
            DISABLE_WIRES = con.getBoolean(map);
        }));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catw, "max_length", new JsonValue((Object)64)).info("Max total vector length of new placed wires.").cons((con, map) -> {
            MAX_WIRE_LENGTH = con.getInteger(map);
        }).rang(1.0f, 1024.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catw, "slack_adjustment", new JsonValue((Object)Float.valueOf(0.5f))).info("Default slack adjustment value when using the toolbox item on a wire.").cons((con, map) -> {
            WIRE_SLACK_ADJUSTMENT = con.getFloat(map);
        }).rang(0.0625f, 1.0f));
        this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, cats, "disable", new JsonValue((Object)false)).info("If the FVTM sign system should be disabled.").cons((con, map) -> {
            DISABLE_SIGNS = con.getBoolean(map);
        }));
        if (UniReg.LOADER_VERSION.equals("1.12")) {
            this.entries.add(new ConfigBase.ConfigEntry((ConfigBase)this, catg, "default_overlay_on_bottom", new JsonValue((Object)true)).info("If the default steering overlay should be on bottom rather than on top of screen.").cons((con, map) -> {
                OVERLAY_ON_BOTTOM = con.getBoolean(map);
            }));
        }
    }

    protected void onReload(JsonMap map) {
        PACK_FOLDERS.clear();
        if (!map.has("pack_folders")) {
            return;
        }
        ((List)map.getArray((String)"pack_folders").value).forEach(val -> PACK_FOLDERS.add(new File(val.string_value())));
    }
}

