/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.uni.packet.PacketListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VehicleLiftEntity
extends TileEntity
implements PacketListener,
InteractionHandler.InteractRefHolder {
    public static final AxisAlignedBB RENDER_AABB = new AxisAlignedBB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0);
    private InteractionHandler.InteractRef ref = new InteractionHandler.InteractRef(this);
    private VehicleData data;
    public double liftstate;
    private double lowest;
    private double highest;
    private double lslot;
    private double lwheel;
    private boolean onwheels;

    public VehicleData getVehicleData() {
        return this.data;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.func_145839_a(pkt.func_148857_g());
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.data != null) {
            compound.func_74782_a("VehicleData", (NBTBase)this.data.write(TagCW.create()).local());
        }
        compound.func_74780_a("LiftState", this.liftstate);
        compound.func_74776_a("Meta", (float)this.func_145832_p());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        int meta = compound.func_74762_e("Meta");
        if (compound.func_74764_b("VehicleData")) {
            this.data = FvtmResources.getVehicleData(compound.func_74775_l("VehicleData"));
            this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(meta)), true);
        }
        this.liftstate = compound.func_74769_h("LiftState");
        this.updateState();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 8.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return RENDER_AABB.func_186670_a(this.field_174879_c);
    }

    public void updateState() {
        double low;
        if (this.data == null) {
            this.liftstate = 0.0;
            return;
        }
        double ls = this.liftstate;
        this.lwheel = 16.0;
        this.lslot = 16.0;
        this.lowest = 16.0;
        this.highest = -16.0;
        for (LiftingPoint point : ((Vehicle)this.data.getType()).getLiftingPoints().values()) {
            if (this.highest < point.pos.y) {
                this.highest = point.pos.y;
            }
            if (!(this.lowest > point.pos.y)) continue;
            this.lowest = point.pos.y;
        }
        if (((Vehicle)this.data.getType()).getLiftingPoints().isEmpty()) {
            this.lowest = 0.0;
            this.highest = 0.0;
        }
        for (WheelSlot slot : this.data.getWheelSlots().values()) {
            if (!(this.lslot > slot.position.y)) continue;
            this.lslot = slot.position.y;
        }
        if (this.data.getWheelSlots().isEmpty()) {
            this.lslot = 0.0;
        }
        if (this.data.getWheelSlots().size() > 0 && this.data.getWheelPositions().size() > 0) {
            for (V3D vec : this.data.getWheelPositions().values()) {
                if (!(this.lwheel > vec.y)) continue;
                this.lwheel = vec.y;
            }
        } else {
            this.lwheel = this.lslot;
        }
        this.onwheels = this.data.getWheelPositions().size() >= ((Vehicle)this.data.getType()).getVehicleType().minWheels();
        this.liftstate = ls < 1.125 && !this.onwheels ? 1.25 : ls;
        double d = low = this.lslot > this.lowest ? this.lowest : this.lslot;
        if (this.onwheels || this.lwheel < low) {
            low = this.lwheel;
        }
        this.liftstate -= low;
        while (this.liftstate - low > 3.0) {
            this.liftstate -= 0.5;
        }
    }

    public double getState() {
        return this.liftstate + -this.lowest;
    }

    public void setVehicle(ItemStack stack) {
        if (this.data != null) {
            EntityItem item = new EntityItem(this.field_145850_b);
            item.func_92058_a((ItemStack)this.data.newItemStack().local());
            item.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5);
            this.field_145850_b.func_72838_d((Entity)item);
            this.data = null;
        }
        if (stack.func_77973_b() instanceof VehicleItem) {
            this.data = ((VehicleItem)stack.func_77973_b()).getData(TagCW.wrap((Object)stack.func_77978_p()));
        }
        this.sendUpdate();
    }

    private void sendUpdate() {
        TagCW com = TagCW.create();
        com.set("pos", this.field_174879_c.func_177986_g());
        if (this.data != null) {
            com.set("data", this.data.write(TagCW.create()));
        }
        com.set("task", "update");
        FvtmLogger.marker(com);
        Packets.sendToAll(Packet_TagListener.class, "blockentity", com);
    }

    public void handle(TagCW packet, EntityW player) {
        if (this.field_145850_b.field_72995_K) {
            switch (packet.getString("task")) {
                case "update": {
                    if (packet.has("data")) {
                        this.data = FvtmResources.getVehicleData(packet.getCompound("data"));
                        this.data.getRotationPoint("vehicle").getPivot().set_yaw(-((float)BlockType.GENERIC_4ROT.getRotationFor(this.func_145832_p())), true);
                    } else {
                        this.data = null;
                        this.liftstate = 0.0;
                    }
                    this.updateState();
                    return;
                }
            }
        }
    }

    public V3D getVehicleDataPos() {
        return new V3D((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + this.liftstate + 0.3125, (double)this.field_174879_c.func_177952_p() + 0.5);
    }

    public V3I getV3I() {
        return new V3I(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    public InteractionHandler.InteractRef iref() {
        return this.ref.set(this.getV3I(), this.field_174879_c.func_177986_g(), this.getVehicleDataPos());
    }

    @Override
    public void markChanged() {
        this.func_70296_d();
    }
}

