/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.block.generated;

import net.fexcraft.lib.common.Static;
import net.fexcraft.mod.fvtm.block.generated.BlockBase;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.block.generated.JunctionTrackingTileEntity;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.NBTTagCompound;

public class SwitchTileEntity
extends BlockTileEntity
implements JunctionTrackingTileEntity {
    protected QV3D juncpos;
    protected Junction junction;

    public SwitchTileEntity() {
    }

    public SwitchTileEntity(BlockBase type) {
        super(type);
    }

    public boolean getSwitch0State() {
        return this.getJunction() != null && this.junction.switch0;
    }

    public boolean getSwitch1State() {
        return this.getJunction() != null && this.junction.switch1;
    }

    public Boolean getSwitchStateFork3() {
        return this.getJunction() == null || this.junction.switch0 ? null : Boolean.valueOf(this.junction.switch1);
    }

    public int getSwitch2State() {
        return this.getJunction() == null || this.junction.switch0 ? 0 : (this.junction.switch1 ? 2 : 1);
    }

    public boolean isDoubleSwitchState(boolean switch0, boolean switch1) {
        if (this.getJunction() == null) {
            return false;
        }
        return this.junction.switch0 == switch0 && this.junction.switch1 == switch1;
    }

    public boolean isDoubleSwitchStateOnSide(boolean side, boolean state) {
        if (this.getJunction() == null) {
            return false;
        }
        return side ? this.junction.switch1 == state : this.junction.switch0 == state;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.juncpos != null) {
            this.juncpos.write(TagCW.wrap((Object)compound), "junction");
        }
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("junction")) {
            this.juncpos = new QV3D(TagCW.wrap((Object)compound), "junction");
        } else {
            this.juncpos = null;
            this.junction = null;
        }
    }

    @Override
    public void setJunction(QV3D vec) {
        this.juncpos = vec;
        this.linkJunction(this.field_145850_b, this.field_174879_c, vec);
        this.sendUpdate();
    }

    @Override
    public Junction getJunction() {
        if (this.junction == null && this.juncpos != null && this.field_174879_c != null) {
            RailSystem sys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)this.field_145850_b));
            if (sys != null) {
                this.junction = sys.getJunction(this.juncpos.pos, false);
            }
            if (this.junction == null) {
                this.juncpos = null;
                Static.stop();
            } else {
                this.junction.addLinkedTileEntity(WrapperHolder.mutPos((Object)this.field_174879_c));
            }
        }
        return this.junction;
    }

    @Override
    public QV3D getJuncPos() {
        return this.juncpos;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.junction != null) {
            this.junction.entities.remove(this.field_174879_c);
        }
    }

    @Override
    public void updateSwitchState() {
        if (this.field_145850_b == null || this.junction == null) {
            return;
        }
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
    }
}

