/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.root;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Saveable;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.tag.TagCW;

public class Textureable
implements Saveable {
    private IDL current;
    private String custom = "";
    private boolean external;
    private int selected;
    private TextureHolder holder;

    public Textureable(TextureHolder texholder) {
        this.holder = texholder;
        this.current = this.holder.getDefaultTextures().get(0);
    }

    public IDL getTexture() {
        return this.current;
    }

    public int getSelected() {
        return this.selected;
    }

    public boolean isExternal() {
        return this.external;
    }

    public String getCustom() {
        return this.custom;
    }

    public void setSelectedTexture(int idx, String tex, boolean ext) {
        if (idx < 0) {
            this.external = ext;
            this.selected = -1;
            this.custom = tex;
            this.current = ext ? FvtmResources.INSTANCE.getExternalTexture(this.custom) : IDLManager.getIDLNamed((String)this.custom);
        } else {
            this.external = false;
            if (idx > this.holder.getDefaultTextures().size()) {
                this.selected = this.holder.getDefaultTextures().size() - 1;
                this.current = this.holder.getDefaultTextures().get(this.selected);
            } else {
                this.selected = idx;
                this.current = this.holder.getDefaultTextures().get(this.selected);
            }
        }
    }

    @Override
    public void save(TagCW compound) {
        compound.set("SelectedTexture", this.selected);
        compound.set("ExternalTexture", this.external);
        compound.set("CurrentTexture", this.external ? this.custom : this.current.toString());
    }

    @Override
    public void load(TagCW compound) {
        this.selected = compound.getInteger("SelectedTexture");
        this.external = compound.getBoolean("ExternalTexture");
        if (this.selected < 0) {
            this.selected = -1;
        }
        if (this.selected >= this.holder.getDefaultTextures().size()) {
            this.selected = this.holder.getDefaultTextures().size() - 1;
        }
        if (!compound.has("CurrentTexture")) {
            this.custom = compound.getString("CustomTexture");
            this.current = this.selected < 0 ? (this.external ? FvtmResources.INSTANCE.getExternalTexture(this.custom) : IDLManager.getIDLNamed((String)this.custom)) : this.holder.getDefaultTextures().get(this.selected > this.holder.getDefaultTextures().size() ? 0 : this.selected);
        } else {
            String str = compound.getString("CurrentTexture");
            if (this.selected < 0) {
                this.current = this.external ? FvtmResources.INSTANCE.getExternalTexture(str) : IDLManager.getIDLNamed((String)str);
                this.custom = this.external ? str : this.current.toString();
            } else {
                this.current = this.holder.getDefaultTextures().get(this.selected);
                this.custom = "";
            }
        }
    }

    public JsonMap save() {
        JsonMap map = new JsonMap();
        if (this.selected == 0 && !this.external) {
            return map;
        }
        map.add("sel", this.selected);
        if (this.external) {
            map.add("ext", this.external);
        }
        if (this.selected != 0) {
            map.add("tex", this.external ? this.custom : this.current.toString());
        }
        return map;
    }

    public void load(JsonMap map) {
        this.selected = map.getInteger("sel", 0);
        this.external = map.getBoolean("ext", false);
        String str = map.getString("tex", "");
        if (this.selected < 0) {
            this.current = this.external ? FvtmResources.INSTANCE.getExternalTexture(str) : IDLManager.getIDLNamed((String)str);
            this.custom = this.external ? str : this.current.toString();
        } else {
            this.current = this.holder.getDefaultTextures().get(this.selected);
            this.custom = "";
        }
    }

    public static interface TextureUser {
        public Textureable getTexture();

        public TextureHolder getTexHolder();

        default public IDL getCurrentTexture() {
            return this.getTexture().current;
        }

        default public int getSelectedTexture() {
            return this.getTexture().selected;
        }

        default public boolean isTextureExternal() {
            return this.getTexture().external;
        }

        default public String getCustomTexture() {
            return this.getTexture().custom;
        }
    }

    public static interface TextureHolder {
        public List<IDL> getDefaultTextures();
    }
}

