/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPointMover;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;

public class DefaultSwivelPointMover
implements SwivelPointMover {
    private Attribute<?> attr;
    private String attribute;
    private float last;
    private float speed = 1.0f;
    private float min;
    private float max;
    private float def;
    private int axe;
    private boolean pos;
    private boolean bool;
    private boolean loop;
    public boolean moved;

    public DefaultSwivelPointMover(JsonMap map) {
        this(map.get("attribute").string_value(), map.get("var").string_value());
        this.speed = map.getFloat("speed", 1.0f);
        this.bool = map.getBoolean("bool_based", false);
        this.min = map.getFloat("min", -2.1474836E9f);
        this.max = map.getFloat("max", 2.1474836E9f);
        this.def = map.getFloat("def", 0.0f);
        this.loop = map.getBoolean("loop", false);
    }

    public DefaultSwivelPointMover(String key, String value) {
        this.attribute = key;
        switch (value) {
            case "x": {
                this.axe = 0;
                this.pos = true;
                break;
            }
            case "y": {
                this.axe = 1;
                this.pos = true;
                break;
            }
            case "z": {
                this.axe = 2;
                this.pos = true;
                break;
            }
            case "yaw": {
                this.axe = 0;
                this.pos = false;
                break;
            }
            case "pitch": {
                this.axe = 1;
                this.pos = false;
                break;
            }
            case "roll": {
                this.axe = 2;
                this.pos = false;
            }
        }
    }

    public DefaultSwivelPointMover(String attr, String var, float speed, boolean bool, float min, float max, float def, boolean loop) {
        this(attr, var);
        this.speed = speed;
        this.bool = bool;
        this.min = min;
        this.max = max;
        this.def = def;
        this.loop = loop;
    }

    @Override
    public void update(VehicleInstance vehicle, SwivelPoint point) {
        if (this.attr == null) {
            this.attr = vehicle.data.getAttribute(this.attribute);
            this.last = this.bool ? this.attr.asFloat() : this.def;
            this.move(point, this.axe, this.pos, this.last);
        }
        if (this.bool) {
            if (this.attr.valuetype.isTristate()) {
                this.last += this.attr.tristate(Float.valueOf(0.0f), Float.valueOf(this.speed), Float.valueOf(-this.speed)).floatValue();
            } else if (this.attr.asBoolean()) {
                this.last += this.speed;
            }
            if (this.last > this.max) {
                this.last = this.loop ? this.min + (this.last - this.max) : this.max;
            }
            if (this.last < this.min) {
                this.last = this.loop ? this.max - (this.min - this.last) : this.min;
            }
            if ((double)this.last == this.get(point)) {
                return;
            }
            this.move(point, this.axe, this.pos, this.last);
            return;
        }
        if (this.last != this.attr.asFloat()) {
            float diff = this.attr.asFloat() - this.last;
            if ((double)diff < 0.001 && (double)diff > -0.001) {
                return;
            }
            if (Math.abs(diff) <= this.speed) {
                this.last = this.attr.asFloat();
                this.move(point, this.axe, this.pos, this.last);
            } else {
                this.last += diff > 0.0f ? this.speed : -this.speed;
                this.move(point, this.axe, this.pos, this.last);
            }
        }
    }

    private void move(SwivelPoint point, int axe, boolean pos, float last) {
        this.moved = true;
        if (pos) {
            switch (axe) {
                case 0: {
                    point.setPos(last, point.getPos().y, point.getPos().z);
                    return;
                }
                case 1: {
                    point.setPos(point.getPos().x, last, point.getPos().z);
                    return;
                }
                case 2: {
                    point.setPos(point.getPos().x, point.getPos().y, last);
                    return;
                }
            }
        } else {
            switch (axe) {
                case 0: {
                    point.getPivot().set_rotation(last, point.getPivot().deg_pitch(), point.getPivot().deg_roll(), true);
                    return;
                }
                case 1: {
                    point.getPivot().set_rotation(point.getPivot().deg_yaw(), last, point.getPivot().deg_roll(), true);
                    return;
                }
                case 2: {
                    point.getPivot().set_rotation(point.getPivot().deg_yaw(), point.getPivot().deg_pitch(), last, true);
                    return;
                }
            }
        }
    }

    public double get(SwivelPoint point) {
        if (this.pos) {
            switch (this.axe) {
                case 0: {
                    return point.getPos().x;
                }
                case 1: {
                    return point.getPos().y;
                }
                case 2: {
                    return point.getPos().z;
                }
            }
        } else {
            switch (this.axe) {
                case 0: {
                    return point.getPivot().deg_yaw();
                }
                case 1: {
                    return point.getPivot().deg_pitch();
                }
                case 2: {
                    return point.getPivot().deg_roll();
                }
            }
        }
        return 0.0;
    }

    @Override
    public SwivelPointMover clone() {
        return new DefaultSwivelPointMover(this.attribute, this.varString(), this.speed, this.bool, this.min, this.max, this.def, this.loop);
    }

    private String varString() {
        if (this.pos) {
            switch (this.axe) {
                case 0: {
                    return "x";
                }
                case 1: {
                    return "y";
                }
                case 2: {
                    return "z";
                }
            }
        } else {
            switch (this.axe) {
                case 0: {
                    return "yaw";
                }
                case 1: {
                    return "pitch";
                }
                case 2: {
                    return "roll";
                }
            }
        }
        return "null";
    }

    @Override
    public boolean shouldUpdate() {
        if (this.moved) {
            this.moved = false;
            return true;
        }
        return false;
    }
}

