/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import io.netty.buffer.ByteBuf;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.packet.PacketEntityUpdate;
import net.fexcraft.lib.mc.utils.ApiUtil;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class RailTestEntity
extends Entity
implements IEntityAdditionalSpawnData,
IPacketReceiver<PacketEntityUpdate> {
    public Track current;
    public float passed;
    private float speed = 0.01f;

    public RailTestEntity(World world) {
        super(world);
        this.field_70138_W = 0.0f;
        this.func_70105_a(0.125f, 0.125f);
    }

    public RailTestEntity(World world, Track start) {
        this(world);
        this.current = start;
        this.func_70107_b(start.start.vec.x, start.start.vec.y, start.start.vec.z);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
        if (this.current != null) {
            ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)this.current.getId().write(TagCW.create()).local()));
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        this.func_70107_b(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        if (buffer.isReadable()) {
            this.current = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)this.field_70170_p), RailSystem.class).getTrack(new PathKey(TagCW.wrap((Object)ByteBufUtils.readTag((ByteBuf)buffer))));
        }
        Print.debug((Object[])new Object[]{this.current, this.field_70165_t, this.field_70163_u, this.field_70161_v});
    }

    public void processClientPacket(PacketEntityUpdate pkt) {
        NBTTagCompound compound = pkt.nbt;
        this.func_70107_b(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
        this.passed = compound.func_74760_g("passed");
        if (compound.func_74764_b("id")) {
            this.current.read(TagCW.wrap((Object)compound));
        }
        if (compound.func_74764_b("reset")) {
            this.current = null;
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (this.current != null) {
            compound.func_74782_a("Current", (NBTBase)this.current.write(null).local());
        }
        compound.func_74776_a("Passed", this.passed);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (this.current != null) {
            compound.func_74782_a("Current", (NBTBase)this.current.write(null).local());
        }
        this.passed = compound.func_74760_g("Passed");
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_180430_e(float k, float l) {
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        if (this.current != null) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.passed += this.speed;
            if ((double)this.passed >= this.current.length) {
                Junction junc = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)this.field_70170_p), RailSystem.class).getJunction(this.current.end.pos);
                if (junc == null) {
                    this.current = this.current.createOppositeCopy();
                    Print.debug((Object[])new Object[]{this, "No junction, returning."});
                } else {
                    this.current = junc.getNext(null, this.current.getId(), false);
                    Print.debug((Object[])new Object[]{this, "Junction found, passing on new track."});
                }
                this.passed = 0.0f;
            } else {
                V3D vec = this.current.getVectorPosition(this.passed, false);
                this.func_70107_b(vec.x, vec.y, vec.z);
            }
        } else {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t, this.field_70163_u + 0.4, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_DROP, this.field_70165_t, this.field_70163_u + 0.6, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74780_a("x", this.field_70165_t);
            compound.func_74780_a("y", this.field_70163_u);
            compound.func_74780_a("z", this.field_70161_v);
            compound.func_74776_a("passed", this.passed);
            if (this.current != null) {
                this.current.write(TagCW.wrap((Object)compound));
            } else {
                compound.func_74757_a("reset", true);
            }
            ApiUtil.sendEntityUpdatePacketToAllAround((Entity)this, (NBTTagCompound)compound);
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int pri, boolean teleport) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70108_f(Entity entity) {
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return false;
        }
        this.speed *= 2.0f;
        Print.chat((ICommandSender)player, (String)"&e&oSpeed Increased (x2).");
        return true;
    }

    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (damagesource.field_76373_n.equals("player")) {
            this.func_70106_y();
        }
        return true;
    }
}

