/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.event;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.ConstructorBlock;
import net.fexcraft.mod.fvtm.block.ContainerBlock;
import net.fexcraft.mod.fvtm.block.FuelFillerBlock;
import net.fexcraft.mod.fvtm.block.VehicleLiftBlock;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.item.JunctionToolItem;
import net.fexcraft.mod.fvtm.item.RoadToolItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.uni.EnvInfo;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Registerer12 {
    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().register((IForgeRegistryEntry)ConstructorBlock.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)FuelFillerBlock.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)VehicleLiftBlock.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)Asphalt.INSTANCE);
        event.getRegistry().register((IForgeRegistryEntry)ContainerBlock.INSTANCE);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)ConstructorBlock.ITEM);
        event.getRegistry().register((IForgeRegistryEntry)FuelFillerBlock.ITEM);
        event.getRegistry().register((IForgeRegistryEntry)VehicleLiftBlock.ITEM);
        event.getRegistry().register((IForgeRegistryEntry)Asphalt.ITEM);
        RoadToolItem.INSTANCE = new RoadToolItem();
        event.getRegistry().register((IForgeRegistryEntry)RoadToolItem.INSTANCE);
        ToolboxItem.INSTANCE = new ToolboxItem();
        event.getRegistry().register((IForgeRegistryEntry)ToolboxItem.INSTANCE);
        JunctionToolItem.INSTANCE = new JunctionToolItem();
        event.getRegistry().register((IForgeRegistryEntry)JunctionToolItem.INSTANCE);
        if (EnvInfo.CLIENT) {
            this.regModel((Item)ConstructorBlock.ITEM);
            this.regModel((Item)FuelFillerBlock.ITEM);
            this.regModel((Item)VehicleLiftBlock.ITEM);
            this.regModel((Item)Asphalt.ITEM, 16);
            this.regModel(RoadToolItem.INSTANCE);
            this.regModel(ToolboxItem.INSTANCE, ToolboxType.values().length);
            this.regModel(JunctionToolItem.INSTANCE);
        }
    }

    private void regModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private void regModel(Item item, int vars) {
        for (int v = 0; v < vars; ++v) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)v, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(item.getRegistryName().toString() + "_" + v), "inventory"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void regPacks() {
        URLClassLoader cl = (URLClassLoader)Minecraft.class.getClassLoader();
        Method method = null;
        try {
            method = cl.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
        }
        catch (Exception e) {
            FvtmLogger.log(e, "force registration of packs as resourcepacks");
        }
        if (method == null) {
            return;
        }
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (addon.getFile() == null || !addon.getFile().exists()) continue;
            try {
                method.invoke((Object)cl, addon.getFile().toURI().toURL());
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("modid", addon.getID().path());
                map.put("name", addon.getName());
                map.put("version", addon.getVersion());
                ModCandidate can = new ModCandidate(addon.getFile(), addon.getFile(), addon.getFile().isDirectory() ? ContainerType.DIR : ContainerType.JAR);
                FMLModContainer con = new FMLModContainer("net.fexcraft.mod.fvtm.FVTM", can, map);
                con.bindMetadata(MetadataCollection.from(null, (String)"FVTM"));
                FMLClientHandler.instance().addModAsResource((ModContainer)con);
            }
            catch (Exception e) {
                FvtmLogger.log(e, "force registration '" + addon.getID() + "' as resourcepack");
            }
        }
        Registerer12.refresh();
    }

    @SideOnly(value=Side.CLIENT)
    public static void refresh() {
        FMLClientHandler.instance().refreshResources((IResourceType[])VanillaResourceType.values());
    }
}

