/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.GetWheelPos;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;

public class TireFunction
extends PartFunction
implements GetWheelPos {
    public static HashMap<Object, MatTireAttr> DEF_MAT_TIRE_ARR = new HashMap();
    private static HashMap<Part, TireAttr> TIRES = new HashMap();
    private String inst_on;
    private WheelSlot wheel;

    @Override
    public PartFunction init(Part part, FJson json) {
        JsonMap map = json.isMap() ? json.asMap() : new JsonMap();
        TireAttr attr = new TireAttr();
        attr.general_grip = map.getFloat("general_grip", 1.0f);
        attr.brake_grip = map.getFloat("brake_grip", 0.7f);
        attr.corner_stiffness = map.getFloat("stiffness", 5.2f);
        attr.corner_stiffness_steering = map.getFloat("steering_stiffness", 5.0f);
        attr.step_height = map.getFloat("step_height", 1.0f);
        if (map.has("material_table")) {
            for (Map.Entry entry : map.getMap("material_table").entries()) {
                Object mat = FvtmResources.INSTANCE.getBlockMaterial((String)entry.getKey(), true);
                if (mat == null) continue;
                JsonArray array = ((JsonValue)entry.getValue()).asArray();
                float g = array.size() > 0 ? array.get(0).float_value() : 1.0f;
                float r = array.size() > 1 ? array.get(1).float_value() : 0.9f;
                float cs = array.size() > 2 ? array.get(2).float_value() : attr.corner_stiffness;
                float css = array.size() > 3 ? array.get(3).float_value() : attr.corner_stiffness_steering;
                attr.table.put(mat, new MatTireAttr(g, r, cs, css));
            }
        }
        TIRES.put(part, attr);
        return this;
    }

    @Override
    public PartFunction load(TagCW compound) {
        this.inst_on = compound.has("wheel_on") ? compound.getString("wheel_on") : null;
        return this;
    }

    @Override
    public TagCW save(TagCW compound) {
        if (this.inst_on != null) {
            compound.set("wheel_on", this.inst_on);
        }
        return compound;
    }

    @Override
    public WheelSlot getWheelPos(VehicleData vehicle) {
        if (this.wheel != null) {
            return this.wheel;
        }
        if (this.inst_on != null) {
            this.wheel = vehicle.getWheelSlots().get(this.inst_on);
            return this.wheel;
        }
        return null;
    }

    @Override
    public String getId() {
        return "fvtm:tire";
    }

    public void setWheel(String cat, WheelSlot slot) {
        this.inst_on = cat;
        this.wheel = slot;
    }

    @Override
    public PartFunction copy(Part part) {
        return new TireFunction();
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        if (((Part)data.getType()).getInstallHandlerData() instanceof TireInstallationHandler.TireData) {
            TireInstallationHandler.TireData tiredata = (TireInstallationHandler.TireData)((Part)data.getType()).getInstallHandlerData();
            tooltip.add(Formatter.format((String)("&9Tire Outer Radius: &7" + tiredata.getOuterRadius())));
            tooltip.add(Formatter.format((String)("&9Tire Inner Radius: &7" + tiredata.getInnerRadius())));
            tooltip.add(Formatter.format((String)("&9Tire Width: &7" + tiredata.getWidth())));
            return;
        }
        tooltip.add(Formatter.format((String)("&9Climb Height: &7" + TireFunction.TIRES.get(data.getType()).step_height)));
    }

    public TireAttr getTireAttr(PartData part) {
        return TIRES.get(part.getType());
    }

    public static class MatTireAttr {
        public static final float DEF_GRIP = 1.0f;
        public static final float DEF_RAIN_GRIP = 0.75f;
        public static final float DEF_COR = 5.2f;
        public static final float DEF_COR_STEER = 5.0f;
        public final float general;
        public final float rainfall;
        public final float corner_stiffness;
        public final float corner_stiffness_steering;

        public MatTireAttr(float g, float r, float cs, float css) {
            this.general = g;
            this.rainfall = r;
            this.corner_stiffness = cs;
            this.corner_stiffness_steering = css;
        }
    }

    public static class TireAttr {
        private HashMap<Object, MatTireAttr> table = new HashMap();
        private float general_grip;
        private float corner_stiffness;
        private float corner_stiffness_steering;
        public float brake_grip;
        public float step_height;

        public float getGripFor(Object mat, boolean rainfall) {
            if (this.table.containsKey(mat)) {
                return rainfall ? this.table.get((Object)mat).rainfall : this.table.get((Object)mat).general;
            }
            if (DEF_MAT_TIRE_ARR.containsKey(mat)) {
                return this.general_grip * (rainfall ? TireFunction.DEF_MAT_TIRE_ARR.get((Object)mat).rainfall : TireFunction.DEF_MAT_TIRE_ARR.get((Object)mat).general);
            }
            return this.general_grip * (rainfall ? 0.75f : 1.0f);
        }

        public float getCornerStiffnessFor(Object mat, boolean steering) {
            if (this.table.containsKey(mat)) {
                return steering ? this.table.get((Object)mat).corner_stiffness_steering : this.table.get((Object)mat).corner_stiffness;
            }
            if (DEF_MAT_TIRE_ARR.containsKey(mat)) {
                return steering ? TireFunction.DEF_MAT_TIRE_ARR.get((Object)mat).corner_stiffness_steering : TireFunction.DEF_MAT_TIRE_ARR.get((Object)mat).corner_stiffness;
            }
            return steering ? 5.0f : 5.2f;
        }
    }
}

