/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.inv;

import java.util.Map;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.function.InventoryBlockFunction;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;

public class UniFluidInvContainer
extends GenericContainer {
    protected GenericGui<UniFluidInvContainer> gui;
    protected MultiblockTileEntity mb_tile;
    protected ContainerEntity con_tile;
    protected BlockTileEntity blk_tile;
    protected InventoryFunction func;
    protected RootVehicle entity;
    protected String inv_id;
    protected String title;
    protected InvHandler invhandler;
    protected EntityPlayerMP mpp;
    protected long fluid_date;
    protected IInventory fluid_io;
    protected FluidTank tank;

    public UniFluidInvContainer(EntityPlayer player, World world, int ID, int x, int y, int z) {
        super(player);
        if (!player.field_70170_p.field_72995_K) {
            this.mpp = (EntityPlayerMP)player;
        }
        if (ID == UIKeys.MULTIBLOCK_INVENTORY_FLUID.id) {
            this.mb_tile = (MultiblockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            NBTTagCompound com = new NBTTagCompound();
            if (com == null) {
                player.func_71053_j();
                return;
            }
            this.inv_id = com.func_74779_i("inventory");
            this.invhandler = this.mb_tile.getMultiBlockData().getInventory(this.inv_id);
            this.title = ((Block)this.mb_tile.getBlockData().getType()).getName() + " - " + this.inv_id;
        } else if (ID == 942) {
            this.con_tile = (ContainerEntity)world.func_175625_s(new BlockPos(x, y, z));
            this.invhandler = this.con_tile.getContainerData().getInventory();
            this.title = ((Container)this.con_tile.getContainerData().getType()).getName();
        } else if (ID == UIKeys.BLOCK_INVENTORY_FLUID.id) {
            this.blk_tile = (BlockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            this.invhandler = ((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).inventory();
            this.title = ((Block)this.blk_tile.getBlockData().getType()).getName();
        } else if (ID == UIKeys.VEHICLE_INVENTORY_FLUID.id) {
            this.entity = (RootVehicle)(player.func_184187_bx() instanceof RootVehicle ? player.func_184187_bx() : world.func_73045_a(y));
            SeatInstance seat = this.entity.getSeatOf((Entity)player);
            int invid = 0;
            for (Map.Entry<String, PartData> entry : this.entity.vehicle.data.getParts().entrySet()) {
                InventoryFunction inv = (InventoryFunction)entry.getValue().getFunction("fvtm:inventory");
                if (inv == null || inv.inventory().type.isContainer() || !(seat == null ? inv.access().contains(this.entity.vehicle.data.getLock().isLocked() ? "external-locked" : "external") : seat.seat.driver || inv.access().contains(seat.seat.name))) continue;
                if (invid == z) {
                    this.inv_id = entry.getKey();
                    this.func = inv;
                    break;
                }
                ++invid;
            }
            if (this.inv_id == null) {
                player.func_71053_j();
            }
            this.title = ((Vehicle)this.entity.vehicle.data.getType()).getName() + " - " + this.inv_id;
        }
        this.tank = (FluidTank)this.invhandler.getTank();
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        this.fluid_io = (IInventory)UniInventory.create((int)2).stacksize(1).cast();
        this.func_75146_a(new Slot(this.fluid_io, 0, 116, 50));
        this.func_75146_a(new Slot(this.fluid_io, 1, 152, 50));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 74 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, col, 8 + col * 18, 130));
        }
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (!packet.func_74764_b("cargo")) {
            return;
        }
        if (!side.isServer() && packet.func_74779_i("cargo").equals("update_fluid_tank")) {
            this.invhandler.load((TagCW)new TagCWI(packet), "state");
            if (packet.func_74764_b("stack_0")) {
                this.fluid_io.func_70299_a(0, new ItemStack(packet.func_74775_l("stack_0")));
            }
            if (packet.func_74764_b("stack_1")) {
                this.fluid_io.func_70299_a(1, new ItemStack(packet.func_74775_l("stack_1")));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < 2 ? !this.func_75135_a(itemstack1, 2, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, 2, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.fluid_io.func_174886_c(player);
        if (this.mb_tile != null) {
            this.mb_tile.func_70296_d();
        }
        if (this.con_tile != null) {
            this.con_tile.func_70296_d();
        }
        if (this.blk_tile != null) {
            this.blk_tile.func_70296_d();
            if (((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).hasBool()) {
                ((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).onClose(this.blk_tile);
            }
        }
    }

    public void func_75142_b() {
        if (this.invhandler.getTank() != null && this.fluid_date + 50L <= Time.getDate()) {
            IFluidHandlerItem item;
            this.fluid_date = Time.getDate();
            boolean anychange = false;
            ItemStack stack = this.fluid_io.func_70301_a(0);
            if (!stack.func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (item = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties().length > 0 && item.getTankProperties()[0].getContents() != null && item.getTankProperties()[0].getContents().amount > 0) {
                FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.invhandler.getTank()), (int)1000, (EntityPlayer)this.player, (boolean)true);
                if (result.success) {
                    anychange = true;
                    stack = result.getResult() == null ? ItemStack.field_190927_a : result.getResult();
                    this.fluid_io.func_70299_a(0, stack);
                }
            }
            if (((FluidTank)this.invhandler.getTank()).getFluidAmount() > 0 && !(stack = this.fluid_io.func_70301_a(1)).func_190926_b() && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
                FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)((IFluidHandler)this.invhandler.getTank()), (int)1000, (EntityPlayer)this.player, (boolean)true);
                if (result.success) {
                    anychange = true;
                    stack = result.getResult() == null ? ItemStack.field_190927_a : result.getResult();
                    this.fluid_io.func_70299_a(1, stack);
                }
            }
            if (!this.player.field_70170_p.field_72995_K && anychange) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("cargo", "update_fluid_tank");
                this.invhandler.save((TagCW)new TagCWI(compound), "state");
                compound.func_74782_a("stack_0", (NBTBase)this.fluid_io.func_70301_a(0).func_77955_b(new NBTTagCompound()));
                compound.func_74782_a("stack_1", (NBTBase)this.fluid_io.func_70301_a(1).func_77955_b(new NBTTagCompound()));
                this.send(Side.CLIENT, compound);
            }
        }
        super.func_75142_b();
    }
}

