/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.inv;

import java.util.Map;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.data.inv.ItemStackHandler;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.gui.inv.InvSlot;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.function.InventoryBlockFunction;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class UniItemInvContainer
extends GenericContainer {
    protected GenericGui<UniItemInvContainer> gui;
    protected MultiblockTileEntity mb_tile;
    protected ContainerEntity con_tile;
    protected BlockTileEntity blk_tile;
    protected InventoryFunction func;
    protected RootVehicle entity;
    protected String inv_id;
    protected String title;
    protected int page;
    protected int rows;
    protected InvHandler invhandler;
    protected EntityPlayerMP mpp;
    protected IInventory insert;

    public UniItemInvContainer(EntityPlayer player, World world, int ID, int x, int y, int z) {
        super(player);
        if (!player.field_70170_p.field_72995_K) {
            this.mpp = (EntityPlayerMP)player;
        }
        if (ID == UIKeys.MULTIBLOCK_INVENTORY_ITEM.id) {
            this.mb_tile = (MultiblockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            NBTTagCompound com = new NBTTagCompound();
            if (com == null) {
                player.func_71053_j();
                return;
            }
            this.inv_id = com.func_74779_i("inventory");
            this.invhandler = this.mb_tile.getMultiBlockData().getInventory(this.inv_id);
            this.title = ((Block)this.mb_tile.getBlockData().getType()).getName() + " - " + this.inv_id;
        } else if (ID == 941) {
            this.con_tile = (ContainerEntity)world.func_175625_s(new BlockPos(x, y, z));
            this.invhandler = this.con_tile.getContainerData().getInventory();
            this.title = ((Container)this.con_tile.getContainerData().getType()).getName();
        } else if (ID == UIKeys.BLOCK_INVENTORY_ITEM.id) {
            this.blk_tile = (BlockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
            this.invhandler = ((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).inventory();
            this.title = ((Block)this.blk_tile.getBlockData().getType()).getName();
        } else if (ID == UIKeys.VEHICLE_INVENTORY_ITEM.id) {
            this.entity = (RootVehicle)(player.func_184187_bx() instanceof RootVehicle ? player.func_184187_bx() : world.func_73045_a(y));
            SeatInstance seat = this.entity.getSeatOf((Entity)player);
            int invid = 0;
            for (Map.Entry<String, PartData> entry : this.entity.vehicle.data.getParts().entrySet()) {
                InventoryFunction inv = (InventoryFunction)entry.getValue().getFunction("fvtm:inventory");
                if (inv == null || inv.inventory().type.isContainer() || !(seat == null ? inv.access().contains(this.entity.vehicle.data.getLock().isLocked() ? "external-locked" : "external") : seat.seat.driver || inv.access().contains(seat.seat.name))) continue;
                if (invid == z) {
                    this.inv_id = entry.getKey();
                    this.func = inv;
                    break;
                }
                ++invid;
            }
            if (this.inv_id == null) {
                player.func_71053_j();
            }
            this.title = ((Vehicle)this.entity.vehicle.data.getType()).getName() + " - " + this.inv_id;
        }
        this.insert = (IInventory)UniInventory.create((int)1).cast();
    }

    protected void populateSlots() {
        int index;
        int row;
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        int size = this.invhandler.getStacks().size();
        this.rows = 0;
        for (row = 0; row < 6 && (index = this.page * 6 + row) < size; ++row) {
            this.func_75146_a(new InvSlot(this, this.invhandler, true, index, 8, 22 + row * 20));
            this.func_75146_a(new InvSlot(this, this.invhandler, false, index, 26, 22 + row * 20));
            this.rows += 2;
        }
        this.func_75146_a(new Slot(this.insert, 0, 176, 143){

            public boolean func_75214_a(ItemStack stack) {
                return InvSlot.isValid(UniItemInvContainer.this.invhandler, stack);
            }
        });
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 147 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, col, 8 + col * 18, 203));
        }
        if (this.player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cargo", "reload_slots");
        this.send(Side.CLIENT, compound);
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (!packet.func_74764_b("cargo")) {
            return;
        }
        if (side.isServer()) {
            if (packet.func_74779_i("cargo").equals("inventory_page")) {
                this.page = packet.func_74762_e("page");
                if (this.page < 0) {
                    this.page = 0;
                }
                this.populateSlots();
            }
            if (packet.func_74779_i("cargo").equals("insert_stack")) {
                ItemStack stack = this.insert.func_70301_a(0);
                if (stack.func_190926_b()) {
                    return;
                }
                ItemStack stack1 = stack.func_77946_l();
                ItemStackHandler handler = (ItemStackHandler)this.invhandler.getStackHandler();
                stack = handler.insertItem(0, stack, true);
                if (stack.func_190926_b() || stack1.func_190916_E() > stack.func_190916_E()) {
                    this.insert.func_70299_a(0, handler.insertItem(0, stack1, false));
                    NBTTagCompound compound = new NBTTagCompound();
                    this.invhandler.save((TagCW)new TagCWI(compound), "inventory");
                    compound.func_74782_a("insert", (NBTBase)this.insert.func_70301_a(0).func_77955_b(new NBTTagCompound()));
                    compound.func_74778_a("cargo", "inv_update");
                    this.send(Side.CLIENT, compound);
                    this.populateSlots();
                }
            }
        } else {
            int idx;
            if (packet.func_74779_i("cargo").equals("update_stack")) {
                idx = packet.func_74762_e("index");
                ItemStack stack = new ItemStack(packet.func_74775_l("stack"));
                ((Slot)this.field_75151_b.get(idx)).func_75215_d(stack);
                this.field_75153_a.set(idx, (Object)stack);
            }
            if (packet.func_74779_i("cargo").equals("update_inv")) {
                this.invhandler.load((TagCW)new TagCWI(packet), "inventory");
                for (idx = 0; idx < this.rows; ++idx) {
                    this.field_75153_a.set(idx, (Object)((InvSlot)((Object)this.field_75151_b.get(idx))).getReloadedStack());
                }
            }
            if (packet.func_74779_i("cargo").equals("reload_slots")) {
                this.populateSlots();
            }
            if (packet.func_74779_i("cargo").equals("inv_update")) {
                this.invhandler.load((TagCW)new TagCWI(packet), "inventory");
                this.insert.func_70299_a(0, new ItemStack(packet.func_74775_l("insert")));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.mb_tile != null) {
            this.mb_tile.func_70296_d();
        }
        if (this.con_tile != null) {
            this.con_tile.func_70296_d();
        }
        if (this.blk_tile != null) {
            this.blk_tile.func_70296_d();
            if (((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).hasBool()) {
                ((InventoryBlockFunction)this.blk_tile.getBlockData().getFunctionInventory()).onClose(this.blk_tile);
            }
        }
        this.insert.func_174886_c(player);
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            NBTTagCompound compound;
            ItemStack itemstack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            this.field_75153_a.set(i, (Object)(itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l()));
            if (i < this.rows) {
                compound = new NBTTagCompound();
                compound.func_74778_a("cargo", "update_inv");
                this.invhandler.save((TagCW)new TagCWI(compound), "inventory");
                this.send(Side.CLIENT, compound);
                continue;
            }
            compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "update_stack");
            compound.func_74768_a("index", i);
            compound.func_74782_a("stack", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
            this.send(Side.CLIENT, compound);
        }
    }
}

