/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.other;

import java.util.ArrayList;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.gui.other.SpawnSystemContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;

public class SpawnSystemChooser
extends GenericGui<SpawnSystemContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/spawn_system.png");
    private ArrayList<EntitySystem> systems = new ArrayList();
    private static VehicleType type;
    private static int scroll;
    private boolean save;
    private boolean demo;

    public SpawnSystemChooser(EntityPlayer player, int x, int y, int z) {
        super(texture, (GenericContainer)new SpawnSystemContainer(player, x, y, z), player);
        ((SpawnSystemContainer)this.container).gui = this;
        this.defbackground = true;
        this.deftexrect = true;
        this.field_146999_f = 194;
        this.field_147000_g = 120;
        type = VehicleType.values()[x];
        this.demo = z > 0;
    }

    protected void init() {
        this.buttons.put("remember", new GenericGui.BasicButton("remember", this.field_147003_i + 176, this.field_147009_r + 102, 176, 102, 10, 10, true));
        this.buttons.put("prev", new GenericGui.BasicButton("prev", this.field_147003_i + 171, this.field_147009_r + 6, 171, 6, 8, 8, true));
        this.buttons.put("next", new GenericGui.BasicButton("next", this.field_147003_i + 180, this.field_147009_r + 6, 180, 6, 8, 8, true));
        this.texts.put("title", new GenericGui.BasicText(this.field_147003_i + 7, this.field_147009_r + 6, 162, Integer.valueOf(MapColor.field_151666_j.field_76291_p), "Select an Entity System"));
        this.texts.put("remember", new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 103, 162, Integer.valueOf(7234892), "Remember choice?"));
        for (int i = 0; i < 6; ++i) {
            this.buttons.put("idx" + i, new GenericGui.BasicButton("idx" + i, this.field_147003_i + 175, this.field_147009_r + 17 + i * 14, 175, 17 + i * 14, 12, 12, true));
            this.texts.put("idx" + i, new GenericGui.BasicText(this.field_147003_i + 9, this.field_147009_r + 19 + i * 14, 162, Integer.valueOf(7234892), "loading..."));
        }
        this.sendUpdateRequest();
    }

    private void sendUpdateRequest() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("cargo", "init_data");
        compound.func_74768_a("type", type.ordinal());
        ((SpawnSystemContainer)this.container).send(Side.SERVER, compound);
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        if (this.save) {
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r + 102, 195, 102, 10, 10);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("remember")) {
            this.save = !this.save;
            return true;
        }
        if (button.name.startsWith("idx")) {
            int index = Integer.parseInt(button.name.substring(3));
            if (index < 0 || index >= this.systems.size()) {
                return false;
            }
            EntitySystem system = this.systems.get(index + scroll * 6);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("cargo", "spawn");
            compound.func_74768_a("type", type.ordinal());
            compound.func_74778_a("system", system.getId());
            compound.func_74757_a("save", this.save);
            compound.func_74757_a("demo", this.demo);
            ((SpawnSystemContainer)this.container).send(Side.SERVER, compound);
            return true;
        }
        return false;
    }

    protected void scrollwheel(int am, int x, int y) {
        int i;
        if ((scroll += am > 0 ? -1 : 1) < 0) {
            scroll = 0;
        }
        if (scroll > (i = EntitySystem.REGISTRY.size() / 6 + 1)) {
            scroll = i;
        }
        this.updateFields();
    }

    public void init(NBTTagCompound packet) {
        this.systems.clear();
        int amount = packet.func_74762_e("found");
        for (int i = 0; i < amount; ++i) {
            this.systems.add(EntitySystem.REGISTRY.get(packet.func_74779_i("found" + i)));
        }
        this.updateFields();
    }

    private void updateFields() {
        for (int i = 0; i < 6; ++i) {
            int j = i + scroll * 6;
            ((GenericGui.BasicText)this.texts.get((Object)new StringBuilder().append((String)"idx").append((int)i).toString())).string = j >= this.systems.size() ? "" : this.systems.get(j).getName();
        }
    }
}

