/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.rail;

import java.util.ArrayList;
import java.util.Collections;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.gui.ClientReceiver;
import net.fexcraft.mod.fvtm.gui.rail.RailPlacerContainer;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

public class RailPlacer
extends GenericGui<RailPlacerContainer> {
    private static final ResourceLocation texture = new ResourceLocation("fvtm:textures/gui/rail_main.png");
    private static RGB[][] GRID;
    private static BlockPos[][] POSGRID;
    private static IBlockState[][] STATEGRID;
    private static ArrayList<Junction> junctions;
    private static boolean noterrain;
    private static boolean noblocks;
    private static Orient orient;
    private static int cx;
    private static int cz;
    private static Zoom zoom;
    private RailSystem system;
    private static int itemslot;
    private static Track demotrack;
    private static QV3D begin;
    private static QV3D end;
    private static ArrayList<QV3D> points;
    private OrientButton orientbutton;
    private ArrayList<String> ttip = new ArrayList();

    public RailPlacer(EntityPlayer player, int x, int y, int z) {
        super(texture, (GenericContainer)new RailPlacerContainer(player, x, y, z), player);
        int i;
        Zoom zoom = RailPlacer.zoom = y < 0 || y >= Zoom.values().length ? Zoom.NONE : Zoom.values()[y];
        if (orient == null) {
            orient = Orient.C;
        }
        itemslot = x;
        cx = (player.func_180425_c().func_177958_n() >> 4) - RailPlacer.zoom.co;
        cz = (player.func_180425_c().func_177952_p() >> 4) - RailPlacer.zoom.co;
        this.defbackground = true;
        this.deftexrect = true;
        ((RailPlacerContainer)this.container).gui = this;
        this.field_146999_f = 256;
        this.field_147000_g = 206;
        junctions.clear();
        GRID = new RGB[RailPlacer.zoom.gs][RailPlacer.zoom.gs];
        POSGRID = new BlockPos[RailPlacer.zoom.gs][RailPlacer.zoom.gs];
        STATEGRID = new IBlockState[RailPlacer.zoom.gs][RailPlacer.zoom.gs];
        for (int i2 = 0; i2 < RailPlacer.zoom.gs; ++i2) {
            for (int j = 0; j < RailPlacer.zoom.gs; ++j) {
                BlockPos pos = RailPlacer.getPos(player.field_70170_p, i2 + cx * 16, j + cz * 16);
                IBlockState state = player.field_70170_p.func_180495_p(pos);
                RailPlacer.POSGRID[i2][j] = pos;
                RailPlacer.STATEGRID[i2][j] = state;
            }
        }
        this.system = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)player.field_70170_p), RailSystem.class);
        int d = RailPlacer.zoom.co * 2 + 1;
        for (i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                junctions.addAll(this.system.getJunctionsInChunk(cx + i, cz + j));
            }
        }
        for (i = 0; i < RailPlacer.zoom.gs; ++i) {
            for (int j = 0; j < RailPlacer.zoom.gs; ++j) {
                int m = 0;
                if (RailPlacer.isWater(STATEGRID[i][j].func_177230_c())) {
                    d = 0;
                    for (int k = 0; k < 256 && RailPlacer.isWater(player.field_70170_p.func_180495_p(POSGRID[i][j].func_177979_c(k)).func_177230_c()); ++k) {
                        ++d;
                    }
                    m = d > 5 ? (d > 10 ? 0 : 1) : 2;
                } else {
                    m = 1;
                    if (player.field_70170_p.func_180495_p(POSGRID[i][j].func_177982_a(0, 1, -1)).func_185909_g((IBlockAccess)player.field_70170_p, POSGRID[i][j]) != MapColor.field_151660_b) {
                        --m;
                    }
                    if (player.field_70170_p.func_180495_p(POSGRID[i][j].func_177982_a(0, 0, -1)).func_185909_g((IBlockAccess)player.field_70170_p, POSGRID[i][j]) == MapColor.field_151660_b) {
                        ++m;
                    }
                }
                RailPlacer.GRID[i][j] = new RGB(STATEGRID[i][j].func_185909_g((IBlockAccess)player.field_70170_p, POSGRID[i][j]).func_151643_b(m));
            }
        }
    }

    public static final BlockPos getPos(World world, int x, int z) {
        for (int i = 255; i > 0; --i) {
            BlockPos pos = new BlockPos(x, i, z);
            IBlockState state = world.func_180495_p(pos);
            if (!RailPlacer.isSolid(state, world, pos) && !RailPlacer.isWater(state.func_177230_c())) continue;
            return pos;
        }
        return new BlockPos(x, 0, z);
    }

    private static boolean isSolid(IBlockState state, World world, BlockPos pos) {
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && !state.func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public static boolean isWater(Block block) {
        return block instanceof BlockLiquid || block instanceof BlockFluidBase;
    }

    protected void init() {
        this.buttons.put("zoom-", new GenericGui.BasicButton("z-", this.field_147003_i + 223, this.field_147009_r + 7, 223, 7, 12, 12, zoom.ordinal() > 0));
        this.buttons.put("zoom+", new GenericGui.BasicButton("z+", this.field_147003_i + 237, this.field_147009_r + 7, 237, 7, 12, 12, zoom.ordinal() < 2));
        this.orientbutton = new OrientButton(this.field_147003_i, this.field_147009_r);
        this.buttons.put("orient", this.orientbutton);
        this.buttons.put("field", new FieldButton(this.field_147003_i, this.field_147009_r));
        for (Junction junc : junctions) {
            this.buttons.put("j" + junc.getPos().asIDString(), new JunctionButton(junc));
        }
        for (QV3D point : points) {
            this.buttons.put("p" + point.asIDString(), new PointButton(point));
        }
        this.buttons.put("terrain", new GenericGui.BasicButton("terrain", this.field_147003_i + 202, this.field_147009_r + 188, 202, 188, 10, 10, true));
        this.buttons.put("confirm", new GenericGui.BasicButton("confirm", this.field_147003_i + 237, this.field_147009_r + 187, 237, 187, 12, 12, true));
        this.buttons.put("reset", new GenericGui.BasicButton("reset", this.field_147003_i + 224, this.field_147009_r + 187, 224, 187, 12, 12, true));
        this.buttons.put("noblock", new GenericGui.BasicButton("noblock", this.field_147003_i + 201, this.field_147009_r + 7, 120, 244, 20, 12, true){

            public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
                this.ty = noblocks ? 232 : 244;
                super.draw(gui, pticks, mouseX, mouseY);
            }
        });
        for (int i = 0; i < 12; ++i) {
            if (i != 11) {
                this.buttons.put("ad" + i, new B88("d" + i, this.field_147003_i + 221, this.field_147009_r + 23 + i * 12, 56, 240, 8, 8));
            }
            if (i != 0) {
                this.buttons.put("au" + i, new B88("u" + i, this.field_147003_i + 230, this.field_147009_r + 23 + i * 12, 64, 240, 8, 8));
            }
            this.buttons.put("ar" + i, new B88("r" + i, this.field_147003_i + 239, this.field_147009_r + 23 + i * 12, 72, 240, 8, 8));
        }
    }

    protected void predraw(float pticks, int mouseX, int mouseY) {
        for (int i = 0; i < 12; ++i) {
            if (i != 11) {
                ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"ad").append((int)i).toString())).visible = ((GenericGui.BasicButton)this.buttons.get("ad" + i)).hovered(mouseX, mouseY);
            }
            if (i != 0) {
                ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"au").append((int)i).toString())).visible = ((GenericGui.BasicButton)this.buttons.get("au" + i)).hovered(mouseX, mouseY);
            }
            ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"ar").append((int)i).toString())).visible = ((GenericGui.BasicButton)this.buttons.get((Object)new StringBuilder().append((String)"ar").append((int)i).toString())).hovered;
        }
    }

    protected void drawbackground(float pticks, int mouseX, int mouseY) {
        if (!noterrain) {
            for (int i = 0; i < RailPlacer.zoom.gs; ++i) {
                for (int j = 0; j < RailPlacer.zoom.gs; ++j) {
                    GRID[i][j].glColorApply();
                    this.func_73729_b(this.field_147003_i + RailPlacer.zoom.bo + i * RailPlacer.zoom.cs, this.field_147009_r + RailPlacer.zoom.bo + j * RailPlacer.zoom.cs, 7, 7, RailPlacer.zoom.cs, RailPlacer.zoom.cs);
                }
            }
        }
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)4.0f);
        for (Junction junc : junctions) {
            this.renderJunction(junc);
        }
        if (demotrack != null) {
            this.renderTrack(demotrack, false);
        }
        GL11.glLineWidth((float)1.0f);
        GL11.glEnable((int)3553);
    }

    private void renderJunction(Junction junc) {
        for (Track track : junc.tracks) {
            this.renderTrack(track, true);
        }
    }

    private void renderTrack(Track conn, boolean junc) {
        if (conn.isOppositeCopy()) {
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        float flfl = junc ? 0.0f : 1.0f;
        float glgl = junc ? 1.0f : 0.0f;
        for (int j = 0; j < conn.vecpath.length - 1; ++j) {
            V3D vec0 = conn.vecpath[j];
            V3D vec1 = conn.vecpath[j + 1];
            bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((vec0.x - (double)(cx * 16)) * (double)RailPlacer.zoom.cs + (double)this.field_147003_i + (double)RailPlacer.zoom.bo, (vec0.z - (double)(cz * 16)) * (double)RailPlacer.zoom.cs + (double)this.field_147009_r + (double)RailPlacer.zoom.bo, (double)(this.field_73735_i + 1.0f)).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b((vec1.x - (double)(cx * 16)) * (double)RailPlacer.zoom.cs + (double)this.field_147003_i + (double)RailPlacer.zoom.bo, (vec1.z - (double)(cz * 16)) * (double)RailPlacer.zoom.cs + (double)this.field_147009_r + (double)RailPlacer.zoom.bo, (double)(this.field_73735_i + 1.0f)).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    protected void drawlast(float pticks, int mouseX, int mouseY) {
        for (int i = 0; i < 12 && i + 1 < points.size(); ++i) {
            QV3D vec = points.get(i + 1);
            this.field_146289_q.func_78276_b(vec.x + "-" + vec.y + "-" + vec.z, this.field_147003_i + 201, this.field_147009_r + 24 + i * 12, MapColor.field_151646_E.field_76291_p);
        }
        this.ttip.clear();
        if (mouseX >= this.field_147003_i + RailPlacer.zoom.bo && mouseX < this.field_147003_i + RailPlacer.zoom.bo + RailPlacer.zoom.ts && mouseY >= this.field_147009_r + RailPlacer.zoom.bo && mouseY < this.field_147009_r + RailPlacer.zoom.bo + RailPlacer.zoom.ts) {
            int x = (mouseX - this.field_147003_i - RailPlacer.zoom.bo) / RailPlacer.zoom.cs;
            int y = (mouseY - this.field_147009_r - RailPlacer.zoom.bo) / RailPlacer.zoom.cs;
            this.ttip.add("\u00a77Pos: " + POSGRID[x][y].func_177958_n() + "x, " + POSGRID[x][y].func_177956_o() + "y, " + POSGRID[x][y].func_177952_p() + "z, ");
            this.ttip.add("\u00a77Block: " + STATEGRID[x][y].func_177230_c().func_149732_F());
            BlockPos pos = POSGRID[x][y].func_177984_a();
            ArrayList<Junction> juncs = this.system.getJunctionsAt(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (juncs.size() > 0) {
                if (juncs.size() == 1) {
                    this.ttip.add("\u00a79Junction: \u00a7b" + (juncs.get((int)0).tracks.isEmpty() ? "empty" : juncs.get((int)0).tracks.size() + " tracks"));
                } else {
                    this.ttip.add("\u00a76Junctions " + juncs.size());
                    for (Junction junc : juncs) {
                        this.ttip.add("\u00a79J-" + Orient.get(junc.getPos()) + ": " + "\u00a7" + "b" + (junc.tracks.isEmpty() ? "empty" : junc.tracks.size() + " tracks"));
                    }
                }
            } else {
                this.ttip.add("\u00a79No Junction/s at this position.");
            }
        }
        if (this.orientbutton.hovered) {
            this.ttip.add("\u00a76Selected J-orientation: " + orient.name());
        }
        if (this.ttip.size() > 0) {
            this.drawHoveringText(this.ttip, mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
        if (ClientReceiver.LAST_MSG != null) {
            this.field_146289_q.func_175063_a(ClientReceiver.LAST_MSG, (float)this.field_147003_i, (float)(this.field_147009_r - 10), MapColor.field_151666_j.field_76291_p);
        }
    }

    protected boolean buttonClicked(int mouseX, int mouseY, int mouseButton, String key, GenericGui.BasicButton button) {
        if (button.name.equals("z-")) {
            RailPlacer.openGui((int)706, (int[])new int[]{0, zoom.ordinal() - 1, 0}, (String)"fvtm:gui");
            return true;
        }
        if (button.name.equals("z+")) {
            RailPlacer.openGui((int)706, (int[])new int[]{0, zoom.ordinal() + 1, 0}, (String)"fvtm:gui");
            return true;
        }
        if (button.name.equals("orient")) {
            int i = orient.ordinal();
            orient = i + 1 >= Orient.values().length - 1 ? Orient.TL : Orient.values()[i + 1];
            return true;
        }
        if (button.name.equals("field")) {
            int x = (mouseX - this.field_147003_i - RailPlacer.zoom.bo) / RailPlacer.zoom.cs;
            int y = (mouseY - this.field_147009_r - RailPlacer.zoom.bo) / RailPlacer.zoom.cs;
            if (x < 0 || y < 0 || x >= RailPlacer.zoom.gs || y >= RailPlacer.zoom.gs) {
                return true;
            }
            BlockPos blp = POSGRID[x][y].func_177984_a();
            QV3D pos = QV3D.exact(blp.func_177958_n(), blp.func_177956_o(), blp.func_177952_p(), (byte)RailPlacer.orient.x, (byte)0, (byte)RailPlacer.orient.z);
            Junction junc = this.system.getJunction(pos.pos);
            if (mouseButton > 0) {
                if (junc == null) {
                    NBTTagCompound compound = new NBTTagCompound();
                    pos.write(TagCW.wrap((Object)compound), "pos");
                    compound.func_74778_a("cargo", "set_junc");
                    ((RailPlacerContainer)this.container).send(Side.SERVER, compound);
                } else if (junc.tracks.size() > 0) {
                    Print.chat((ICommandSender)((RailPlacerContainer)this.container).sender, (String)"&bPlease remove all connected tracks first!");
                } else {
                    NBTTagCompound compound = new NBTTagCompound();
                    pos.write(TagCW.wrap((Object)compound), "pos");
                    compound.func_74778_a("cargo", "del_junc");
                    ((RailPlacerContainer)this.container).send(Side.SERVER, compound);
                }
                return true;
            }
            if (end != null) {
                return true;
            }
            if (begin == null) {
                if (junc != null) {
                    begin = pos;
                    points.add(pos);
                }
            } else if (junc != null) {
                end = pos;
                this.retrack(end);
                points.add(pos);
            } else if (begin != null) {
                if (points.size() < 13) {
                    this.retrack(pos);
                    this.buttons.put("p" + pos.asIDString(), new PointButton(pos));
                    points.add(pos);
                } else {
                    Print.chat((ICommandSender)((RailPlacerContainer)this.container).sender, (String)"&eGUI track point limit reached.");
                }
            }
            return true;
        }
        if (button.name.equals("confirm")) {
            if (begin == null || end == null || points.isEmpty()) {
                return true;
            }
            ItemStack stack = this.player.field_71071_by.func_70301_a(itemslot);
            if (stack.func_77973_b() instanceof RailGaugeItem) {
                NBTTagList list = new NBTTagList();
                for (int i = 0; i < points.size() - 1; ++i) {
                    list.func_74742_a((NBTBase)points.get(i).write(null, null).local());
                }
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("points", (NBTBase)list);
                end.write(TagCW.wrap((Object)compound), "pos");
                compound.func_74757_a("noblocks", noblocks);
                compound.func_74778_a("cargo", "place");
                ((RailPlacerContainer)this.container).send(Side.SERVER, compound);
                this.resetPoints();
            } else {
                Print.chat((ICommandSender)((RailPlacerContainer)this.container).sender, (String)"&cNo valid item in hand.");
            }
            return true;
        }
        if (button.name.equals("reset")) {
            this.resetPoints();
            return true;
        }
        if (button.name.equals("terrain")) {
            noterrain = !noterrain;
            return true;
        }
        if (button.name.equals("noblock")) {
            noblocks = !noblocks;
            return true;
        }
        if (button.name.startsWith("d")) {
            int i = Integer.parseInt(button.name.replace("d", "")) + 1;
            if (i < 0 || i + 1 >= points.size()) {
                return true;
            }
            Collections.swap(points, i, i + 1);
            this.retrack(null);
        } else if (button.name.startsWith("u")) {
            int i = Integer.parseInt(button.name.replace("u", "")) + 1;
            if (i - 1 < 0 || i >= points.size()) {
                return true;
            }
            Collections.swap(points, i, i - 1);
            this.retrack(null);
        } else if (button.name.startsWith("r")) {
            int i = Integer.parseInt(button.name.replace("r", "")) + 1;
            if (i < 0 || i >= points.size()) {
                return true;
            }
            QV3D vec = points.remove(i);
            this.buttons.remove("p" + vec.asIDString());
            this.retrack(null);
        }
        return false;
    }

    private void retrack(QV3D pos) {
        demotrack = points.size() < 2 && pos == null ? null : (pos != null ? new Track(null, points.toArray(new QV3D[0]), pos, null) : new Track(null, points.toArray(new QV3D[0]), null));
    }

    private void resetPoints() {
        this.buttons.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith("p"));
        end = null;
        begin = null;
        demotrack = null;
        points.clear();
    }

    protected void scrollwheel(int am, int x, int y) {
    }

    static {
        junctions = new ArrayList();
        points = new ArrayList();
    }

    public static class B88
    extends GenericGui.BasicButton {
        public B88(String string, int x, int y, int u, int v, int w, int h) {
            super(string, x, y, u, v, w, h, true);
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            gui.func_73729_b(this.x, this.y, this.tx, this.ty - (this.hovered ? 8 : 0), this.sizex, this.sizey);
        }
    }

    public static class FieldButton
    extends GenericGui.BasicButton {
        public FieldButton(int l, int t) {
            super("field", 7 + l, 7 + t, 7, 7, 192, 192, true);
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
        }
    }

    public static class OrientButton
    extends GenericGui.BasicButton {
        public OrientButton(int l, int t) {
            super("orient", 213 + l, 189 + t, 112, 248, 8, 8, true);
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
            this.tx = 48 + orient.ordinal() * 8;
            super.draw(gui, pticks, mouseX, mouseY);
        }
    }

    public static class PointButton
    extends GenericGui.BasicButton {
        public PointButton(QV3D vec) {
            super("p" + vec, 0, 0, 0, 0, zoom.cs, zoom.cs, true);
            this.x = vec.pos.x - cx * 16;
            this.y = vec.pos.z - cz * 16;
            if (zoom.ordinal() == 1) {
                this.x *= zoom.cs;
                this.y *= zoom.cs;
            } else if (zoom.ordinal() == 2) {
                this.x *= zoom.cs;
                this.y *= zoom.cs;
            }
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            Gui.func_152125_a((int)(gui.getGuiLeft() + this.x + zoom.bo), (int)(gui.getGuiTop() + this.y + zoom.bo), (float)24.0f, (float)244.0f, (int)12, (int)12, (int)zoom.cs, (int)zoom.cs, (float)256.0f, (float)256.0f);
        }
    }

    public static class JunctionButton
    extends GenericGui.BasicButton {
        public Junction junction;
        private boolean centered;

        public JunctionButton(Junction junc) {
            super("j" + junc.getPos().asIDString(), 0, 0, 0, 0, zoom.cs, zoom.cs, true);
            this.junction = junc;
            this.x = junc.getPos().pos.x - cx * 16;
            this.y = junc.getPos().pos.z - cz * 16;
            boolean bl = this.centered = junc.getPos().x == 8 && junc.getPos().z == 8;
            if (zoom.ordinal() == 1) {
                this.x *= zoom.cs;
                this.y *= zoom.cs;
            } else if (zoom.ordinal() == 2) {
                this.x *= zoom.cs;
                this.y *= zoom.cs;
            }
        }

        public void draw(GenericGui<?> gui, float pticks, int mouseX, int mouseY) {
            if (!this.visible) {
                return;
            }
            Gui.func_152125_a((int)(gui.getGuiLeft() + this.x + zoom.bo), (int)(gui.getGuiTop() + this.y + zoom.bo), (float)(this.isRed() ? 0.0f : (this.centered ? 36.0f : 12.0f)), (float)244.0f, (int)12, (int)12, (int)zoom.cs, (int)zoom.cs, (float)256.0f, (float)256.0f);
        }

        private boolean isRed() {
            if (begin != null && begin.equals(this.junction.getPos())) {
                return true;
            }
            return end != null && end.equals(this.junction.getPos());
        }
    }

    public static enum Orient {
        TL(0, 0),
        T(8, 0),
        TR(16, 0),
        L(16, 8),
        BL(16, 16),
        B(8, 16),
        BR(0, 16),
        R(0, 8),
        C(8, 8),
        IR(-1, -1);

        int x;
        int z;

        private Orient(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public static String get(QV3D vec) {
            Enum o = null;
            if (vec.y == 0) {
                for (Orient or : Orient.values()) {
                    if (or.x != vec.x || or.z != vec.z) continue;
                    o = or;
                    break;
                }
            }
            if (o == null || o == IR) {
                return "IR|" + vec.x + "|" + vec.y + "|" + vec.z;
            }
            return o.name();
        }
    }

    public static enum Zoom {
        NONE(1, 172, 172, 15, 5),
        ONE(2, 80, 160, 23, 2),
        TWO(4, 48, 192, 7, 1);

        public int cs;
        public int gs;
        public int ts;
        public int bo;
        public int co;

        private Zoom(int cz, int gz, int tz, int to, int cx) {
            this.cs = cz;
            this.gs = gz;
            this.ts = tz;
            this.bo = to;
            this.co = cx;
        }
    }
}

