/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.rail;

import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.gui.GuiCommandSender;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.Perms;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class RailPlacerContainer
extends GenericContainer {
    protected GenericGui<RailPlacerContainer> gui;
    protected GuiCommandSender sender;
    private int itemslot;
    private int zoom;
    private RailSystem system;

    public RailPlacerContainer(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.itemslot = x;
        this.zoom = y;
        this.system = SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)player.field_70170_p), RailSystem.class);
        this.sender = new GuiCommandSender(player);
        if (!player.field_70170_p.field_72995_K && !Perms.RAIL_PLACER_GUI.has(player)) {
            player.func_71053_j();
        }
    }

    public void initPacket(NBTTagCompound compound) {
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (this.system == null) {
            Print.chat((ICommandSender)player, (String)"Error, RailSysCap is null.");
            return;
        }
        ItemStack stack = player.field_71071_by.func_70301_a(this.itemslot);
        RailGaugeItem item = (RailGaugeItem)stack.func_77973_b();
        QV3D vec = new QV3D(TagCW.wrap((Object)packet), "pos");
        switch (packet.func_74779_i("cargo")) {
            case "place": {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("fvtm:railpoints", packet.func_74781_a("points"));
                item.placeTrack(player, player.field_70170_p, stack, this.system, vec, this.sender, packet.func_74767_n("noblocks"));
                this.reopen();
                break;
            }
            case "set_junc": {
                Junction junc = this.system.getJunction(vec.pos);
                if (junc != null) {
                    Print.chat((ICommandSender)this.sender, (String)"&eThere is already a Junction at that position.");
                    break;
                }
                this.system.addJunction(vec);
                Print.chat((ICommandSender)this.sender, (String)("&2Junction created! " + vec.asIDString()));
                this.reopen();
                break;
            }
            case "del_junc": {
                Junction junc = this.system.getJunction(vec.pos);
                if (junc == null) {
                    Print.chat((ICommandSender)this.sender, (String)"&eThere is no a Junction at that position.");
                    break;
                }
                if (junc.tracks.size() > 0) {
                    Print.chat((ICommandSender)this.sender, (String)"&bPlease remove all connected tracks first!");
                    break;
                }
                this.system.delJunction(vec.pos);
                Print.chat((ICommandSender)this.sender, (String)("&eJunction removed! " + vec.asIDString()));
                this.reopen();
                break;
            }
        }
    }

    private void reopen() {
        this.player.openGui((Object)FVTM.getInstance(), 706, this.player.field_70170_p, this.itemslot, this.zoom, 0);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }
}

