/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.gui.wire;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fexcraft.lib.mc.gui.GenericContainer;
import net.fexcraft.lib.mc.gui.GenericGui;
import net.fexcraft.mod.fvtm.FVTM;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.RelayData;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class WireRelayContainer
extends GenericContainer {
    protected GenericGui<WireRelayContainer> gui;
    protected WireSystem system;
    protected BlockTileEntity tile;
    protected RelayData data;
    protected List<String> conns;
    protected ItemStack stack;
    protected WireType type;
    protected static String SELRELAY;
    protected RelayHolder holder;
    protected WireRelay relay;
    protected static int WIRE;
    protected Wire wire;
    protected boolean opp;
    protected static String CURRDECO;
    protected TreeMap<String, ArrayList<WireDeco>> models = new TreeMap();
    protected ArrayList<String> modelkeys = new ArrayList();

    public WireRelayContainer(EntityPlayer player, World world, int x, int y, int z, boolean reset) {
        super(player);
        this.system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)world));
        this.tile = (BlockTileEntity)world.func_175625_s(new BlockPos(x, y, z));
        this.data = ((Block)this.tile.getBlockData().getType()).getRelayData();
        this.holder = this.system.getHolder(WrapperHolder.getPos((Object)this.tile.func_174877_v()));
        this.conns = new ArrayList<String>(this.holder.relays.keySet());
        this.stack = player.func_184614_ca();
        this.type = ((WireItem)this.stack.func_77973_b()).getContent();
        if (!this.stack.func_77942_o()) {
            this.stack.func_77982_d(new NBTTagCompound());
        }
        if (!reset && SELRELAY != null) {
            this.relay = this.holder.get(SELRELAY);
            Wire wire = this.wire = WIRE > -1 && this.relay.size() > WIRE ? this.relay.wires.get(WIRE) : null;
            if (this.wire != null) {
                if (this.wire.copy) {
                    this.wire = this.system.getWire(this.wire.okey);
                    this.opp = true;
                }
                this.models.clear();
                this.modelkeys.clear();
                List decos = FvtmRegistry.WIREDECOS.stream().filter(deco -> deco.accepts(this.wire.getWireType().getType())).collect(Collectors.toList());
                for (WireDeco deco2 : decos) {
                    if (!this.models.containsKey(deco2.getType())) {
                        this.models.put(deco2.getType(), new ArrayList());
                    }
                    this.models.get(deco2.getType()).add(deco2);
                }
                for (String key : this.models.keySet()) {
                    if (this.modelkeys.contains(key)) continue;
                    this.modelkeys.add(key);
                }
                if (!this.modelkeys.contains(CURRDECO)) {
                    CURRDECO = "relay";
                }
            }
        }
    }

    protected void packet(Side side, NBTTagCompound packet, EntityPlayer player) {
        if (!packet.func_74764_b("cargo")) {
            return;
        }
        if (side.isServer()) {
            switch (packet.func_74779_i("cargo")) {
                case "connect": {
                    return;
                }
                case "open_editor": {
                    player.openGui((Object)FVTM.getInstance(), 711, player.field_70170_p, this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p());
                    return;
                }
                case "edit_wire": {
                    player.openGui((Object)FVTM.getInstance(), 712, player.field_70170_p, this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p());
                    return;
                }
                case "del_wire": {
                    this.holder = this.system.getHolder(WrapperHolder.getPos((long)packet.func_74763_f("holder")));
                    this.relay = this.holder.get(this.conns.indexOf(packet.func_74779_i("relay")));
                    this.relay.remove(packet.func_74762_e("index"), true);
                    return;
                }
                case "reset_deco": {
                    this.wire = this.system.getWire(new WireKey(TagCW.wrap((Object)packet.func_74775_l("wire"))));
                    String deco = packet.func_74779_i("type");
                    if (deco.equals("relay")) {
                        if (!packet.func_74767_n("opp")) {
                            this.wire.deco_start = null;
                        } else {
                            this.wire.deco_end = null;
                        }
                    } else if (this.wire.decos != null) {
                        this.wire.decos.remove(deco);
                    }
                    this.wire.getRelay().updateClient();
                    player.openGui((Object)FVTM.getInstance(), 712, player.field_70170_p, this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p());
                    return;
                }
                case "select_deco": {
                    this.wire = this.system.getWire(new WireKey(TagCW.wrap((Object)packet.func_74775_l("wire"))));
                    String deco = packet.func_74779_i("type");
                    String seld = packet.func_74779_i("selected");
                    if (deco.equals("relay")) {
                        if (!packet.func_74767_n("opp")) {
                            this.wire.deco_start = seld;
                        } else {
                            this.wire.deco_end = seld;
                        }
                    } else {
                        if (this.wire.decos == null) {
                            this.wire.decos = new HashMap();
                        }
                        this.wire.decos.put(deco, seld);
                    }
                    this.wire.getRelay().updateClient();
                    player.openGui((Object)FVTM.getInstance(), 712, player.field_70170_p, this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p());
                    return;
                }
                case "set_slack": {
                    Wire wire0 = this.system.getWire(new WireKey(TagCW.wrap((Object)packet.func_74775_l("wire"))));
                    Wire wire1 = this.system.getWire(wire0.okey);
                    float value = packet.func_74760_g("slack");
                    if (value > 8.0f) {
                        value = 8.0f;
                    }
                    if (value < -8.0f) {
                        value = -8.0f;
                    }
                    wire0.slack = wire1.slack = value;
                    wire0.reslack();
                    wire1.reslack();
                    wire0.getRelay().updateClient();
                    wire1.getRelay().updateClient();
                    return;
                }
            }
        } else {
            packet.func_74779_i("cargo").getClass();
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void nextdeco() {
        int idx = this.modelkeys.indexOf(CURRDECO);
        idx = idx < 0 || idx >= this.modelkeys.size() - 1 ? 0 : ++idx;
        CURRDECO = this.modelkeys.size() == 0 ? "relay" : this.modelkeys.get(idx);
    }

    public String currdeconame() {
        if (CURRDECO.equals("relay")) {
            if (this.wire.key.start_relay.equals(this.relay.getKey())) {
                return this.wire.deco_start;
            }
            return this.wire.deco_end;
        }
        return this.wire.decos == null ? null : this.wire.decos.get(CURRDECO);
    }

    static {
        WIRE = -1;
        CURRDECO = "relay";
    }
}

