/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Cloth;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.uni.EnvInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClothItem
extends ItemArmor
implements ItemTextureable.TextureableItem<Cloth> {
    private Cloth cloth;
    private static final DecimalFormat df = new DecimalFormat("##.##");

    public ClothItem(Cloth cloth) {
        super((ItemArmor.ArmorMaterial)cloth.getMaterial().local(), 0, EntityEquipmentSlot.func_188451_a((String)cloth.getEqSlot().toLowerCase()));
        this.cloth = cloth;
        this.func_77627_a(true);
        this.setRegistryName(cloth.getID().colon());
        this.func_77655_b(cloth.getID().colon());
        if (cloth.getMaxDamage() > 0) {
            this.func_77656_e(cloth.getMaxDamage());
        }
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(cloth));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "fvtm:textures/entity/blank.png";
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.cloth.getNewStack().local());
        }
    }

    public Cloth getContent() {
        return this.cloth;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.cloth.getName())));
        for (String s : this.cloth.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)("&9Worn: &7" + ClothItem.format((float)stack.func_77952_i() / (float)stack.func_77958_k() * 100.0f) + "%")));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public static String format(double d) {
        return df.format(d);
    }
}

