/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.entity.DecorationEntity;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DecorationItem
extends Item
implements ContentItem.ContentDataItem<Decoration, DecorationData>,
ItemTextureable.TextureableItem<Decoration>,
JunctionGridItem {
    private static float[][] gridcolour;
    private Decoration deco;

    public DecorationItem(Decoration type) {
        this.deco = type;
        this.func_77627_a(true);
        this.func_77625_d(this.deco.getMaxStack());
        this.setRegistryName(this.deco.getID().colon());
        this.func_77655_b(this.deco.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.deco));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.deco.getName())));
        for (String s : this.deco.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        UniStack uni = UniStack.get((Object)stack);
        if (uni == null) {
            return;
        }
        DecorationData data = this.getData(uni.stack);
        if (data != null) {
            tooltip.add(Formatter.format((String)("&9Texture: &7" + VehicleItem.getTexTitle(data))));
            if (this.deco.getModel() != null && this.deco.getModel().getCreators().size() > 0) {
                tooltip.add(Formatter.format((String)"&9Model by:"));
                for (String str : this.deco.getModel().getCreators()) {
                    tooltip.add(Formatter.format((String)("&7- " + str)));
                }
            }
        }
        tooltip.add(Formatter.format((String)"&9Right-click on a block to place a decoration."));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        DecorationData data = this.getData(UniStack.getStack((Object)stack));
        QV3D vector = new QV3D((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        DecorationEntity decoen = new DecorationEntity(world);
        decoen.func_70107_b(vector.vec.x, vector.vec.y, vector.vec.z);
        decoen.decos.add(data);
        world.func_72838_d((Entity)decoen);
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public float[][] getGridColours() {
        return gridcolour;
    }

    @Override
    public Decoration getContent() {
        return this.deco;
    }

    @Override
    public ContentType getType() {
        return ContentType.DECORATION;
    }

    @Override
    public DecorationData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public DecorationData getData(TagCW compound) {
        return new DecorationData(this.deco).read(compound);
    }

    static {
        RGB cyan = new RGB(Color.ORANGE.getRGB());
        gridcolour = new float[][]{cyan.toFloatArray(), cyan.toFloatArray()};
    }
}

