/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RailGaugeItem
extends Item
implements ContentItem<RailGauge>,
JunctionGridItem {
    private RailGauge gauge;

    public RailGaugeItem(RailGauge type) {
        this.gauge = type;
        this.func_77627_a(true);
        this.setRegistryName(this.gauge.getID().colon());
        this.func_77655_b(this.gauge.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.gauge));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Formatter.format((String)("&9Name: &7" + this.gauge.getName())));
        for (String s : this.gauge.getDescription()) {
            tooltip.add(Formatter.format((String)I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        tooltip.add(Formatter.format((String)("&9Width: &7" + this.gauge.getWidth())));
        if (this.gauge.getCompatible().size() > 0) {
            tooltip.add(Formatter.format((String)"&9Compatible with:"));
            for (String str : this.gauge.getCompatible()) {
                tooltip.add(Formatter.format((String)("&7 - " + str)));
            }
        }
        tooltip.add(Formatter.format((String)"&9- - - - - - &7-"));
        if (flag.func_194127_a()) {
            tooltip.add(Formatter.format((String)"&6Usage:"));
            tooltip.add(Formatter.format((String)"&b- Rightclick twice in the same position to create a Junction."));
            tooltip.add(Formatter.format((String)"&b- Rightclick in sequence between 2 Junctions to create a track."));
            tooltip.add(Formatter.format((String)"&b- Rightclick + Sneak to reset point cache (sequence)."));
        } else {
            tooltip.add(Formatter.format((String)"&6Enable advanced tooltips for item usage info."));
        }
        tooltip.add(Formatter.format((String)"&9- - - - - - &7-"));
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("fvtm:railpoints")) {
            NBTTagList list = (NBTTagList)stack.func_77978_p().func_74781_a("fvtm:railpoints");
            for (int k = 0; k < list.func_74745_c(); ++k) {
                tooltip.add(Formatter.format((String)("&9PT" + k + " POS:" + new QV3D(TagCW.wrap((Object)list.func_150305_b(k)), null).toString())));
            }
        } else {
            tooltip.add("No Connection data.");
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K || Config.DISABLE_RAILS) {
            return EnumActionResult.PASS;
        }
        RailSystem syscap = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, WrapperHolder.getWorld((Object)world));
        if (syscap == null) {
            Print.chat((ICommandSender)player, (String)"&cWorld Capability not found.");
            return EnumActionResult.FAIL;
        }
        QV3D vector = new QV3D((float)pos.func_177958_n() + hitX, (float)pos.func_177956_o() + hitY, (float)pos.func_177952_p() + hitZ);
        RailPlacingUtil.place(syscap, UniEntity.getEntity((Object)player), this.gauge, vector);
        return EnumActionResult.SUCCESS;
    }

    public EnumActionResult placeTrack(EntityPlayer player, World world, ItemStack stack, RailSystem syscap, QV3D vector, ICommandSender sender, boolean noblocks) {
        NBTTagList list;
        Junction junk = syscap.getJunction(vector.pos, true);
        NBTTagList nBTTagList = list = stack.func_77978_p().func_74764_b("fvtm:railpoints") ? (NBTTagList)stack.func_77978_p().func_74781_a("fvtm:railpoints") : new NBTTagList();
        if (junk == null || list.func_82582_d()) {
            if (list.func_82582_d() || !this.createdJunction(sender, syscap, player, list, vector)) {
                list.func_74742_a((NBTBase)vector.write(null, null).local());
                stack.func_77978_p().func_74782_a("fvtm:railpoints", (NBTBase)list);
                Print.chatbar((ICommandSender)sender, (String)(list.func_74745_c() + this.getSuffix(list.func_74745_c()) + " Point Added!"));
                return EnumActionResult.SUCCESS;
            }
            stack.func_77978_p().func_82580_o("fvtm:railpoints");
            return EnumActionResult.SUCCESS;
        }
        if (!junk.tracks.isEmpty() && junk.tracks.size() < 2 && !junk.tracks.get(0).isCompatibleGauge(this.gauge)) {
            Print.chat((ICommandSender)sender, (String)"&9Item Gauge not compatible with the &7Junction's Gauge&9.");
            return EnumActionResult.FAIL;
        }
        if (junk.signal != null) {
            Print.chat((ICommandSender)sender, (String)"&9Please remove the signal first.");
            stack.func_77978_p().func_82580_o("fvtm:railpoints");
            return EnumActionResult.FAIL;
        }
        if (junk.tracks.size() >= 4) {
            Print.chat((ICommandSender)sender, (String)"&9Junction reached track limit (4)\n&c&oPoint cache reset.");
            stack.func_77978_p().func_82580_o("fvtm:railpoints");
            return EnumActionResult.FAIL;
        }
        Track track = new Track(junk, this.getVectors(TagLW.wrap((Object)list)), vector, this.gauge);
        if (track.length > (double)Config.MAX_RAIL_TRACK_LENGTH) {
            Print.chat((ICommandSender)sender, (String)"&cTrack length exceeds the configured max length.");
            return EnumActionResult.FAIL;
        }
        Junction second = syscap.getJunction(track.start.pos);
        if (second != null) {
            second.addnew(track);
            junk.addnew(track.createOppositeCopy());
            second.checkTrackSectionConsistency();
            Print.chat((ICommandSender)sender, (String)"&aTrack Created!");
            stack.func_77978_p().func_82580_o("fvtm:railpoints");
        } else {
            Print.chat((ICommandSender)sender, (String)"&cNo Junction at starting point found!");
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean createdJunction(ICommandSender sender, RailSystem syscap, EntityPlayer player, NBTTagList list, QV3D vector) {
        if (list.func_74745_c() != 1) {
            return false;
        }
        QV3D vec = this.getFirstVector(TagLW.wrap((Object)list));
        if (!vec.equals(vector)) {
            return false;
        }
        syscap.addJunction(vector);
        Print.chat((ICommandSender)sender, (String)"Junction Created!");
        return true;
    }

    private String getSuffix(int tagCount) {
        if (tagCount < 4) {
            return tagCount == 1 ? "st" : (tagCount == 2 ? "nd" : "rd");
        }
        return "th";
    }

    public QV3D[] getVectors(TagLW list) {
        QV3D[] arr = new QV3D[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new QV3D(list.getCompound(i), null);
        }
        return arr;
    }

    private QV3D getFirstVector(TagLW list) {
        return new QV3D(list.getCompound(0), null);
    }

    @Override
    public RailGauge getContent() {
        return this.gauge;
    }

    @Override
    public ContentType getType() {
        return ContentType.RAILGAUGE;
    }
}

