/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.VehicleLiftBlock;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.VehicleAndPartDataCache;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.TransmissionFunction;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VehicleItem
extends Item
implements ContentItem.ContentDataItem<Vehicle, VehicleData>,
JunctionGridItem,
ItemTextureable.TextureableItem<Vehicle> {
    private Vehicle vehicle;

    public VehicleItem(Vehicle content) {
        this.vehicle = content;
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setRegistryName(this.vehicle.getID().colon());
        this.func_77655_b(this.vehicle.getID().colon());
        if (!EnvInfo.CLIENT) {
            return;
        }
        this.func_77637_a((CreativeTabs)FvtmResources.INSTANCE.getCreativeTab(this.vehicle));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        VehicleAndPartDataCache cache = (VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null);
        if (!cache.overridesLang(false)) {
            tooltip.add(Formatter.format((String)("&9Name: &7" + this.vehicle.getName())));
        }
        for (String s : this.vehicle.getDescription()) {
            tooltip.add(Formatter.format((String)net.minecraft.client.resources.I18n.func_135052_a((String)s, (Object[])new Object[0])));
        }
        VehicleData data = cache.getVehicleData();
        if (data == null) {
            return;
        }
        tooltip.add(Formatter.format((String)("&9Texture: &7" + VehicleItem.getTexTitle(data))));
        if (data.hasPart("engine") && data.getFunctionInPart("engine", "fvtm:engine") != null) {
            tooltip.add(Formatter.format((String)("&9Engine: &7" + ((Part)data.getPart("engine").getType()).getName())));
            tooltip.add(Formatter.format((String)("&9Fuel Group: &7" + data.getPart("engine").getFunction(EngineFunction.class, "fvtm:engine").getFuelGroup()[0])));
            tooltip.add(Formatter.format((String)("&9Fuel Stored: &7" + data.getAttribute("fuel_stored").asInteger() + "mB")));
        }
        if (data.hasPart("transmission")) {
            TransmissionFunction func = (TransmissionFunction)data.getFunctionInPart("transmission", "fvtm:transmission");
            tooltip.add(Formatter.format((String)("&9Transmission: &7" + (func == null ? "disfunctional" : (func.isAutomatic() ? "automatic" : "manual")))));
        }
        tooltip.add(Formatter.format((String)("&9Weight: &7" + data.getAttribute("weight").asFloat() + "kg")));
        tooltip.add(Formatter.format((String)("&9Seats: &7" + data.getSeats().size())));
        tooltip.add(Formatter.format((String)("&9LockCode: &7" + data.getLock().getCode())));
        if (this.vehicle.getModel() != null && this.vehicle.getModel().getCreators().size() > 0) {
            tooltip.add(Formatter.format((String)"&9Model by:"));
            for (String str : this.vehicle.getModel().getCreators()) {
                tooltip.add(Formatter.format((String)("&7- " + str)));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        VehicleAndPartDataCache cache = (VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null);
        if (cache.getVehicleData().getDisplayName() != null) {
            return Formatter.format((String)("&o" + cache.getVehicleData().getName()));
        }
        if (!cache.overridesLang(false)) {
            String langname = "item." + stack.func_77973_b().getRegistryName().toString() + ".name";
            if ((langname = I18n.func_74838_a((String)langname).trim()).length() > 0) {
                return langname;
            }
            if (cache != null) {
                ((VehicleAndPartDataCache)stack.getCapability(Capabilities.VAPDATA, null)).overridesLang(true);
            }
        }
        return Formatter.format((String)((Vehicle)cache.getVehicleData().getType()).getName());
    }

    public static String getTexTitle(Textureable.TextureUser data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + data.getTexHolder().getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public VehicleData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public VehicleData getData(TagCW compound) {
        return new VehicleData(this.vehicle).read(compound);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == CreativeTabs.field_78027_g || tab == this.func_77640_w()) {
            items.add(this.vehicle.getNewStack().local());
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K || side != EnumFacing.UP) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c() instanceof VehicleLiftBlock) {
            return EnumActionResult.PASS;
        }
        VehicleData data = (VehicleData)((VehicleItem)stack.func_77973_b()).getDataFromTag(stack.func_77978_p());
        EntityW ent = UniEntity.getEntity((Object)player);
        EntitySystem.spawnVehicle((MessageSender)ent, ent.getWorld(), new V3D((double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ)), data, UniStack.getStack((Object)stack));
        return EnumActionResult.SUCCESS;
    }

    @Override
    public boolean showJunctionGrid() {
        return this.vehicle.getVehicleType().isRailVehicle();
    }

    @Override
    public Vehicle getContent() {
        return this.vehicle;
    }

    @Override
    public ContentType getType() {
        return ContentType.VEHICLE;
    }
}

