/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Material;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelGroupList;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.RenderOrder;
import net.fexcraft.mod.fvtm.model.Transforms;
import net.fexcraft.mod.fvtm.model.program.AnimationPrograms;
import net.fexcraft.mod.fvtm.model.program.ConditionalPrograms;
import net.fexcraft.mod.uni.IDLManager;
import org.lwjgl.opengl.GL11;

public class DefaultModel
implements Model {
    public static DefaultModel LAST;
    public static final DefaultModel EMPTY;
    public static final ModelRenderData RENDERDATA;
    public TreeMap<RenderOrder, ModelGroupList> sorted = new TreeMap();
    public ModelGroupList groups = new ModelGroupList.DefaultModelGroupList();
    private List<String> authors = new ArrayList<String>();
    public Transforms transforms = new Transforms();
    public boolean smooth_shading;
    public int tex_width;
    public int tex_height;
    public boolean locked;
    public String name;

    @Override
    public void render(ModelRenderData data) {
        LAST = this;
        this.transforms.apply();
        if (FvtmRegistry.is112) {
            GL11.glShadeModel((int)(this.smooth_shading ? 7424 : 7425));
        }
        for (ModelGroupList list : this.sorted.values()) {
            list.render(data);
        }
        this.transforms.deapply();
    }

    @Override
    public Collection<String> getCreators() {
        return this.authors;
    }

    @Override
    public boolean addToCreators(String str) {
        if (this.locked) {
            return false;
        }
        return this.authors.add(str);
    }

    @Override
    public void setGroups(ModelGroupList list) {
        this.groups = list;
    }

    @Override
    public ModelGroupList getGroups() {
        return this.groups;
    }

    @Override
    public Model parse(ModelData data) {
        Vec3f vector;
        ModelGroup group;
        String[] args;
        Program.ConditionalProgram prog;
        JsonArray programs;
        this.smooth_shading = data.getBoolean("SmoothShading", false);
        if (data.has("Programs")) {
            programs = data.getArray("Programs");
            for (JsonValue val : (List)programs.value) {
                if (val.isArray()) {
                    String[] split;
                    JsonArray prarr = val.asArray();
                    if (prarr.size() > 1 && prarr.get(1).isArray()) {
                        split = prarr.get(0).string_value().trim().split(" ");
                        try {
                            prog = null;
                            prog = ModelGroup.COND_PROGRAMS.containsKey(split[1]) ? ModelGroup.COND_PROGRAMS.get(split[1]).copy() : new ConditionalPrograms.ConditionBased(split[1]);
                            if (split.length > 2) {
                                prog = (Program.ConditionalProgram)prog.parse(Arrays.copyOfRange(split, 2, split.length));
                            }
                            for (JsonValue elm : (List)prarr.get((int)1).asArray().value) {
                                prog.addIf(DefaultModel.parseProgram(elm.string_value().trim().split(" "), 0));
                            }
                            if (prarr.size() > 2) {
                                for (JsonValue elm : (List)prarr.get((int)2).asArray().value) {
                                    prog.addElse(DefaultModel.parseProgram(elm.string_value().trim().split(" "), 0));
                                }
                            }
                            this.groups.get(split[0]).addProgram(prog);
                        }
                        catch (Exception e) {
                            FvtmLogger.log(e, "cond-program parsing | " + prarr.get(0).string_value());
                        }
                        continue;
                    }
                    split = prarr.get(0).string_value().trim().split(" ");
                    try {
                        AnimationPrograms.AnimationRoot root = (AnimationPrograms.AnimationRoot)((Object)DefaultModel.parseProgram(split));
                        for (int i = 1; i < prarr.size(); ++i) {
                            String[] splt = prarr.get(i).string_value().trim().split(" ");
                            String[] od = splt[0].split("-");
                            int off = Integer.parseInt(od[0]);
                            int n = od.length > 1 ? Integer.parseInt(od[1]) : 0;
                            root.addProgram(off, n, DefaultModel.parseProgram(splt));
                        }
                        this.groups.get(split[0]).addProgram((Program)((Object)root));
                    }
                    catch (Exception e) {
                        FvtmLogger.log(e, "program parsing | " + prarr.get(0).string_value());
                    }
                    continue;
                }
                String[] split = val.string_value().trim().split(" ");
                if (!this.groups.contains(split[0])) continue;
                try {
                    this.groups.get(split[0]).addProgram(DefaultModel.parseProgram(split));
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "adding program to " + split[0]);
                }
            }
        }
        if (data.has("CondPrograms")) {
            programs = data.getArray("CondPrograms");
            for (JsonValue val : (List)programs.value) {
                if (val.isMap()) {
                    JsonMap json = val.asMap();
                    if (!json.has("id") || !json.has("group")) continue;
                    try {
                        String[] array;
                        String group2 = json.get("group").string_value();
                        String progid = json.get("id").string_value();
                        Program.ConditionalProgram prog2 = null;
                        prog2 = ModelGroup.COND_PROGRAMS.containsKey(progid) ? ModelGroup.COND_PROGRAMS.get(progid).copy() : new ConditionalPrograms.ConditionBased(progid);
                        if (json.has("ifmet")) {
                            array = json.get("ifmet").asArray();
                            for (JsonValue elm : (List)array.value) {
                                prog2.addIf(DefaultModel.parseProgram(elm.string_value().trim().split(" "), 0));
                            }
                        }
                        if (json.has("else")) {
                            array = json.get("else").asArray();
                            for (JsonValue elm : (List)array.value) {
                                prog2.addElse(DefaultModel.parseProgram(elm.string_value().trim().split(" "), 0));
                            }
                        }
                        if (json.has("args")) {
                            prog2 = (Program.ConditionalProgram)prog2.parse(json.get("args").string_value().trim().split(" "));
                        }
                        this.groups.get(group2).addProgram(prog2);
                    }
                    catch (Exception e) {
                        FvtmLogger.log(e, "cond program parsing | " + val);
                    }
                    continue;
                }
                String string = val.toString();
                String[] args2 = string.trim().split("||");
                if (!this.groups.contains(args2[0])) continue;
                try {
                    String[] sub;
                    prog = null;
                    prog = ModelGroup.COND_PROGRAMS.containsKey(args2[1]) ? ModelGroup.COND_PROGRAMS.get(args2[1]).copy() : new ConditionalPrograms.ConditionBased(args2[1]);
                    for (JsonArray jsonArray : sub = args2[2].split("|")) {
                        prog.addIf(DefaultModel.parseProgram(jsonArray.trim().split(" ")));
                    }
                    if (args2.length > 3) {
                        for (String vertexArray : sub = args2[3].split("|")) {
                            prog.addElse(DefaultModel.parseProgram(vertexArray.trim().split(" ")));
                        }
                    }
                    if (args2.length > 4) {
                        prog = (ConditionalPrograms.ConditionBased)prog.parse(args2[4].trim().split(" "));
                    }
                    this.groups.get(args2[0]).addProgram(prog);
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "cond program parsing | " + val);
                }
            }
        }
        if (data.has("Transforms")) {
            for (JsonValue val : (List)data.getArray((String)"Transforms").value) {
                this.transforms.parse(val.string_value().trim().split(" "));
            }
        }
        if (data.has("Pivots")) {
            for (JsonValue val : (List)data.getArray((String)"Pivots").value) {
                args = val.string_value().trim().split(" ");
                if (!this.groups.contains(args[0])) continue;
                try {
                    group = this.groups.get(args[0]);
                    vector = new Vec3f(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                    Vec3f rotation = new Vec3f(args.length > 4 ? Float.parseFloat(args[4]) : 0.0f, args.length > 5 ? Float.parseFloat(args[5]) : 0.0f, args.length > 6 ? Float.parseFloat(args[6]) : 0.0f);
                    for (Polyhedron poly : group) {
                        for (Polygon poli : poly.polygons) {
                            Vertex[] vertexArray = poli.vertices;
                            int n = vertexArray.length;
                            for (int i = 0; i < n; ++i) {
                                Vertex vert = vertexArray[i];
                                vert.vector = vert.vector.sub(vector);
                            }
                        }
                        poly.pos(vector.x, vector.y, vector.z);
                        poly.rot(rotation.x, rotation.y, rotation.z);
                    }
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "pivot parsing | " + val.string_value());
                }
            }
        }
        if (data.has("Offset")) {
            for (JsonValue val : (List)data.getArray((String)"Offset").value) {
                args = val.string_value().trim().split(" ");
                if (!this.groups.contains(args[0])) continue;
                try {
                    group = this.groups.get(args[0]);
                    vector = new Vec3f(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                    for (Polyhedron poly : group) {
                        for (Polygon poli : poly.polygons) {
                            for (Vertex vert : poli.vertices) {
                                vert.vector = vert.vector.sub(vector);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    FvtmLogger.log(e, "offset parsing | " + val.string_value());
                }
            }
        }
        if (data.has("MaterialDict")) {
            for (Map.Entry entry : data.get("MaterialDict").asMap().entries()) {
                Material mat = Material.get((String)(data.location + "?" + (String)entry.getKey()), (boolean)false);
                if (mat.none()) continue;
                mat.texture = IDLManager.getIDLCached((String)((JsonValue)entry.getValue()).string_value());
            }
        }
        if (data.has("TextureWidth")) {
            this.tex_width = data.getInteger("TextureWidth", this.getDefTexWidth());
        }
        if (data.has("TextureHeight")) {
            this.tex_height = data.getInteger("TextureHeight", this.getDefTexHeight());
        }
        return this;
    }

    public int getDefTexWidth() {
        return 256;
    }

    public int getDefTexHeight() {
        return 256;
    }

    @Override
    public void lock() {
        if (this.locked) {
            return;
        }
        this.authors = ImmutableList.copyOf(this.authors);
        for (ModelGroup group : this.groups) {
            group.initPrograms();
        }
        this.sort();
        this.locked = true;
    }

    @Override
    public void sort() {
        this.sorted.clear();
        ArrayList<ModelGroup> nor = new ArrayList<ModelGroup>();
        ArrayList<ModelGroup> bln = new ArrayList<ModelGroup>();
        ArrayList<ModelGroup> las = new ArrayList<ModelGroup>();
        ArrayList<ModelGroup> sep = new ArrayList<ModelGroup>();
        block5: for (ModelGroup group : this.groups) {
            RenderOrder order = RenderOrder.NORMAL;
            for (Program prog : group.getAllPrograms()) {
                if (prog.order().ordinal() <= order.ordinal()) continue;
                order = prog.order();
            }
            switch (order) {
                case BLENDED: {
                    bln.add(group);
                    continue block5;
                }
                case LAST: {
                    las.add(group);
                    continue block5;
                }
                case SEPARATE: {
                    sep.add(group);
                    continue block5;
                }
            }
            nor.add(group);
        }
        if (nor.size() > 0) {
            this.sorted.put(RenderOrder.NORMAL, new ModelGroupList.DefaultModelGroupList(nor));
        }
        if (bln.size() > 0) {
            this.sorted.put(RenderOrder.BLENDED, new ModelGroupList.DefaultModelGroupList(bln));
        }
        if (las.size() > 0) {
            this.sorted.put(RenderOrder.LAST, new ModelGroupList.DefaultModelGroupList(las));
        }
        if (sep.size() > 0) {
            this.sorted.put(RenderOrder.SEPARATE, new ModelGroupList.SeparateModelGroupList(sep));
        }
    }

    @Override
    public void clearGLData() {
        for (ModelGroup group : this.groups) {
            for (Polyhedron poly : group) {
                if (poly.glId == null) continue;
                GL11.glDeleteLists((int)poly.glId, (int)1);
            }
        }
    }

    @Override
    public ModelGroupList getSeparateGroups() {
        return this.sorted.get((Object)RenderOrder.SEPARATE);
    }

    private static Program parseProgram(String[] args) throws Exception {
        return DefaultModel.parseProgram(args, 1);
    }

    private static Program parseProgram(String[] args, int atidx) throws Exception {
        if (args[atidx].startsWith("#")) {
            return null;
        }
        Program prog = (Program)ModelGroup.PROGRAMS.get(args[atidx]);
        if (prog == null) {
            throw new Exception("PROGRAM WITH ID '" + args[atidx] + "' NOT FOUND!");
        }
        return prog.parse(Arrays.copyOfRange(args, atidx + 1, args.length));
    }

    public ModelGroup get(String key) {
        return this.groups.get(key);
    }

    public void translate(float x, float y, float z) {
        for (ModelGroup group : this.groups) {
            group.translate(x, y, z, false);
        }
    }

    public void translate(float x, float y, float z, boolean set) {
        for (ModelGroup group : this.groups) {
            group.translate(x, y, z, set);
        }
    }

    static {
        EMPTY = new DefaultModel();
        RENDERDATA = new ModelRenderData();
    }
}

