/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model;

import java.util.ArrayList;
import java.util.HashMap;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.ProgramRegistry;

public class ModelGroup
extends ArrayList<Polyhedron<GLObject>> {
    public static final ProgramRegistry PROGRAMS = new ProgramRegistry();
    public static final ModelGroup EMPTY = new ModelGroup("empty");
    public static final HashMap<String, Program.ConditionalProgram> COND_PROGRAMS = new HashMap();
    private ArrayList<Program> all_programs = new ArrayList();
    protected ArrayList<Program> pre_programs = new ArrayList();
    protected ArrayList<Program> pst_programs = new ArrayList();
    public final String name;
    public float scale = 0.0625f;
    public boolean visible = true;
    public boolean has_pre_prog = false;
    public boolean has_pst_prog = false;
    private boolean initialized;

    public ModelGroup(String name) {
        this.name = name;
    }

    public void render(ModelRenderData data) {
        if (this.has_pre_prog) {
            for (Program program : this.pre_programs) {
                program.pre(this, data);
            }
        }
        if (this.visible) {
            for (Polyhedron poly : this) {
                poly.render();
            }
        }
        if (this.has_pst_prog) {
            for (Program program : this.pst_programs) {
                program.post(this, data);
            }
        }
    }

    public void render() {
        if (this.visible) {
            for (Polyhedron poly : this) {
                poly.render();
            }
        }
    }

    public void addProgram(String str) {
        this.addProgram((Program)PROGRAMS.get(str));
    }

    public void addPrograms(String ... strs) {
        for (String str : strs) {
            this.addProgram(str);
        }
    }

    public void addProgram(Program program) {
        if (program == null || this.initialized) {
            return;
        }
        if (program.pre()) {
            this.pre_programs.add(program);
        }
        if (program.post()) {
            this.pst_programs.add(program);
        }
        this.all_programs.add(program);
    }

    public void addPrograms(Program ... programs) {
        for (Program program : programs) {
            this.addProgram(program);
        }
    }

    public void initPrograms() {
        for (Program prog : this.getAllPrograms()) {
            prog.init(this);
        }
        this.has_pre_prog = this.pre_programs.size() > 0;
        this.has_pst_prog = this.pst_programs.size() > 0;
        this.initialized = true;
    }

    public ArrayList<Program> getAllPrograms() {
        return this.all_programs;
    }

    public ArrayList<Program> getPrePrograms() {
        return this.pre_programs;
    }

    public ArrayList<Program> getPstPrograms() {
        return this.pst_programs;
    }

    public void translate(float x, float y, float z, boolean set) {
        if (set) {
            for (Polyhedron poly : this) {
                poly.pos(x, y, z);
            }
        } else {
            for (Polyhedron poly : this) {
                poly.posX += x;
                poly.posY += y;
                poly.posZ += z;
            }
        }
    }

    public void scale(float flt) {
        this.scale = flt;
    }

    public void rotate(float x, float y, float z) {
        this.rotate(x, y, z, false);
    }

    public void rotate(float x, float y, float z, boolean set) {
        if (set) {
            for (Polyhedron poly : this) {
                poly.rot(x, y, z);
            }
        } else {
            for (Polyhedron poly : this) {
                poly.rotX += x;
                poly.rotY += y;
                poly.rotZ += z;
            }
        }
    }

    public void rotate(float value, int axis, boolean set) {
        if (axis == 0) {
            if (set) {
                for (Polyhedron poly : this) {
                    poly.rotX = value;
                }
            } else {
                for (Polyhedron poly : this) {
                    poly.rotX += value;
                }
            }
        } else if (axis == 1) {
            if (set) {
                for (Polyhedron poly : this) {
                    poly.rotY = value;
                }
            } else {
                for (Polyhedron poly : this) {
                    poly.rotY += value;
                }
            }
        } else if (set) {
            for (Polyhedron poly : this) {
                poly.rotZ = value;
            }
        } else {
            for (Polyhedron poly : this) {
                poly.rotZ += value;
            }
        }
    }

    @Override
    public boolean add(Polyhedron<GLObject> poly) {
        if (poly.glObj == null) {
            poly.glObj = new GLObject();
        }
        return super.add(poly);
    }

    @Override
    public boolean add(ModelRendererTurbo mrt) {
        return this.add((Polyhedron<GLObject>)new Polyhedron().importMRT(mrt, false, 0.0625f));
    }

    public <P extends Program> P getProgram(String key) {
        for (Program prog : this.all_programs) {
            if (!prog.id().equals(key)) continue;
            return (P)prog;
        }
        return null;
    }

    public ModelGroup copyWithoutPrograms() {
        ModelGroup group = new ModelGroup(this.name);
        group.addAll(this);
        group.scale = this.scale;
        return group;
    }
}

