/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model;

import java.util.ArrayList;
import java.util.function.Function;
import net.fexcraft.lib.common.math.Vec3f;
import org.lwjgl.opengl.GL11;

public class Transforms {
    public static final Transformer TF_RESCALE_NORMAL = new TF_RescaleNormal();
    public static Function<String[], Transformer> GET_TRANSFORM;
    private ArrayList<Transformer> transformers = new ArrayList();

    public void apply() {
        for (Transformer tr : this.transformers) {
            tr.apply();
        }
    }

    public void deapply() {
        for (Transformer tr : this.transformers) {
            tr.deapply();
        }
    }

    public boolean hasRotate() {
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Rotate)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<TF_Rotate> getBakedRotate() {
        ArrayList<TF_Rotate> list = new ArrayList<TF_Rotate>();
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Rotate)) continue;
            list.add((TF_Rotate)trn);
        }
        return list;
    }

    public boolean hasTranslate() {
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Translate)) continue;
            return true;
        }
        return false;
    }

    public Vec3f getBakedTranslate() {
        Vec3f vec = new Vec3f();
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Translate)) continue;
            TF_Translate tf = (TF_Translate)trn;
            vec = vec.add(tf.x, tf.y, tf.z);
        }
        return vec;
    }

    public boolean hasScale() {
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Scale)) continue;
            return true;
        }
        return false;
    }

    public Vec3f getBakedScale() {
        for (Transformer trn : this.transformers) {
            if (!(trn instanceof TF_Scale)) continue;
            TF_Scale tf = (TF_Scale)trn;
            return new Vec3f(tf.x, tf.y, tf.z);
        }
        return new Vec3f();
    }

    public void add(Transformer transformer) {
        this.transformers.add(transformer);
    }

    public void parse(String[] args) {
        Transformer form = GET_TRANSFORM.apply(args);
        if (form != null) {
            this.transformers.add(form);
        }
    }

    public ArrayList<Transformer> getTransformers() {
        return this.transformers;
    }

    public void copy(Transforms transforms) {
        this.transformers.addAll(transforms.getTransformers());
    }

    public static class TF_RescaleNormal
    implements Transformer {
        @Override
        public void apply() {
            GL11.glEnable((int)32826);
        }

        @Override
        public void deapply() {
            GL11.glDisable((int)32826);
        }
    }

    public static class TF_Scale
    implements Transformer {
        private float x;
        private float y;
        private float z;

        public TF_Scale(float xx, float yy, float zz) {
            this.x = xx;
            this.y = yy;
            this.z = zz;
        }

        @Override
        public void apply() {
            GL11.glPushMatrix();
            GL11.glScalef((float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void deapply() {
            GL11.glPopMatrix();
        }
    }

    public static class TF_Rotate
    implements Transformer {
        public final float x;
        public final float y;
        public final float z;
        public final float angle;

        public TF_Rotate(float xx, float yy, float zz, float angle) {
            this.x = xx;
            this.y = yy;
            this.z = zz;
            this.angle = angle;
        }

        @Override
        public void apply() {
            GL11.glPushMatrix();
            GL11.glRotatef((float)this.angle, (float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void deapply() {
            GL11.glPopMatrix();
        }
    }

    public static class TF_Translate
    implements Transformer {
        private float x;
        private float y;
        private float z;

        public TF_Translate(float xx, float yy, float zz) {
            this.x = xx;
            this.y = yy;
            this.z = zz;
        }

        @Override
        public void apply() {
            GL11.glTranslatef((float)this.x, (float)this.y, (float)this.z);
        }

        @Override
        public void deapply() {
            GL11.glTranslatef((float)(-this.x), (float)(-this.y), (float)(-this.z));
        }
    }

    public static interface Transformer {
        public void apply();

        public void deapply();
    }
}

