/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.block.generated.SignalTileEntity;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.ProgramUtils;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.util.GLUtils112;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.math.NumberUtils;
import org.lwjgl.opengl.GL11;

public class BlockPrograms {
    public static void init() {
        ModelGroup.PROGRAMS.add(new BlockBoolRotator("", true, 0.0f, 0.0f, 0.0f, 0, Float.valueOf(0.0f)));
        ModelGroup.PROGRAMS.add(new BlockBoolTranslator("", true, 0.0f, 0.0f, 0.0f, 0));
        ModelGroup.PROGRAMS.add(new BlockBoolVisible("", true));
        ModelGroup.PROGRAMS.add(new Block4x4RotVisible(0));
        ModelGroup.PROGRAMS.add(new BlockVariantVisible(0));
        ModelGroup.PROGRAMS.add(new BlockFacePlayer(0.0f, 0.0f, 0.0f));
        ModelGroup.PROGRAMS.add(new DefaultPrograms.AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.tile != null && ((SignalTileEntity)data.tile).getSignalState() == 1;
            }

            @Override
            public String id() {
                return "fvtm:basic_signal_clear";
            }
        });
        ModelGroup.PROGRAMS.add(new DefaultPrograms.AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.tile == null || ((SignalTileEntity)data.tile).getSignalState() == 0;
            }

            @Override
            public String id() {
                return "fvtm:basic_signal_stop";
            }
        });
    }

    public static class BlockFacePlayer
    implements Program {
        private V3D pos;

        public BlockFacePlayer(float x, float y, float z) {
            this.pos = new V3D((double)x, (double)y, (double)z);
        }

        @Override
        public String id() {
            return "fvtm:block_face_player";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.tile == null) {
                GLUtils112.translate(this.pos);
                return;
            }
            GL11.glPushMatrix();
            GL11.glRotated((double)(-((Block)data.block.getType()).getBlockType().getRotationFor(((TileEntity)data.tile).func_145832_p())), (double)0.0, (double)1.0, (double)0.0);
            GLUtils112.translate(this.pos);
            double d0 = Minecraft.func_71410_x().field_71439_g.field_70165_t - ((double)((float)((TileEntity)data.tile).func_174877_v().func_177958_n() + 0.5f) + this.pos.x);
            double d1 = Minecraft.func_71410_x().field_71439_g.field_70161_v - ((double)((float)((TileEntity)data.tile).func_174877_v().func_177952_p() + 0.5f) + this.pos.y);
            double d2 = Minecraft.func_71410_x().field_71439_g.field_70163_u + (double)Minecraft.func_71410_x().field_71439_g.eyeHeight - ((double)((TileEntity)data.tile).func_174877_v().func_177956_o() + this.pos.y);
            d2 = Math.atan2(d2, Math.sqrt(d0 * d0 + d1 * d1));
            d0 = MathHelper.func_181159_b((double)d1, (double)d0);
            GL11.glRotated((double)(-Static.toDegrees((double)d0) - 90.0), (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)Static.toDegrees((double)d2), (double)1.0, (double)0.0, (double)0.0);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.tile == null) {
                GLUtils112.translateR(this.pos);
                return;
            }
            GL11.glPopMatrix();
        }

        @Override
        public Program parse(String[] args) {
            float x = args.length > 0 ? Float.parseFloat(args[0]) : 0.0f;
            float y = args.length > 1 ? Float.parseFloat(args[1]) : 0.0f;
            float z = args.length > 2 ? Float.parseFloat(args[2]) : 0.0f;
            return new BlockFacePlayer(x, y, z);
        }
    }

    public static class BlockVariantVisible
    implements Program {
        private int equals;

        public BlockVariantVisible(int var) {
            this.equals = var;
        }

        @Override
        public String id() {
            return "fvtm:block_variant_visible";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.tile == null) {
                return;
            }
            list.visible = ((TileEntity)data.tile).func_145832_p() == this.equals;
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return new BlockVariantVisible(Integer.parseInt(args[0]));
        }
    }

    public static class Block4x4RotVisible
    implements Program {
        private int equals;

        public Block4x4RotVisible(int var) {
            this.equals = var;
        }

        @Override
        public String id() {
            return "fvtm:block_4x4rot_visible";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.tile == null) {
                return;
            }
            list.visible = ((TileEntity)data.tile).func_145832_p() / 4 == this.equals;
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return new Block4x4RotVisible(Integer.parseInt(args[0]));
        }
    }

    public static class BlockBoolVisible
    implements Program {
        private String key;
        private boolean equals;

        public BlockBoolVisible(String key, boolean equals) {
            this.key = key;
            this.equals = equals;
        }

        @Override
        public String id() {
            return "fvtm:block_bool_visible";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.block == null) {
                return;
            }
            if (data.block.getFunctionBool(this.key) != this.equals) {
                list.visible = false;
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return new BlockBoolVisible(args[0], args.length < 2 || Boolean.parseBoolean(args[1]));
        }
    }

    public static class BlockBoolTranslator
    extends BlockBoolBased {
        private boolean bool;
        private float min;
        private float max;
        private float step;
        private Float current;
        private int axis;

        public BlockBoolTranslator(String key, boolean equals, float min, float max, float step, int axis) {
            super(key);
            this.bool = equals;
            this.axis = axis;
            this.step = step;
            this.min = min;
            this.max = max;
        }

        @Override
        public String id() {
            return "fvtm:block_bool_translator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || data.block == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(data.block.getFunctionBool(this.key) == this.bool ? this.current.floatValue() + this.step : this.current.floatValue() - this.step);
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.current.floatValue() * 0.0625f : 0.0f), (float)(this.axis == 1 ? this.current.floatValue() * 0.0625f : 0.0f), (float)(this.axis == 2 ? this.current.floatValue() * 0.0625f : 0.0f));
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || data.block == null) {
                return;
            }
            GL11.glTranslatef((float)(this.axis == 0 ? this.current.floatValue() * -0.0625f : 0.0f), (float)(this.axis == 1 ? this.current.floatValue() * -0.0625f : 0.0f), (float)(this.axis == 2 ? this.current.floatValue() * -0.0625f : 0.0f));
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean equals = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            return new BlockBoolTranslator(attr, equals, min, max, step, axis);
        }
    }

    public static class BlockBoolRotator
    extends BlockBoolBased {
        private String key;
        private float min;
        private float max;
        private float step = 1.0f;
        private Float current;
        private int axis;
        private boolean equals;
        private boolean override;
        private float defrot;

        public BlockBoolRotator(String key, boolean equals, float mn, float mx, float step, int axis, Float defrot) {
            super(key);
            this.equals = equals;
            this.override = true;
            this.min = mn;
            this.max = mx;
            this.step = step;
            this.axis = axis;
            float f = this.defrot = defrot == null ? 0.0f : defrot.floatValue();
            if (this.min == this.max || this.min == 0.0f && this.max == 0.0f) {
                this.min = -360.0f;
                this.max = 360.0f;
            }
        }

        public BlockBoolRotator(String key, boolean equals, float min, float max, float step, int axis, Float defrot, boolean notadditive) {
            this(key, equals, min, max, step, axis, defrot);
            this.override = notadditive;
        }

        @Override
        public String id() {
            return "fvtm:block_bool_rotator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || data.block == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(data.block.getFunctionBool(this.key) == this.equals ? this.current.floatValue() + this.step : this.current.floatValue() - this.step);
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            list.rotate(this.current.floatValue() + this.defrot, this.axis, this.override);
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || data.block == null) {
                return;
            }
            list.rotate(this.override ? this.defrot : -(this.current.floatValue() + this.defrot), this.axis, this.override);
            this.current = Float.valueOf(0.0f);
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean equals = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            Float defrot = args.length > 6 && NumberUtils.isCreatable((String)args[6]) ? Float.valueOf(Float.parseFloat(args[6])) : null;
            return new BlockBoolRotator(attr, equals, min, max, step, axis, defrot, args.length >= 7 && Boolean.parseBoolean(args[7]));
        }
    }

    public static abstract class BlockBoolBased
    implements Program {
        protected String key;

        public BlockBoolBased(String key) {
            this.key = key;
        }

        @Override
        public void init(ModelGroup list) {
        }
    }
}

