/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.entity.ParticleEntity;
import net.fexcraft.mod.fvtm.sys.uni.EntitySystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class ParticleRenderer {
    private static final ArrayList<ParticleEntity> ents = new ArrayList();

    public static void renderParticles(World world, double cx, double cy, double cz, float ticks) {
        EntitySystem sys = (EntitySystem)SystemManager.get(SystemManager.Systems.ENTITY, WrapperHolder.getWorld((Object)world));
        if (sys == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TexUtil.bindTexture(FvtmRegistry.WHITE_TEXTURE);
        ents.addAll(sys.particles);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (ParticleEntity part : ents) {
            if (part == null || part.pos == null) {
                return;
            }
            int z = ParticleRenderer.getBrightness(part.pos);
            int x = z % 65536;
            int y = z / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)x / 1.0f), (float)((float)y / 1.0f));
            part.render(ticks, cx, cy, cz);
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        ents.clear();
    }

    public static int getBrightness(V3D vec) {
        BlockPos.MutableBlockPos mutblk = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)vec.x), 0, MathHelper.func_76128_c((double)vec.z));
        if (Minecraft.func_71410_x().field_71441_e.func_175667_e((BlockPos)mutblk)) {
            mutblk.func_185336_p(MathHelper.func_76128_c((double)vec.y));
            return Minecraft.func_71410_x().field_71441_e.func_175626_b((BlockPos)mutblk, 0);
        }
        return 0;
    }
}

