/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.condition;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.sys.condition.CondMode;
import net.fexcraft.mod.fvtm.sys.condition.CondType;

public class Condition {
    public final String id;
    public CondType type;
    public String target;
    public String condi;
    public CondMode mode;
    public String[] targets;

    public Condition(String id) {
        this.id = id;
    }

    public Condition(String id, JsonMap map) {
        this(id);
        this.type = CondType.parse(map.getString("type", CondType.CUSTOM.key));
        if (!map.has("target")) {
            String[] stringArray = new String[1];
            this.target = "null";
            stringArray[0] = "null";
            this.targets = stringArray;
        } else if (map.get("target").isArray()) {
            JsonArray arr = map.getArray("target");
            this.targets = new String[arr.size()];
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i] = arr.get(i).string_value();
            }
            this.target = this.targets[0];
        } else {
            this.target = map.getString("target", "null");
            this.targets = new String[]{this.target};
        }
        this.condi = map.has("con") ? map.getString("con", "null") : map.getString("condition", "null");
        this.mode = CondMode.parse(map.getString("mode", CondMode.EQUAL.key));
    }

    public Condition(String id, JsonArray array) {
        this(id);
        this.type = CondType.parse(array.get(0).string_value());
        if (array.get(1).isArray()) {
            JsonArray arr = array.getArray(1);
            this.targets = new String[arr.size()];
            for (int i = 0; i < this.targets.length; ++i) {
                this.targets[i] = arr.get(i).string_value();
            }
            this.target = this.targets[0];
        } else {
            this.target = array.get(1).string_value();
            this.targets = new String[]{this.target};
        }
        this.mode = CondMode.parse(array.size() > 2 ? array.get(2).string_value() : "null");
        this.condi = array.size() > 3 ? array.get(3).string_value() : "null";
    }

    public String toCompare() {
        String tars = this.target;
        if (this.targets.length > 1) {
            for (int i = 1; i < this.targets.length; ++i) {
                tars = tars + "-" + this.targets[1];
            }
        }
        return (Object)((Object)this.type) + ":" + tars + ":" + (Object)((Object)this.mode) + ":" + this.condi;
    }
}

