/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.pro;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.sys.pro.NLandVehicle;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class NWheelEntity
extends Entity
implements IEntityAdditionalSpawnData,
UniWheel {
    public RootVehicle root;
    private boolean found;
    private int vehid;
    public WheelTireData wheel;
    public String wheelid;
    protected V3D pos = new V3D();

    public NWheelEntity(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70138_W = 1.125f;
    }

    public NWheelEntity(RootVehicle root, String wid) {
        this(root.field_70170_p);
        this.root = root;
        this.vehid = this.root.func_145782_y();
        this.wheelid = wid;
        this.wheel = this.root.vehicle.wheeldata.get(wid);
        this.init();
    }

    private void init() {
        if (this.root.vehicle.wheeldata.isEmpty()) {
            if (!this.root.field_70128_L) {
                EntityItem itemstack = new EntityItem(this.field_70170_p, this.root.field_70165_t, this.root.field_70163_u, this.root.field_70161_v);
                itemstack.func_92058_a((ItemStack)this.root.vehicle.data.newItemStack().local());
                this.field_70170_p.func_72838_d((Entity)itemstack);
                this.root.func_70106_y();
            }
            return;
        }
        if (!this.root.vehicle.wheeldata.containsKey(this.wheelid)) {
            this.func_70106_y();
            return;
        }
        V3D vec = this.root.vehicle.pivot().get_vector(this.wheel.pos);
        this.func_70107_b(this.root.field_70165_t + vec.x, this.root.field_70163_u + vec.y, this.root.field_70161_v + vec.z);
        this.setStepHeight();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.vehid);
        buffer.writeInt(this.wheelid.length());
        buffer.writeCharSequence((CharSequence)this.wheelid, StandardCharsets.UTF_8);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.vehid = buffer.readInt();
        this.wheelid = buffer.readCharSequence(buffer.readInt(), StandardCharsets.UTF_8).toString();
        this.root = (RootVehicle)this.field_70170_p.func_73045_a(this.vehid);
        if (this.root == null) {
            return;
        }
        this.func_70107_b(this.root.field_70165_t, this.root.field_70163_u, this.root.field_70161_v);
        this.wheel = this.root.vehicle.wheeldata.get(this.wheelid);
        this.setStepHeight();
    }

    private void setStepHeight() {
        if (!(this.root instanceof NLandVehicle)) {
            WheelTireData wtd = this.root.vehicle.wheeldata.get(this.wheelid);
            this.field_70138_W = wtd == null ? 0.0f : wtd.function.step_height;
        } else {
            WheelTireData wtd = this.root.vehicle.wheeldata.get(this.wheelid);
            NLandVehicle veh = (NLandVehicle)this.root;
            this.field_70138_W = wtd == null ? (veh.vehicle.data == null ? 1.0f : ((Vehicle)veh.vehicle.data.getType()).getSphData().wheel_step_height) : wtd.function.step_height;
        }
    }

    public boolean isOnTrailer() {
        return ((Vehicle)this.root.vehicle.data.getType()).isTrailer();
    }

    public double getHorSpeed() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public void func_180430_e(float dis, float dam) {
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int incr, boolean tele) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_180429_a(BlockPos blockpos, Block block) {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && !this.found) {
            this.root = (RootVehicle)this.field_70170_p.func_73045_a(this.vehid);
            if (this.root == null) {
                return;
            }
            this.found = true;
            this.root.vehicle.wheels.put(this.wheelid, this);
        }
        if (this.root == null) {
            return;
        }
        if (!this.field_70175_ag) {
            this.field_70170_p.func_72838_d((Entity)this);
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public String func_70005_c_() {
        return "entity.fvtm.wheel." + this.wheelid;
    }

    @Override
    public void updatePrevPos() {
        this.pos.x = this.field_70169_q = this.field_70165_t;
        this.pos.y = this.field_70167_r = this.field_70163_u;
        this.pos.z = this.field_70166_s = this.field_70161_v;
    }

    @Override
    public void remove() {
        this.func_70106_y();
    }

    @Override
    public boolean isAdded() {
        return this.field_70175_ag;
    }

    @Override
    public V3D pos() {
        return this.pos;
    }

    @Override
    public void pos(double x, double y, double z) {
        this.func_70107_b(x, y, z);
    }

    @Override
    public void yaw(float yaw) {
        this.field_70177_z = yaw;
    }

    @Override
    public void prepare() {
        this.field_70122_E = true;
        this.field_70159_w *= 0.9;
        this.field_70179_y *= 0.9;
        this.field_70181_x = -0.4905000329017639;
    }

    @Override
    public void move() {
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    @Override
    public WheelTireData wtd() {
        return this.wheel;
    }

    @Override
    public void addMotion(double x, double y, double z) {
        this.field_70159_w += x;
        this.field_70181_x += y;
        this.field_70179_y += z;
    }

    @Override
    public void setMotion(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }
}

