/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.JuncType;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Section;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.rail.cmd.JEC;
import net.fexcraft.mod.fvtm.sys.rail.signal.SignalType;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;

public class Junction
implements SysObj {
    private QV3D vecpos;
    public ArrayList<Track> tracks;
    public boolean switch0;
    public boolean switch1;
    public RailSystem root;
    public SystemRegion<RailSystem, Junction> region;
    public SignalType signal;
    public boolean signal0;
    public boolean signal1;
    public EntryDirection signal_dir = EntryDirection.FORWARD;
    public JuncType type;
    public String station;
    public ArrayList<V3I> entities = new ArrayList();
    private ArrayList<JEC> fortrains = new ArrayList();
    private ArrayList<JEC> forswitch = new ArrayList();
    protected AABB frustumbb;
    public V3D signalpos0;
    public V3D signalpos1;
    public double signalrot0;
    public double signalrot1;
    public Double bufferrot;

    public Junction(SystemRegion<RailSystem, Junction> reg, QV3D pos) {
        this(reg);
        this.vecpos = pos;
    }

    public Junction(SystemRegion<RailSystem, Junction> region) {
        this.root = (RailSystem)region.system;
        this.region = region;
        this.tracks = new ArrayList();
        this.switch1 = false;
        this.switch0 = false;
        this.type = JuncType.STRAIGHT;
    }

    public Junction setRoot(RailSystem data) {
        this.root = data;
        return this;
    }

    @Override
    public void read(TagCW compound) {
        this.vecpos = new QV3D(compound, "Pos");
        this.switch0 = compound.getBoolean("Switch0");
        this.switch1 = compound.getBoolean("Switch1");
        int trackam = compound.getInteger("Tracks");
        if (trackam > 0) {
            if (this.root.getWorld().isClient()) {
                for (Track track : this.tracks) {
                    if (track.railmodel != null) {
                        track.railmodel.clearGL();
                    }
                    if (track.restmodel != null) {
                        track.restmodel.clearGL();
                    }
                    track.restmodel = null;
                    track.railmodel = null;
                }
                this.signalpos1 = null;
                this.signalpos0 = null;
                this.bufferrot = null;
            }
            this.tracks.clear();
            for (int i = 0; i < trackam; ++i) {
                try {
                    this.tracks.add(new Track(this).read(compound.getCompound("Track" + i)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.tracks.clear();
        }
        this.frustumbb = null;
        if (compound.has("SignalType")) {
            this.signal = SignalType.valueOf(compound.getString("SignalType"));
        }
        if (compound.has("SignalDir")) {
            this.signal_dir = EntryDirection.getFromSaveByte((byte)compound.getInteger("SignalDir"));
        }
        this.type = this.tracks.size() > 2 ? (compound.has("Type") ? JuncType.valueOf(compound.getString("Type")) : JuncType.byTracksAmount(this.size())) : JuncType.STRAIGHT;
        String string = this.station = compound.has("Station") ? compound.getString("Station") : null;
        if (compound.has("JunctionCommands")) {
            this.forswitch.clear();
            compound.getList("JunctionCommands").forEach(tag -> {
                JEC cmd = JEC.read(tag);
                if (cmd != null) {
                    this.forswitch.add(cmd);
                }
            });
        }
        if (compound.has("EntityCommands")) {
            this.forswitch.clear();
            compound.getList("EntityCommands").forEach(tag -> {
                JEC cmd = JEC.read(tag);
                if (cmd != null) {
                    this.fortrains.add(cmd);
                }
            });
        }
        if (this.signal != null) {
            this.signal0 = compound.getBoolean("Signal0");
            this.signal1 = compound.getBoolean("Signal1");
        }
        this.entities.clear();
        if (compound.has("LinkedBlocks")) {
            TagLW list = (TagLW)compound.getList("LinkedBlocks").local();
            for (int i = 0; i < list.size(); ++i) {
                this.entities.add(new V3I(list.getList(i)));
            }
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void delete() {
    }

    @Override
    public TagCW write() {
        TagCW compound = TagCW.create();
        for (int i = 0; i < this.tracks.size(); ++i) {
            compound.set("Track" + i, this.tracks.get(i).write(null));
        }
        compound.set("Tracks", this.tracks.size());
        compound.set("Switch0", this.switch0);
        compound.set("Switch1", this.switch1);
        this.vecpos.write(compound, "Pos");
        if (this.signal != null) {
            compound.set("SignalType", this.signal.name());
        }
        if (this.signal_dir != null) {
            compound.set("SignalDir", (int)this.signal_dir.getSaveByte());
        }
        if (this.tracks.size() > 2) {
            compound.set("Type", this.type.name());
        }
        if (this.station != null) {
            compound.set("Station", this.station);
        }
        if (!this.forswitch.isEmpty()) {
            TagLW list = TagLW.create();
            for (JEC cmd : this.forswitch) {
                list.add(cmd.write(null));
            }
            compound.set("JunctionCommands", list);
        }
        if (!this.fortrains.isEmpty()) {
            TagLW list = TagLW.create();
            for (JEC cmd : this.fortrains) {
                list.add(cmd.write(null));
            }
            compound.set("EntityCommands", list);
        }
        if (this.signal != null) {
            compound.set("Signal0", this.signal0);
            compound.set("Signal1", this.signal1);
        }
        if (!this.entities.isEmpty()) {
            TagLW list = TagLW.create();
            for (V3I pos : this.entities) {
                list.add(pos.toLW());
            }
            compound.set("LinkedBlocks", list);
        }
        return compound;
    }

    public QV3D getPos() {
        return this.vecpos;
    }

    public V3I getV3I() {
        return this.vecpos.pos;
    }

    public V3D getV3D() {
        return this.vecpos.vec;
    }

    public void addnew(Track track) {
        this.tracks.add(track);
        this.type = JuncType.byTracksAmount(this.size());
        if (this.signal != null) {
            this.setSignal(null, null);
        }
        this.updateClient();
    }

    public void checkTrackSectionConsistency() {
        if (this.tracks.size() < 2) {
            return;
        }
        if (this.tracks.size() == 2 && this.signal != null) {
            Section sec0 = this.tracks.get((int)0).unit.section();
            Section sec1 = this.tracks.get((int)1).unit.section();
            if (sec0.getUID() == sec1.getUID()) {
                sec0.splitAtSignal(this);
            }
            return;
        }
        boolean fuse = false;
        Track zero = this.tracks.get(0);
        for (int i = 1; i < this.tracks.size(); ++i) {
            if (zero.unit.getSectionId() == this.tracks.get((int)i).unit.getSectionId()) continue;
            fuse = true;
            break;
        }
        if (fuse) {
            zero.unit.section().fuseAtTrack(zero);
        }
    }

    public void updateClient() {
        this.root.updateClient("junction", this.vecpos.pos);
    }

    public void remove(int index, boolean firstcall) {
        Track track = this.tracks.remove(index);
        if (track == null) {
            return;
        }
        if (this.signal != null) {
            this.setSignal(null, null);
        }
        if (!firstcall) {
            track.unit.section().splitAtTrack(track);
            track.unit.section().remove(track);
        }
        this.type = JuncType.byTracksAmount(this.size());
        this.updateClient();
        if (firstcall) {
            Junction junk = this.root.getJunction(track.start.equals(this.vecpos) ? track.end.pos : track.start.pos);
            if (junk != null) {
                junk.remove(track.getOppositeId(), false);
            }
        } else {
            this.checkTrackSectionConsistency();
        }
    }

    private void remove(PathKey key, boolean firstcall) {
        for (int i = 0; i < this.tracks.size(); ++i) {
            if (!this.tracks.get(i).getId().equals(key)) continue;
            this.remove(i, firstcall);
            return;
        }
    }

    public void clear() {
        ArrayList<Track> trecks = new ArrayList<Track>();
        for (Track track : this.tracks) {
            trecks.add(track);
        }
        for (Track track : trecks) {
            this.remove(track.getId(), true);
        }
        this.tracks.clear();
        this.updateClient();
    }

    public Track getNext(RailEntity entity, PathKey track, boolean applystate) {
        if (entity != null && this.fortrains.size() > 0) {
            Track track0 = this.getNext0(entity, track, applystate);
            for (JEC cmd : this.fortrains) {
                if (!cmd.isTarget(entity)) continue;
                entity.commands.add(cmd.copy());
            }
            return track0;
        }
        return this.getNext0(entity, track, applystate);
    }

    public Track getNext0(RailEntity entity, PathKey track, boolean applystate) {
        if (this.type == null) {
            JuncType juncType = this.size() <= 2 ? JuncType.STRAIGHT : (this.type = this.size() == 3 ? JuncType.FORK_2 : JuncType.CROSSING);
        }
        if (entity != null) {
            for (JEC cmd : this.forswitch) {
                cmd.processSwitch(entity, this, track, this.getIndex(track), applystate);
            }
        }
        switch (this.type) {
            case STRAIGHT: {
                switch (this.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.eqTrack(track, 0) ? null : this.tracks.get(0);
                    }
                    case 2: {
                        return this.eqTrack(track, 0) ? this.tracks.get(1) : this.tracks.get(0);
                    }
                }
                break;
            }
            case FORK_2: {
                boolean bool;
                if (this.eqTrack(track, 0)) {
                    return this.tracks.get(this.switch0 ? 1 : 2);
                }
                if (applystate && this.switch0 != (bool = this.eqTrack(track, 1))) {
                    this.switch0 = bool;
                    this.root.updateClient("junction_state", this.vecpos.pos);
                    this.updateLinkedTileEntities(false);
                }
                return this.tracks.get(0);
            }
            case FORK_3: {
                if (this.eqTrack(track, 0)) {
                    return this.tracks.get(this.switch0 ? 1 : (this.switch1 ? 3 : 2));
                }
                if (applystate) {
                    boolean bool0 = this.eqTrack(track, 1);
                    boolean bool1 = this.eqTrack(track, 2);
                    if (bool0 && !this.switch0) {
                        this.switch0 = true;
                        this.switch1 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    } else if (bool1 && (this.switch0 || this.switch1)) {
                        this.switch0 = false;
                        this.switch1 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    } else if (!bool1 && !this.switch1) {
                        this.switch0 = false;
                        this.switch1 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                }
                return this.tracks.get(0);
            }
            case CROSSING: {
                if (this.eqTrack(track, 0)) {
                    return this.tracks.get(1);
                }
                if (this.eqTrack(track, 1)) {
                    return this.tracks.get(0);
                }
                if (this.eqTrack(track, 2)) {
                    return this.tracks.get(3);
                }
                if (!this.eqTrack(track, 3)) break;
                return this.tracks.get(2);
            }
            case DOUBLE: {
                if (this.eqTrack(track, 0)) {
                    if (applystate && !this.switch1) {
                        this.switch1 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch0 ? 1 : 2);
                }
                if (this.eqTrack(track, 1)) {
                    if (applystate && !this.switch0) {
                        this.switch0 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch1 ? 0 : 3);
                }
                if (this.eqTrack(track, 2)) {
                    if (applystate && this.switch0) {
                        this.switch0 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch1 ? 0 : 3);
                }
                if (!this.eqTrack(track, 3)) break;
                if (applystate && this.switch1) {
                    this.switch1 = false;
                    this.root.updateClient("junction_state", this.vecpos.pos);
                    this.updateLinkedTileEntities(false);
                }
                return this.tracks.get(this.switch0 ? 1 : 2);
            }
        }
        return null;
    }

    public final boolean eqTrack(PathKey track, int i) {
        return this.tracks.get(i).getId().equals(track);
    }

    public boolean allowsSpawningOn() {
        return true;
    }

    public Track getTrack(PathKey key) {
        for (Track track : this.tracks) {
            if (!track.getId().equals(key)) continue;
            return track;
        }
        return null;
    }

    public int size() {
        return this.tracks.size();
    }

    public void onUpdate() {
        if (this.isDecorational()) {
            return;
        }
        this.pollSignal(null);
    }

    private boolean isDecorational() {
        return this.tracks.size() == 0 || this.tracks.get((int)0).gauge.getWidth() < 0.0f;
    }

    public void pollSignal(RailEntity ent) {
        if (this.signal == null) {
            return;
        }
        boolean oldsig0 = this.signal0;
        boolean oldsig1 = this.signal1;
        if (this.signal.type == SignalType.Kind.BLOCK) {
            if (this.signal_dir.isBoth()) {
                this.signal0 = this.tracks.get((int)0).unit.section().isFree(ent);
                this.signal1 = this.tracks.get((int)1).unit.section().isFree(ent);
            } else {
                this.signal0 = this.tracks.get((int)(this.signal_dir.isForward() ? 1 : 0)).unit.section().isFree(ent);
            }
        }
        if (oldsig0 != this.signal0 || oldsig1 != this.signal1) {
            this.root.updateClient("junction_signal_state", this.vecpos.pos);
            this.updateLinkedTileEntities(true);
        }
    }

    private boolean isInPlayerRange() {
        for (EntityW pl : this.root.getWorld().getPlayers()) {
            if (!(this.vecpos.vec.dis(pl.getPos()) < 1024.0)) continue;
            return true;
        }
        return false;
    }

    public boolean onSwitchInteract(EntityW player, Object tile, boolean left) {
        if (this.type == JuncType.STRAIGHT) {
            player.send("&cThis Junction has only 2 tracks! It cannot be switched.");
            return true;
        }
        if (this.type.isCrossing()) {
            player.send("&cThis Junction is a Crossing. It cannot be switched!");
            return true;
        }
        if (this.type.isSwitch()) {
            if (this.type == JuncType.FORK_2) {
                this.switch0 = !this.switch0;
                player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : 1) + "]");
            } else {
                if (this.switch1) {
                    this.switch1 = false;
                    this.switch0 = true;
                } else if (this.switch0) {
                    this.switch1 = false;
                    this.switch0 = false;
                } else if (!this.switch1) {
                    this.switch0 = false;
                    this.switch1 = true;
                }
                player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : (this.switch1 ? 2 : 1)) + "]");
            }
        }
        if (this.type.isDouble()) {
            if (left) {
                this.switch1 = !this.switch1;
            } else {
                this.switch0 = !this.switch0;
            }
            player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : 1) + "-" + (this.switch1 ? 0 : 1) + "]");
        }
        this.root.updateClient("junction_state", this.vecpos.pos);
        this.updateLinkedTileEntities(false);
        return true;
    }

    private void updateLinkedTileEntities(boolean signal) {
        this.entities.removeIf(pos -> {
            WorldW world = this.root.getWorld();
            if (!world.isPositionLoaded(pos)) {
                return false;
            }
            return false;
        });
    }

    public void unlinkLinkedTileEntities() {
        for (V3I pos : this.entities) {
            WorldW world = this.root.getWorld();
            if (world.isPositionLoaded(pos)) continue;
        }
    }

    public void addLinkedTileEntity(V3I pos) {
        if (!this.entities.contains(pos)) {
            this.entities.add(pos);
        }
    }

    public int getIndex(PathKey key) {
        for (int i = 0; i < this.tracks.size(); ++i) {
            if (!this.eqTrack(key, i)) continue;
            return i;
        }
        return -1;
    }

    public AABB getAABB() {
        if (this.frustumbb != null) {
            return this.frustumbb;
        }
        V3D min = new V3D();
        V3D max = new V3D();
        for (Track track : this.tracks) {
            V3D other = track.start.vec;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (other.z > max.z) {
                max.z = other.z;
            }
            other = track.end.vec;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (!(other.z > max.z)) continue;
            max.z = other.z;
        }
        if (this.size() == 0) {
            min = this.vecpos.vec.add(-0.5, -0.5, -0.5);
            max = this.vecpos.vec.add(0.5, 0.5, 0.5);
        }
        this.frustumbb = AABB.create(min.x, min.y, min.z, max.x, max.y, max.z);
        return this.frustumbb;
    }

    public void setSignal(SignalType signal, EntryDirection entrydir) {
        if (entrydir == null) {
            entrydir = EntryDirection.FORWARD;
        }
        if (signal == null) {
            this.signal = null;
            this.signal_dir = entrydir;
        } else {
            this.signal = signal;
            this.signal_dir = entrydir;
        }
        this.root.updateClient("junction_signal", this.vecpos.pos);
    }

    public boolean getSignalState(EntryDirection dir) {
        if (this.signal_dir.isBoth()) {
            return dir.isForward() ? this.signal1 : this.signal0;
        }
        return dir == this.signal_dir ? this.signal0 : true;
    }

    public boolean hasSignal(PathKey track) {
        if (track == null || this.signal == null) {
            return this.signal != null;
        }
        if (this.signal_dir.isBoth()) {
            return true;
        }
        return this.eqTrack(track, 0) ? this.signal_dir.isForward() : this.signal_dir.isBackward();
    }

    public boolean getSignalState(PathKey track) {
        return this.getSignalState(this.eqTrack(track, 0) ? EntryDirection.FORWARD : EntryDirection.BACKWARD);
    }

    public String toString() {
        return "Junction{ " + this.vecpos + ", " + this.tracks.size() + ", " + (Object)((Object)this.signal_dir) + " }";
    }

    public String posString() {
        return this.vecpos.pos.x + ", " + this.vecpos.pos.y + ", " + this.vecpos.pos.z;
    }

    public Junction updateVecPos(QV3D vector) {
        this.vecpos = vector;
        return this;
    }
}

