/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.sign;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimerTask;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class SignSystem
extends DetachedSystem<SignSystem, SignInstance> {
    private long gc_trafficsigns;

    public SignSystem(WorldW world) {
        super(world);
        if (!world.isClient()) {
            this.load();
        }
    }

    @Override
    public SystemManager.Systems getType() {
        return SystemManager.Systems.SIGN;
    }

    public void load() {
        try {
            TagCW compound;
            File file = new File(this.getSaveRoot(), "/traffic_signs.dat");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if ((compound = WrapperHolder.read((File)file)) == null || compound.empty()) {
                return;
            }
            this.gc_trafficsigns = compound.getLong("GlobalCounterSigns");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        TagCW compound = TagCW.create();
        compound.set("GlobalCounterSigns", this.gc_trafficsigns);
        try {
            File file = new File(this.getSaveRoot(), "/traffic_signs.dat");
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            WrapperHolder.write((TagCW)compound, (File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onServerTick() {
        for (SystemRegion systemRegion : this.regions.values()) {
        }
    }

    @Override
    public void unload() {
        if (!this.world.isClient()) {
            this.regions.values().forEach(reg -> reg.save());
            this.save();
        }
        this.regions.clear();
    }

    @Override
    public void onChunkLoad(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.put(new RegionKey(chunk.x(), chunk.z()), chunk);
    }

    @Override
    public void onChunkUnload(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.values().removeIf(pre -> pre.x() == chunk.x() && pre.z() == chunk.z());
    }

    public long getNewSignId() {
        return this.gc_trafficsigns++;
    }

    @Override
    public boolean hasTimer() {
        return true;
    }

    @Override
    public void addTimerTask(long time) {
        this.timer.schedule((TimerTask)new TimedTask(this), new Date(time), (long)Config.UNLOAD_INTERVAL);
    }

    @Override
    public String getRegFolderName() {
        return "signregions";
    }

    @Override
    public void onClientTick() {
    }

    @Override
    public SignInstance create(SystemRegion<SignSystem, SignInstance> region, V3I pos) {
        return new SignInstance(region, pos);
    }

    @Override
    public void writeRegion(SystemRegion<SignSystem, SignInstance> region, TagCW com) {
        if (!region.getObjects().isEmpty()) {
            TagLW list = TagLW.create();
            for (SignInstance sign : region.getObjects().values()) {
                list.add(sign.write());
            }
            com.set("Signs", list);
        }
    }

    @Override
    public void readRegion(SystemRegion<SignSystem, SignInstance> region, TagCW com) {
        if (!com.has("Signs")) {
            return;
        }
        region.getObjects().clear();
        TagLW list = com.getList("Signs");
        for (TagCW tag : list) {
            SignInstance sign = new SignInstance(region);
            sign.read(tag);
            region.getObjects().put(sign.vec.pos, sign);
        }
    }

    public static class TimedTask
    extends TimerTask {
        private SignSystem signsys;

        public TimedTask(SignSystem ssys) {
            this.signsys = ssys;
        }

        @Override
        public void run() {
            ArrayList<SystemRegion> regs = new ArrayList<SystemRegion>();
            for (SystemRegion region : this.signsys.regions.values()) {
                if (!region.chucks.isEmpty() || region.lastaccess >= Time.getDate() - 60000L) continue;
                regs.add(region);
            }
            for (SystemRegion region : regs) {
                region.save();
                this.signsys.regions.remove(region.key);
            }
        }
    }
}

