/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.PacketHandler;
import net.fexcraft.lib.mc.network.packet.PacketEntityUpdate;
import net.fexcraft.lib.mc.network.packet.PacketNBTTagCompound;
import net.fexcraft.lib.mc.utils.ApiUtil;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.PassCap;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.event.EventHandler;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.PacketsImpl;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.impl.TagCWI;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.EntityWIE;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RootVehicle
extends Entity
implements IEntityAdditionalSpawnData,
IPacketReceiver<PacketEntityUpdate> {
    public VehicleInstance vehicle = new VehicleInstance(new EntityWIE(this), null, this.isAdv());
    public float rotationRoll = 0.0f;
    public float prevRotationRoll = 0.0f;
    public boolean should_sit = true;

    public RootVehicle(World world) {
        super(world);
    }

    protected void init(TagCW com) {
        this.func_70105_a(this.vehicle.data.getAttribute("hitbox_width").asFloat(), this.vehicle.data.getAttribute("hitbox_height").asFloat());
    }

    public boolean isAdv() {
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        TagCW com = TagCW.wrap((Object)compound);
        this.field_70126_B = com.getFloat("RotationYaw");
        this.field_70127_C = com.getFloat("RotationPitch");
        this.prevRotationRoll = com.getFloat("RotationRoll");
        this.vehicle.init(null, com);
        this.init(com);
    }

    protected void func_70014_b(NBTTagCompound compound) {
        TagCW com = TagCW.wrap((Object)compound);
        this.vehicle.data.write(com);
        this.vehicle.point.savePivot(com);
    }

    public void writeSpawnData(ByteBuf buffer) {
        TagCW com = TagCW.create();
        this.vehicle.point.savePivot(com);
        this.writeSpawnData(com);
        this.vehicle.data.write(com);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)((NBTTagCompound)com.local()));
    }

    public void writeSpawnData(TagCW com) {
    }

    public void readSpawnData(TagCW com) {
    }

    public void readSpawnData(ByteBuf buffer) {
        try {
            TagCW com = TagCW.wrap((Object)ByteBufUtils.readTag((ByteBuf)buffer));
            this.vehicle.init(null, com);
            this.readSpawnData(com);
            this.init(com);
            this.field_70126_B = this.vehicle.point.getPivot().deg_yaw();
            this.field_70127_C = this.vehicle.point.getPivot().deg_pitch();
            this.prevRotationRoll = this.vehicle.point.getPivot().deg_roll();
        }
        catch (Exception e) {
            e.printStackTrace();
            FvtmLogger.log((Object)("Failed to receive additional spawn data for vehicle entity with ID " + this.func_145782_y() + "!"));
        }
    }

    public void func_70106_y() {
        if (this.vehicle != null) {
            this.vehicle.onRemove();
        }
        super.func_70106_y();
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posrotincr, boolean teleport) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public AxisAlignedBB func_174813_aQ() {
        return super.func_174813_aQ();
    }

    public boolean func_184222_aU() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public double func_70042_X() {
        return 0.0;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public double func_70033_W() {
        return 0.0;
    }

    public void func_70100_b_(EntityPlayer player) {
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_180430_e(float distance, float multiplier) {
    }

    public String func_70005_c_() {
        return this.vehicle.data.getName();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double dist) {
        return Config.RENDER_OUT_OF_VIEW ? true : super.func_70112_a(dist);
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70114_g(this);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70128_L || hand == EnumHand.OFF_HAND) {
            return false;
        }
        int res = this.vehicle.onInteract((Passenger)UniEntity.getEntity((Object)player), UniStack.getStack((Object)player.func_184614_ca()));
        return res >= 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L) {
            return;
        }
        if (this.vehicle.data == null) {
            FvtmLogger.log((Object)("Vehicle '" + this.func_145782_y() + "' has no data, skipping update."));
            return;
        }
        ++this.field_70173_aa;
        if (this.field_70173_aa >= Integer.MAX_VALUE) {
            this.field_70173_aa = 0;
        }
        this.field_70126_B = this.vehicle.point.getPivot().deg_yaw();
        this.field_70127_C = this.vehicle.point.getPivot().deg_pitch();
        this.prevRotationRoll = this.vehicle.point.getPivot().deg_roll();
        this.vehicle.onUpdate();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % Config.VEHICLE_SYNC_RATE == 0) {
            this.vehicle.sendUpdatePacket();
        }
    }

    public Entity func_184179_bs() {
        return null;
    }

    public void func_184232_k(Entity pass) {
        SeatInstance seat = this.getSeatOf(pass);
        if (seat != null) {
            this.updatePassenger(pass, seat);
        } else {
            if (this.field_70170_p.field_72995_K) {
                ((PassCap)pass.getCapability(Capabilities.PASSENGER, null)).reconn(true);
            }
            pass.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void updatePassenger(Entity pass, SeatInstance seat) {
        if (seat.passenger_direct() != pass) {
            seat.passenger(((PassCap)pass.getCapability(Capabilities.PASSENGER, null)).asWrapper());
        }
        V3D pos = seat.getCurrentGlobalPosition();
        pass.func_70107_b(pos.x, pos.y - (pass instanceof EntityPlayer ? 0.7 : 0.0), pos.z);
        if (!this.field_70170_p.field_72995_K && pass instanceof EntityPlayerMP) {
            EventHandler.resetFlight((EntityPlayerMP)pass);
        }
    }

    public void func_184200_o(Entity pass) {
        super.func_184200_o(pass);
        SeatInstance seat = this.getSeatOf(pass);
        if (seat != null) {
            seat.passenger(((PassCap)pass.getCapability(Capabilities.PASSENGER, null)).asWrapper());
        }
    }

    public void func_184225_p(Entity pass) {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!pass.equals(seat.passenger_direct())) continue;
            seat.passenger(null);
        }
        if (!this.field_70170_p.field_72995_K) {
            ((PassCap)pass.getCapability(Capabilities.PASSENGER, null)).set(-1, -1);
        }
        super.func_184225_p(pass);
    }

    public void func_184226_ay() {
        super.func_184226_ay();
    }

    protected boolean func_184219_q(Entity passenger) {
        return true;
    }

    public boolean shouldRiderSit() {
        return this.should_sit;
    }

    public void updateSittingState(Entity pass) {
        SeatInstance seat = this.getSeatOf(pass);
        if (seat != null) {
            this.should_sit = seat.seat.sitting;
        }
    }

    public SeatInstance getSeatOf(Entity entity) {
        PassCap pass = (PassCap)entity.getCapability(Capabilities.PASSENGER, null);
        if (pass == null || pass.seat() < 0 || this.vehicle.seats.isEmpty() || pass.seat() >= this.vehicle.seats.size()) {
            return null;
        }
        return this.vehicle.seats.get(pass.seat());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        if (source.field_76373_n.equals("player") && this.vehicle.driver() == null) {
            EngineFunction engine;
            EntityPlayer player = (EntityPlayer)source.func_76364_f();
            if (this.vehicle.data.getLock().isLocked()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("interact.fvtm.vehicle.remove_locked", new Object[0]), true);
                return false;
            }
            EngineFunction engineFunction = engine = this.vehicle.data.hasPart("engine") ? (EngineFunction)this.vehicle.data.getFunctionInPart("engine", "fvtm:engine") : null;
            if (engine != null) {
                engine.setState(false);
            }
            if (this.vehicle.type.isRailVehicle()) {
                this.vehicle.railent.remove();
            } else {
                VehicleInstance trailer = this.vehicle;
                while ((trailer = trailer.rear) != null) {
                    Entity rear = (Entity)trailer.entity.local();
                    rear.func_70099_a((ItemStack)trailer.data.newItemStack().local(), 0.5f);
                    rear.func_70106_y();
                }
            }
            this.func_70099_a((ItemStack)this.vehicle.data.newItemStack().local(), 0.5f);
            this.func_70106_y();
            return true;
        }
        return true;
    }

    public ItemStack getPickedResult(RayTraceResult rtr) {
        return (ItemStack)this.vehicle.data.newItemStack().local();
    }

    public boolean processSeatInteract(int seatidx, EntityPlayerMP player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K || seatidx < 0 || seatidx >= this.vehicle.seats.size()) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        SeatInstance seat = this.vehicle.seats.get(seatidx);
        PassCap pass = (PassCap)player.getCapability(Capabilities.PASSENGER, null);
        if (Lockable.isKey(FvtmRegistry.getItem(stack.func_77973_b().getRegistryName().toString())) && !this.isFuelContainer(stack.func_77973_b())) {
            this.vehicle.data.getLock().toggle(pass.asSender(), UniStack.getStack((Object)stack));
            this.sendLockStateUpdate();
            return true;
        }
        if (this.vehicle.data.getLock().isLocked()) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("interact.fvtm.vehicle.locked", new Object[0]), true);
            return true;
        }
        if (seat.interacttimer > 0) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemLead) {
            if (seat.passenger() != null) {
                if (seat.passenger().isPlayer()) {
                    return false;
                }
                if (seat.passenger().isLiving()) {
                    EntityLiving ent = (EntityLiving)seat.passenger().local();
                    ent.func_184210_p();
                    ent.func_110162_b((Entity)player, true);
                    seat.interacttimer = (byte)(seat.interacttimer + 10);
                    return true;
                }
            }
            double range = 10.0;
            V3D pos = new V3D(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            AxisAlignedBB aabb = new AxisAlignedBB(pos.x - range, pos.y - range, pos.z - range, pos.x + range, pos.y + range, pos.z + range);
            List nearbyMobs = this.field_70170_p.func_72872_a(EntityLiving.class, aabb);
            for (EntityLiving entity : nearbyMobs) {
                if (!entity.func_110167_bD() || entity.func_110166_bE() != player) continue;
                if (!seat.seat.allow(((PassCap)entity.getCapability(Capabilities.PASSENGER, null)).asWrapper())) {
                    Print.bar((EntityPlayer)player, (String)("&eSeat does not accept this entity kind. (" + entity.func_70005_c_() + ")"));
                    continue;
                }
                ((PassCap)entity.getCapability(Capabilities.PASSENGER, null)).set(this.func_145782_y(), seatidx);
                seat.elook.set_rotation(-entity.field_70177_z, entity.field_70125_A, 0.0f, true);
                entity.func_110160_i(true, !player.field_71075_bZ.field_75098_d);
                entity.func_184220_m((Entity)this);
                break;
            }
            seat.interacttimer = (byte)(seat.interacttimer + 10);
            return true;
        }
        if (seat.passenger() == null) {
            if (!seat.seat.allow(pass.asWrapper())) {
                Print.bar((EntityPlayer)player, (String)"&eSeat does not accept players as passengers.");
                return false;
            }
            if (player.func_184218_aH() && player.func_184187_bx().equals((Object)this.vehicle)) {
                SeatInstance oseat = this.vehicle.getSeatOf(player);
                oseat.passenger(null);
                pass.set(this.func_145782_y(), seatidx);
                seat.passenger(pass.asWrapper());
            } else {
                player.func_184210_p();
                ((PassCap)player.getCapability(Capabilities.PASSENGER, null)).set(this.func_145782_y(), seatidx);
                player.func_184220_m((Entity)this);
            }
            seat.interacttimer = (byte)(seat.interacttimer + 10);
            return true;
        }
        return false;
    }

    private boolean isFuelContainer(Item item) {
        if (!(item instanceof MaterialItem)) {
            return false;
        }
        return ((MaterialItem)item).getContent().isFuelContainer();
    }

    public void sendLockStateUpdate() {
        NBTTagCompound packet = new NBTTagCompound();
        packet.func_74778_a("target_listener", "fvtm:utils");
        packet.func_74778_a("task", "lock_state");
        packet.func_74757_a("state", this.vehicle.data.getLock().isLocked());
        packet.func_74768_a("entity", this.func_145782_y());
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketNBTTagCompound(packet), PacketsImpl.getTargetPoint(this));
    }

    public void sendColorChannelUpdate(String channel) {
        NBTTagCompound packet = new NBTTagCompound();
        packet.func_74778_a("target_listener", "fvtm:utils");
        packet.func_74778_a("task", "color_channel");
        packet.func_74778_a("channel", channel);
        packet.func_74768_a("color", this.vehicle.data.getColorChannel((String)channel).packed);
        packet.func_74768_a("entity", this.func_145782_y());
        PacketHandler.getInstance().sendToAllAround((IMessage)new PacketNBTTagCompound(packet), PacketsImpl.getTargetPoint(this));
    }

    public void processServerPacket(PacketEntityUpdate packet) {
        if (!packet.nbt.func_74764_b("task")) {
            return;
        }
        switch (packet.nbt.func_74779_i("task")) {
            case "resync": {
                NBTTagCompound nbt = (NBTTagCompound)this.vehicle.data.write(TagCW.create()).local();
                nbt.func_74778_a("task", "update_vehicledata");
                ApiUtil.sendEntityUpdatePacketToAllAround((Entity)this, (NBTTagCompound)nbt);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void processClientPacket(PacketEntityUpdate packet) {
        if (!packet.nbt.func_74764_b("task")) {
            return;
        }
        switch (packet.nbt.func_74779_i("task")) {
            case "resync": 
            case "update_vehicledata": {
                this.vehicle.data.read((TagCW)new TagCWI(packet.nbt));
                break;
            }
            case "toggle_lights": {
                this.vehicle.data.getAttribute("lights").set(packet.nbt.func_74767_n("lights"));
                this.vehicle.data.getAttribute("lights_long").set(packet.nbt.func_74767_n("lights_long"));
                VehicleInstance rear = this.vehicle.rear;
                while (rear != null) {
                    rear.data.getAttribute("lights").set(packet.nbt.func_74767_n("lights"));
                    rear.data.getAttribute("lights_long").set(packet.nbt.func_74767_n("lights_long"));
                    rear = rear.rear;
                }
                break;
            }
        }
    }

    public boolean isBraking() {
        return false;
    }

    public void onPacket(EntityW player, TagCW packet) {
    }
}

