/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.sys.wire.WireUnit;

public class WireSection {
    private long uid;
    private WireSystem data;
    private HashSet<WireUnit> units = new HashSet();

    public WireSection(WireSystem data, Long sid) {
        this.data = data;
        this.uid = sid == null ? data.getNewSectionId() : sid.longValue();
        FvtmLogger.debug((Object)("Created Section [" + sid + "] " + (sid == null)));
    }

    public WireSection fill(WireUnit ... wires) {
        for (WireUnit wire : wires) {
            this.units.add(wire);
        }
        return this;
    }

    public WireSection fill(Collection<WireUnit> wires) {
        this.units.addAll(wires);
        return this;
    }

    public void insert(WireUnit unit) {
        this.units.add(unit);
    }

    public long getUID() {
        return this.uid;
    }

    public void fuseAtWire(Wire zero) {
        FvtmLogger.debug((Object)("Fusing sections at wire: " + zero));
        WireSection old = null;
        ArrayList<WireUnit> list = new ArrayList<WireUnit>();
        list.add(zero.unit);
        list = this.explore(this.data.getRelay(zero.key), list);
        list = this.explore(this.data.getRelay(zero.okey), list);
        for (WireUnit unit : list) {
            if (unit.getSectionId() == this.uid) continue;
            old = unit.section();
            old.units.remove(unit);
            unit.setSection(this);
            FvtmLogger.debug((Object)("Added into section '" + this.uid + "': " + unit));
            if (old.units.size() != 0) continue;
            this.data.getSections().remove(old.getUID());
            FvtmLogger.debug((Object)("Removing section '" + old.getUID() + "'!"));
        }
        this.units.clear();
        this.units.addAll(list);
    }

    public void splitAtWire(Wire wire) {
        ArrayList<WireUnit> less;
        FvtmLogger.debug((Object)("Splitting section at wire: " + wire));
        ArrayList<WireUnit> list0 = new ArrayList<WireUnit>();
        ArrayList<WireUnit> list1 = new ArrayList<WireUnit>();
        list0 = this.explore(this.data.getRelay(wire.key), list0);
        list1 = this.explore(this.data.getRelay(wire.okey), list1);
        for (WireUnit unit : list0) {
            if (!list1.contains(unit)) continue;
            return;
        }
        ArrayList<WireUnit> arrayList = less = list0.size() > list1.size() ? list1 : list0;
        if (less.isEmpty()) {
            return;
        }
        WireSection section = this.data.getSection(null);
        for (WireUnit unit : less) {
            unit.setSection(section);
        }
        this.units.removeAll(less);
        section.units.addAll(less);
        FvtmLogger.debug((Object)("Created section '" + section.getUID() + "' and assigned WireUnits."));
    }

    public void splitAtSignal(WireRelay relay) {
        FvtmLogger.debug((Object)("Splitting section at relay: " + relay));
        ArrayList<WireUnit> list0 = new ArrayList<WireUnit>();
        ArrayList<WireUnit> list1 = new ArrayList<WireUnit>();
        list0.add(relay.wires.get((int)0).unit);
        list1.add(relay.wires.get((int)1).unit);
        list0 = this.explore(this.data.getRelay(relay.wires.get((int)0).okey), list0);
        list1 = this.explore(this.data.getRelay(relay.wires.get((int)1).okey), list1);
        for (WireUnit unit : list0) {
            if (!list1.contains(unit)) continue;
            return;
        }
        ArrayList<WireUnit> less = list0.size() > list1.size() ? list1 : list0;
        if (less.isEmpty()) {
            return;
        }
        WireSection section = this.data.getSection(null);
        for (WireUnit unit : less) {
            unit.setSection(section);
        }
        this.units.removeAll(less);
        section.units.addAll(less);
        FvtmLogger.debug((Object)("Created section '" + section.getUID() + "' and assigned WireUnits."));
    }

    private ArrayList<WireUnit> explore(WireRelay relay, ArrayList<WireUnit> list) {
        if (relay == null) {
            return list;
        }
        ArrayList<Wire> wires = new ArrayList<Wire>();
        wires.addAll(relay.wires);
        for (Wire wire : wires) {
            if (list.contains(wire.unit)) continue;
            list.add(wire.unit);
            list = this.explore(this.data.getRelay(wire.okey, true), list);
        }
        return list;
    }

    public int size() {
        return this.units.size();
    }

    public boolean remove(Wire wire) {
        return this.units.remove(wire.unit);
    }

    public boolean remove(WireUnit unit) {
        return this.units.remove(unit);
    }
}

