/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class RoadToolCon
extends ContainerInterface {
    public static final String[] fills = new String[]{"RoadFill", "BottomFill", "SideLeftFill", "SideRightFill", "TopFill", "LinesFill", "SlabFill"};
    protected StackWrapper stack;
    protected boolean custom_road;
    protected boolean custom_top;
    protected boolean custom_lines;

    public RoadToolCon(JsonMap map, UniEntity player, V3I pos) {
        super(map, player, pos);
        this.stack = player.entity.getHeldItem(true);
        this.custom_road = this.stack.directTag().has("CustomRoadFill");
        this.custom_top = this.stack.directTag().has("CustomTopFill");
        this.custom_lines = this.stack.directTag().has("CustomLinesFill");
        this.inventory = UniInventory.create((int)fills.length).stacksize(1).name("Road Fill Inventory");
        for (int i = 0; i < fills.length; ++i) {
            if (!this.stack.directTag().has(fills[i])) continue;
            this.inventory.set(i, this.stack.directTag().getCompound(fills[i]));
        }
    }

    public Object get(String key, Object ... objs) {
        return null;
    }

    public void packet(TagCW com, boolean client) {
        switch (com.getString("cargo")) {
            case "save": {
                this.stack.updateTag(tag -> tag.set("RoadLayers", com.getIntArray("sizes")));
                break;
            }
            case "custom": {
                this.player.entity.openUI(UIKeys.ROAD_TOOL_CUSTOM, new V3I(com.getInteger("layer"), 0, 0));
                break;
            }
            case "remove": {
                this.stack.updateTag(tag -> tag.rem("Custom" + fills[com.getInteger("layer")]));
                this.custom_road = this.stack.directTag().has("CustomRoadFill");
                this.custom_top = this.stack.directTag().has("CustomTopFill");
                this.custom_lines = this.stack.directTag().has("CustomLinesFill");
                if (client) break;
                SEND_TO_CLIENT.accept(com, this.player);
            }
        }
    }

    public void onClosed() {
        super.onClosed();
        this.stack.updateTag(com -> {
            for (int i = 0; i < fills.length; ++i) {
                if (!this.inventory.empty(i)) {
                    TagCW tag = TagCW.create();
                    this.inventory.get(i).save(tag);
                    com.set(fills[i], tag);
                    continue;
                }
                com.rem(fills[i]);
            }
        });
    }
}

